/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.shared.racemap.ManeuverAngleCache;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class ManeuverAngleCache {
    private static final Long TTL_MILLIS = 600000L;
    private static final Integer WIND_BUCKET_RESOLUTION = 1;
    private static final Integer WIND_BUCKET_INITIAL_CAP = 8;
    private final SailingServiceAsync sailingService;
    private final HashMap<Key, ArrayList<Util.Triple<Long, Bearing, Double>>> cache = new HashMap();
    private final HashSet<Util.Triple<BoatClassDTO, ManeuverType, Integer>> requestSet = new HashSet();
    private Bearing defaultAngle;
    private boolean overrideAngle;

    public ManeuverAngleCache(SailingServiceAsync sailingService, Bearing defaultAngle) {
        this(sailingService, defaultAngle, false);
    }

    public ManeuverAngleCache(SailingServiceAsync sailingService, Bearing defaultAngle, boolean overrideAngle) {
        this.sailingService = sailingService;
        this.defaultAngle = defaultAngle;
        this.overrideAngle = overrideAngle;
    }

    public void setDefaultAngle(Bearing defaultAngle) {
        this.defaultAngle = defaultAngle;
    }

    public Bearing getDefaultAngle() {
        return this.defaultAngle;
    }

    public void setOverrideAngle(boolean override) {
        this.overrideAngle = override;
    }

    public boolean isOverrideAngle() {
        return this.overrideAngle;
    }

    public Bearing getManeuverAngle(BoatClassDTO boatClass, ManeuverType maneuverType, Speed windSpeed) {
        Util.Triple entry = null;
        if (!this.overrideAngle) {
            Key key = new Key(this, boatClass, maneuverType);
            List windBuckets = (List)this.cache.get(key);
            if (windBuckets != null) {
                int index = ManeuverAngleCache.bucketIndex((Speed)windSpeed);
                if (index < windBuckets.size()) {
                    entry = (Util.Triple)windBuckets.get(index);
                }
                if (entry == null || (Long)entry.getA() < System.currentTimeMillis()) {
                    this.callGetManeuverAngle(boatClass, maneuverType, index);
                }
                if (entry == null) {
                    entry = this.getClosestEntry(windBuckets, index);
                }
            } else {
                this.callGetManeuverAngle(boatClass, maneuverType, ManeuverAngleCache.bucketIndex((Speed)windSpeed));
            }
        }
        Bearing result = this.defaultAngle;
        if (entry != null) {
            result = (Bearing)entry.getB();
        }
        return result;
    }

    private Util.Triple<Long, Bearing, Double> getClosestEntry(List<Util.Triple<Long, Bearing, Double>> windBuckets, int bucketIndex) {
        int size = windBuckets.size();
        Util.Triple<Long, Bearing, Double> result = null;
        int downIndex = bucketIndex - 1;
        int upIndex = bucketIndex + 1;
        while (downIndex >= 0 || upIndex < size) {
            if (downIndex >= 0 && downIndex < size && (result = windBuckets.get(downIndex)) != null) break;
            --downIndex;
            if (upIndex < size && (result = windBuckets.get(upIndex)) != null) break;
            ++upIndex;
        }
        return result;
    }

    private void callGetManeuverAngle(BoatClassDTO boatClass, ManeuverType maneuverType, int windSpeedBucket) {
        Util.Triple requestKey = new Util.Triple((Object)boatClass, (Object)maneuverType, (Object)windSpeedBucket);
        if (!this.requestSet.contains(requestKey)) {
            Speed windSpeed = ManeuverAngleCache.bucketAvgSpeed((int)windSpeedBucket);
            GWT.log((String)("callGetManeuverAngle: " + boatClass + ", " + maneuverType + ", " + windSpeed));
            this.sailingService.getManeuverAngle(boatClass, maneuverType, windSpeed, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            this.requestSet.add(requestKey);
        }
    }

    private static int bucketIndex(Speed windSpeed) {
        return (int)Math.floor(windSpeed.getKnots()) / WIND_BUCKET_RESOLUTION;
    }

    private static Speed bucketAvgSpeed(int bucketIndex) {
        double speed = (double)(bucketIndex * WIND_BUCKET_RESOLUTION) + (double)WIND_BUCKET_RESOLUTION.intValue() / 2.0;
        return new KnotSpeedImpl(speed);
    }

    public String toString() {
        return "ManeuverAngleCache [defaultAngle=" + this.defaultAngle + ", overrideAngle=" + this.overrideAngle + "]";
    }

    static /* synthetic */ HashMap access$0(ManeuverAngleCache maneuverAngleCache) {
        return maneuverAngleCache.cache;
    }

    static /* synthetic */ Integer access$1() {
        return WIND_BUCKET_INITIAL_CAP;
    }

    static /* synthetic */ Long access$2() {
        return TTL_MILLIS;
    }

    static /* synthetic */ HashSet access$3(ManeuverAngleCache maneuverAngleCache) {
        return maneuverAngleCache.requestSet;
    }
}

