/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.filter;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.sap.sailing.domain.common.dto.TagDTO;
import com.sap.sailing.gwt.ui.client.shared.filter.FilterWithUI;
import com.sap.sailing.gwt.ui.client.shared.filter.TagFilterWithUIFactory;
import com.sap.sse.common.filter.BinaryOperator;
import com.sap.sse.common.filter.FilterOperator;
import com.sap.sse.common.filter.NumberFilter;
import com.sap.sse.common.filter.TextFilter;
import com.sap.sse.common.filter.TextOperator;
import com.sap.sse.common.filter.ValueFilter;

public class TagValueFilterJsonDeSerializerUtil {
    public static final String FIELD_FILTER_NAME = "name";
    public static final String FIELD_FILTER_OPERATOR = "operator";
    public static final String FIELD_FILTER_VALUE = "value";
    public static final String FIELD_FILTER_TYPE = "type";
    public static final String VALUE_FILTER_TYPE = "ValueFilter";

    public static JSONObject serialize(ValueFilter<?, ?> filter) {
        JSONObject filterAsJsonObject = new JSONObject();
        filterAsJsonObject.put(FIELD_FILTER_NAME, (JSONValue)new JSONString(filter.getName()));
        filterAsJsonObject.put(FIELD_FILTER_OPERATOR, (JSONValue)new JSONString(filter.getOperator().getName()));
        filterAsJsonObject.put(FIELD_FILTER_VALUE, (JSONValue)new JSONString(filter.getValue().toString()));
        filterAsJsonObject.put(FIELD_FILTER_TYPE, (JSONValue)new JSONString(VALUE_FILTER_TYPE));
        return filterAsJsonObject;
    }

    public static FilterWithUI<TagDTO> deserialize(JSONObject filterAsJsonObject) {
        JSONString filterNameValue = (JSONString)filterAsJsonObject.get(FIELD_FILTER_NAME);
        JSONString filterOperatorValue = (JSONString)filterAsJsonObject.get(FIELD_FILTER_OPERATOR);
        JSONString filterValueValue = (JSONString)filterAsJsonObject.get(FIELD_FILTER_VALUE);
        String filterName = filterNameValue.stringValue();
        String operator = filterOperatorValue.stringValue();
        String value = filterValueValue.stringValue();
        FilterWithUI filter = TagFilterWithUIFactory.createFilter((String)filterName);
        if (filter != null && operator != null && value != null) {
            if (filter instanceof NumberFilter) {
                NumberFilter numberFilter = (NumberFilter)filter;
                numberFilter.setOperator((FilterOperator)new BinaryOperator(BinaryOperator.Operators.valueOf((String)operator)));
                numberFilter.setValue((Object)Integer.valueOf(value));
            } else if (filter instanceof TextFilter) {
                TextFilter textFilter = (TextFilter)filter;
                textFilter.setOperator((FilterOperator)new TextOperator(TextOperator.Operators.valueOf((String)operator)));
                textFilter.setValue((Object)value);
            }
        }
        return filter;
    }
}

