/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.filter;

import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.filter.CompetitorTotalRankFilterUIFactory;
import com.sap.sailing.gwt.ui.client.shared.filter.FilterUIFactory;
import com.sap.sailing.gwt.ui.client.shared.filter.FilterWithUI;
import com.sap.sailing.gwt.ui.client.shared.filter.LeaderboardFetcher;
import com.sap.sailing.gwt.ui.client.shared.filter.LeaderboardFilterContext;
import com.sap.sse.common.filter.AbstractNumberFilter;

public class CompetitorTotalRankFilter
extends AbstractNumberFilter<CompetitorDTO, Integer>
implements LeaderboardFilterContext,
FilterWithUI<CompetitorDTO> {
    public static final String FILTER_NAME = "CompetitorTotalRankFilter";
    private LeaderboardFetcher leaderboardFetcher;

    private LeaderboardDTO getLeaderboard() {
        return this.leaderboardFetcher != null ? this.leaderboardFetcher.getLeaderboard() : null;
    }

    public boolean matches(CompetitorDTO competitorDTO) {
        boolean result = false;
        if ((Integer)this.value > 0 && this.operator != null && this.getLeaderboard() != null) {
            int totalRank = this.getLeaderboard().getTotalRank(competitorDTO);
            result = this.operator.matchValues((Object)((Integer)this.value), (Object)totalRank);
        }
        return result;
    }

    public String getName() {
        return FILTER_NAME;
    }

    public String getLocalizedName(StringMessages stringMessages) {
        return stringMessages.totalRegattaRank();
    }

    public String getLocalizedDescription(StringMessages stringMessages) {
        return "Top " + this.getValue() + " " + stringMessages.totalRegattaRank();
    }

    public String validate(StringMessages stringMessages) {
        String errorMessage = null;
        if (this.value != null) {
            Integer intfilterValue = (Integer)this.value;
            if (intfilterValue <= 0) {
                errorMessage = stringMessages.numberMustBePositive();
            }
        } else {
            errorMessage = stringMessages.pleaseEnterANumber();
        }
        return errorMessage;
    }

    public CompetitorTotalRankFilter copy() {
        CompetitorTotalRankFilter result = new CompetitorTotalRankFilter();
        result.setValue((Number)((Integer)this.getValue()));
        result.setOperator(this.getOperator());
        return result;
    }

    public LeaderboardFetcher getLeaderboardFetcher() {
        return this.leaderboardFetcher;
    }

    public void setLeaderboardFetcher(LeaderboardFetcher leaderboardFetcher) {
        this.leaderboardFetcher = leaderboardFetcher;
    }

    public FilterUIFactory<CompetitorDTO> createUIFactory() {
        return new CompetitorTotalRankFilterUIFactory(this);
    }
}

