/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.charts;

import com.google.gwt.core.client.Callback;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.LatLngBounds;
import com.google.gwt.maps.client.controls.ControlPosition;
import com.google.gwt.maps.client.events.click.ClickMapHandler;
import com.google.gwt.maps.client.mvc.MVCArray;
import com.google.gwt.maps.client.overlays.Polyline;
import com.google.gwt.maps.client.overlays.PolylineOptions;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.sap.sailing.domain.common.FixType;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.charts.AbstractRaceChart;
import com.sap.sailing.gwt.ui.client.shared.charts.EditMarkPositionPanel;
import com.sap.sailing.gwt.ui.client.shared.charts.FixPositionChooser;
import com.sap.sailing.gwt.ui.client.shared.charts.HasAvailabilityCheck;
import com.sap.sailing.gwt.ui.client.shared.charts.MarkPositionService;
import com.sap.sailing.gwt.ui.client.shared.charts.MarkPositionServiceForSailingService;
import com.sap.sailing.gwt.ui.client.shared.charts.MarksPanel;
import com.sap.sailing.gwt.ui.client.shared.charts.RaceIdentifierToLeaderboardRaceColumnAndFleetMapper;
import com.sap.sailing.gwt.ui.client.shared.racemap.BoundsUtil;
import com.sap.sailing.gwt.ui.client.shared.racemap.CourseMarkOverlay;
import com.sap.sailing.gwt.ui.client.shared.racemap.FixOverlay;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMap;
import com.sap.sailing.gwt.ui.leaderboard.SingleRaceLeaderboardPanel;
import com.sap.sailing.gwt.ui.raceboard.SideBySideComponentViewer;
import com.sap.sailing.gwt.ui.shared.GPSFixDTO;
import com.sap.sailing.gwt.ui.shared.GPSFixDTOWithSpeedWindTackAndLegType;
import com.sap.sailing.gwt.ui.shared.MarkDTO;
import com.sap.sailing.gwt.ui.shared.WindDTO;
import com.sap.sailing.gwt.ui.shared.racemap.CanvasOverlayV3;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.AbstractSettings;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.player.TimeRangeChangeListener;
import com.sap.sse.gwt.client.player.TimeRangeWithZoomProvider;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialog;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Consumer;
import org.moxieapps.gwt.highcharts.client.Axis;
import org.moxieapps.gwt.highcharts.client.BaseChart;
import org.moxieapps.gwt.highcharts.client.Chart;
import org.moxieapps.gwt.highcharts.client.ChartSubtitle;
import org.moxieapps.gwt.highcharts.client.ChartTitle;
import org.moxieapps.gwt.highcharts.client.Color;
import org.moxieapps.gwt.highcharts.client.Credits;
import org.moxieapps.gwt.highcharts.client.PlotLine;
import org.moxieapps.gwt.highcharts.client.Point;
import org.moxieapps.gwt.highcharts.client.Series;
import org.moxieapps.gwt.highcharts.client.ToolTip;
import org.moxieapps.gwt.highcharts.client.ToolTipFormatter;
import org.moxieapps.gwt.highcharts.client.XAxis;
import org.moxieapps.gwt.highcharts.client.YAxis;
import org.moxieapps.gwt.highcharts.client.events.ChartClickEventHandler;
import org.moxieapps.gwt.highcharts.client.events.ChartSelectionEventHandler;
import org.moxieapps.gwt.highcharts.client.labels.AxisLabelsFormatter;
import org.moxieapps.gwt.highcharts.client.labels.XAxisLabels;
import org.moxieapps.gwt.highcharts.client.plotOptions.LinePlotOptions;
import org.moxieapps.gwt.highcharts.client.plotOptions.Marker;
import org.moxieapps.gwt.highcharts.client.plotOptions.PlotOptions;

public class EditMarkPositionPanel
extends AbstractRaceChart<AbstractSettings>
implements RequiresResize,
SelectionChangeEvent.Handler,
HasAvailabilityCheck {
    protected static final int FIX_OVERLAY_Z_ORDER = 230;
    private final RaceMap raceMap;
    private final SingleRaceLeaderboardPanel leaderboardPanel;
    private final MarksPanel marksPanel;
    private Series markSeries;
    private LinePlotOptions markSeriesPlotOptions;
    private final Label noMarkSelectedLabel;
    private MapWidget map;
    private List<HandlerRegistration> courseMarkClickHandlers;
    private Map<MarkDTO, Util.Pair<Date, Date>> marksFromToTimes;
    private Date raceFromTime;
    private Date raceToTime;
    private Map<MarkDTO, SortedMap<GPSFixDTO, FixOverlay>> marks;
    private MarkDTO selectedMark;
    private Map<MarkDTO, Polyline> polylines;
    private SideBySideComponentViewer sideBySideComponentViewer;
    private FixPositionChooser currentFixPositionChooser;
    private List<OverlayClickHandler> overlayClickHandlers;
    private final MarkPositionService markPositionService;
    private final RaceIdentifierToLeaderboardRaceColumnAndFleetMapper raceIdentifierToLeaderboardRaceColumnAndFleetMapper;
    protected boolean nonTrackingWarningWasDisplayed;
    private final Set<MarkDTO> marksCurrentlyRequestedViaRemoteCall = new HashSet();
    private final SailingServiceWriteAsync sailingServiceWrite;
    private Timer notificationTimer;

    public EditMarkPositionPanel(Component<?> parent, ComponentContext<?> context, RaceMap raceMap, SingleRaceLeaderboardPanel leaderboardPanel, RegattaAndRaceIdentifier selectedRaceIdentifier, String leaderboardName, StringMessages stringMessages, SailingServiceAsync sailingService, com.sap.sse.gwt.client.player.Timer timer, TimeRangeWithZoomProvider timeRangeWithZoomProvider, AsyncActionsExecutor asyncActionsExecutor, ErrorReporter errorReporter, SailingServiceWriteAsync sailingServiceWrite) {
        super(parent, context, sailingService, selectedRaceIdentifier, timer, timeRangeWithZoomProvider, stringMessages, asyncActionsExecutor, errorReporter);
        this.markPositionService = new MarkPositionServiceForSailingService(sailingServiceWrite);
        this.raceIdentifierToLeaderboardRaceColumnAndFleetMapper = new RaceIdentifierToLeaderboardRaceColumnAndFleetMapper();
        this.raceMap = raceMap;
        this.leaderboardPanel = leaderboardPanel;
        this.sailingServiceWrite = sailingServiceWrite;
        this.polylines = new HashMap();
        this.marksPanel = new MarksPanel(this, context, stringMessages);
        this.noMarkSelectedLabel = new Label(stringMessages.pleaseSelectAMark());
        this.noMarkSelectedLabel.setStyleName("abstractChartPanel-importantMessageOfChart");
        this.courseMarkClickHandlers = new ArrayList();
        this.marksFromToTimes = new HashMap();
        this.getEntryWidget().setTitle(stringMessages.editMarkPositions());
        this.setVisible(false);
        this.overlayClickHandlers = new ArrayList();
        this.chart = (Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)new Chart().setPersistent(true)).setZoomType(BaseChart.ZoomType.X)).setMarginLeft((Number)65)).setMarginRight((Number)65)).setWidth100()).setHeight100()).setBorderWidth((Number)0)).setBorderRadius((Number)0)).setBackgroundColor(new Color("#FFFFFF"))).setPlotBackgroundColor("#f8f8f8")).setPlotBorderWidth((Number)0)).setCredits(new Credits().setEnabled(false))).setChartTitle(new ChartTitle().setText(stringMessages.markFixes()))).setChartSubtitle(new ChartSubtitle().setText(stringMessages.clickAndDragToZoomIn()))).setPersistent(true);
        this.chart.setClickEventHandler((ChartClickEventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.chart.setSelectionEventHandler((ChartSelectionEventHandler)new /* Unavailable Anonymous Inner Class!! */);
        ((XAxis)((XAxis)this.chart.getXAxis().setType(Axis.Type.DATE_TIME)).setMaxZoom((Number)60000)).setAxisTitleText(stringMessages.time());
        this.chart.getXAxis().setLabels(new XAxisLabels().setFormatter((AxisLabelsFormatter)new /* Unavailable Anonymous Inner Class!! */));
        ((YAxis)this.chart.getYAxis().setAxisTitleText(String.valueOf(stringMessages.distanceFromAveragePosition()) + " (" + stringMessages.metersUnit() + ")")).setOption("labels/enabled", (Object)false);
        this.timePlotLine = this.chart.getXAxis().createPlotLine().setColor("#656565").setWidth((Number)1).setDashStyle(PlotLine.DashStyle.SOLID);
        this.markSeriesPlotOptions = (LinePlotOptions)((LinePlotOptions)((LinePlotOptions)((LinePlotOptions)((LinePlotOptions)((LinePlotOptions)new LinePlotOptions().setSelected(true)).setShowInLegend(false)).setLineWidth((Number)1)).setColor("#000")).setHoverStateLineWidth((Number)1)).setEnableMouseTracking(true);
        this.markSeries = this.chart.createSeries().setType(Series.Type.LINE).setYAxis((Number)0).setPlotOptions((PlotOptions)this.markSeriesPlotOptions).setName(stringMessages.distanceFromAveragePosition());
        this.chart.addSeries(this.markSeries, false, false);
        this.chart.setToolTip(new ToolTip().setEnabled(true).setFormatter((ToolTipFormatter)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void canRemoveMarkFix(MarkDTO mark, GPSFixDTO fix, AsyncCallback<Boolean> callback) {
        this.markPositionService.canRemoveMarkFix(this.raceIdentifierToLeaderboardRaceColumnAndFleetMapper.getLeaderboardNameAndRaceColumnNameAndFleetName(this.selectedRaceIdentifier), mark, fix, callback);
    }

    public void setRedPoint(Point[] points, int index) {
        points[index].setMarker(new Marker().setFillColor("#f00"));
    }

    public void setRedPoint(int index) {
        Point[] points = this.markSeries.getPoints();
        if (points.length > index) {
            this.setRedPoint(points, index);
            this.setSeriesPoints(this.markSeries, points, true);
        }
    }

    public void updateRedPoint(int index) {
        Point[] points;
        if (this.selectedMark != null && this.marks != null && (points = this.getSeriesPoints(((SortedMap)this.marks.get(this.selectedMark)).keySet())).length > index) {
            this.setRedPoint(points, index);
            this.setSeriesPoints(this.markSeries, points, true);
            this.chart.redraw();
        }
    }

    public void resetPointColor(int index) {
        Point[] points = this.markSeries.getPoints();
        if (points.length > index && this.selectedMark != null) {
            points[index].setMarker(new Marker().setFillColor(this.selectedMark.color == null ? null : this.selectedMark.color.getAsHtml()));
            this.setSeriesPoints(this.markSeries, points, true);
        }
    }

    private void createMarkTrackUi(MarkDTO mark, Iterable<GPSFixDTO> track) {
        Date fromTime = this.timeRangeWithZoomProvider.getFromTime();
        Date toTime = this.timeRangeWithZoomProvider.getToTime();
        PolylineOptions options = PolylineOptions.newInstance();
        if (this.map != null) {
            options.setMap(this.map);
        }
        options.setStrokeWeight(1);
        options.setVisible(false);
        Polyline polyline = Polyline.newInstance((PolylineOptions)options);
        this.polylines.put(mark, polyline);
        SortedMap fixOverlayMap = (SortedMap)this.marks.get(mark);
        for (GPSFixDTO fix : track) {
            FixOverlay overlay = new FixOverlay(this.map, 230, fix, FixType.BUOY, mark.color == null ? null : mark.color.getAsHtml(), this.raceMap.getCoordinateSystem(), this.stringMessages.dragToChangePosition());
            fixOverlayMap.put(fix, overlay);
            overlay.setVisible(false);
            this.overlayClickHandlers.add(new OverlayClickHandler(this, mark, fix, overlay).register());
            if (fromTime.after(fix.timepoint)) {
                fromTime = fix.timepoint;
                continue;
            }
            if (!toTime.before(fix.timepoint)) continue;
            toTime = fix.timepoint;
        }
        this.updatePolylinePoints(mark);
        this.marksFromToTimes.put(mark, new Util.Pair((Object)fromTime, (Object)toTime));
        this.onResize();
    }

    private void loadData() {
        if (this.selectedRaceIdentifier != null && this.marks == null) {
            this.setWidget((Widget)this.chart);
            this.showLoading(this.stringMessages.loadingMarkFixes());
            this.markPositionService.getMarksInTrackedRace(this.raceIdentifierToLeaderboardRaceColumnAndFleetMapper.getLeaderboardNameAndRaceColumnNameAndFleetName(this.selectedRaceIdentifier), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void addMarkFix(MarkDTO mark, Date timepoint, Position fixPosition) {
        GPSFixDTOWithSpeedWindTackAndLegType fix = new GPSFixDTOWithSpeedWindTackAndLegType(timepoint, fixPosition, null, null, new WindDTO(), null, null, false);
        this.markPositionService.addMarkFix(this.raceIdentifierToLeaderboardRaceColumnAndFleetMapper.getLeaderboardNameAndRaceColumnNameAndFleetName(this.selectedRaceIdentifier), mark, (GPSFixDTO)fix, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void editMarkFix(MarkDTO mark, GPSFixDTO fix, Position newPosition) {
        this.markPositionService.editMarkFix(this.raceIdentifierToLeaderboardRaceColumnAndFleetMapper.getLeaderboardNameAndRaceColumnNameAndFleetName(this.selectedRaceIdentifier), mark, fix, newPosition, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void removeMarkFix(MarkDTO mark, GPSFixDTO fix) {
        this.markPositionService.removeMarkFix(this.raceIdentifierToLeaderboardRaceColumnAndFleetMapper.getLeaderboardNameAndRaceColumnNameAndFleetName(this.selectedRaceIdentifier), mark, fix, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updatePolylinePoints(MarkDTO mark) {
        MVCArray path = ((Polyline)this.polylines.get(mark)).getPath();
        path.clear();
        for (GPSFixDTO fix : ((SortedMap)this.marks.get(mark)).keySet()) {
            path.push((JavaScriptObject)LatLng.newInstance((double)fix.position.getLatDeg(), (double)fix.position.getLngDeg()));
        }
    }

    public Point[] getSeriesPoints(Collection<GPSFixDTO> fixes) {
        double latAverage = 0.0;
        double lngAverage = 0.0;
        for (GPSFixDTO fix : fixes) {
            latAverage += fix.position.getLatDeg();
            lngAverage += fix.position.getLngDeg();
        }
        DegreePosition averagePosition = new DegreePosition(latAverage /= (double)fixes.size(), lngAverage /= (double)fixes.size());
        Point[] points = new Point[fixes.size()];
        int i = 0;
        for (GPSFixDTO fix : fixes) {
            double metersFromAverage = fix.position.getDistance((Position)averagePosition).getMeters();
            points[i] = new Point((Number)fix.timepoint.getTime(), (Number)metersFromAverage);
            ++i;
        }
        return points;
    }

    private void setSeriesPoints(MarkDTO mark) {
        this.setSeriesPoints(this.markSeries, this.getSeriesPoints(((SortedMap)this.marks.get(mark)).keySet()), true);
    }

    public void setSeriesPoints(Point[] points) {
        this.setSeriesPoints(this.markSeries, points, true);
    }

    public void setVisible(boolean visible) {
        if (visible && !this.isVisible()) {
            this.checkIfTracking(() -> {});
        }
        if (this.map == null) {
            this.map = this.raceMap.getMap();
            if (this.map != null) {
                this.setMap(this.map);
            }
        }
        if (visible) {
            if (this.sideBySideComponentViewer != null) {
                this.sideBySideComponentViewer.setLeftComponent((Component)this.marksPanel);
                this.sideBySideComponentViewer.setLeftComponentToggleButtonVisible(false);
            }
            for (CourseMarkOverlay overlay : this.raceMap.getCourseMarkOverlays().values()) {
                this.courseMarkClickHandlers.add(overlay.addClickHandler((ClickMapHandler)new /* Unavailable Anonymous Inner Class!! */));
            }
            this.raceMap.unregisterAllCourseMarkInfoWindowClickHandlers();
        } else {
            this.cancelFixPositionChooserAndNotification();
            this.marksPanel.deselectMark();
            this.selectedMark = null;
            if (this.sideBySideComponentViewer != null) {
                this.sideBySideComponentViewer.setLeftComponent((Component)this.leaderboardPanel);
                this.sideBySideComponentViewer.setLeftComponentToggleButtonVisible(true);
            }
            for (HandlerRegistration registration : this.courseMarkClickHandlers) {
                registration.removeHandler();
            }
            this.raceMap.unregisterAllCourseMarkInfoWindowClickHandlers();
            this.raceMap.registerAllCourseMarkInfoWindowClickHandlers();
        }
        super.setVisible(visible);
    }

    private void cancelFixPositionChooserAndNotification() {
        if (this.currentFixPositionChooser != null) {
            this.currentFixPositionChooser.cancel();
            this.currentFixPositionChooser = null;
            if (this.notificationTimer.isRunning()) {
                this.notificationTimer.run();
                this.notificationTimer.cancel();
            }
        }
    }

    private void checkIfTracking(Runnable continuation) {
        if (this.nonTrackingWarningWasDisplayed) {
            continuation.run();
        } else {
            this.sailingService.checkIfRaceIsTracking(this.selectedRaceIdentifier, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void onResize() {
        if (this.selectedMark != null) {
            LatLngBounds bounds = null;
            if (this.marks != null) {
                for (GPSFixDTO fix : ((SortedMap)this.marks.get(this.selectedMark)).keySet()) {
                    bounds = bounds == null ? BoundsUtil.getAsBounds((LatLng)this.raceMap.getCoordinateSystem().toLatLng(fix.position)) : bounds.extend(this.raceMap.getCoordinateSystem().toLatLng(fix.position));
                }
            }
        }
        this.chart.setSizeToMatchContainer();
        this.chart.redraw();
    }

    public void redrawChart() {
        this.chart.redraw();
    }

    public String getLocalizedShortName() {
        return this.stringMessages.editMarkPositions();
    }

    public Widget getEntryWidget() {
        return this;
    }

    public boolean hasSettings() {
        return false;
    }

    public SettingsDialogComponent<AbstractSettings> getSettingsDialogComponent(AbstractSettings settings) {
        return null;
    }

    public void updateSettings(AbstractSettings newSettings) {
    }

    public String getDependentCssClassName() {
        return null;
    }

    public void setMap(MapWidget map) {
        this.map = map;
        for (Map.Entry polyline : this.polylines.entrySet()) {
            ((Polyline)polyline.getValue()).setMap(map);
        }
    }

    public Date getTimepoint() {
        return this.timer.getTime();
    }

    protected Button createSettingsButton() {
        Button settingsButton = SettingsDialog.createSettingsButton((Component)this, (com.sap.sse.gwt.client.StringMessages)this.stringMessages);
        settingsButton.setVisible(false);
        return settingsButton;
    }

    public void timeChanged(Date newTime, Date oldTime) {
        if (this.isVisible()) {
            this.loadData();
            this.updateTimePlotLine(newTime);
        }
    }

    public void setComponentViewer(SideBySideComponentViewer sideBySideComponentViewer) {
        this.sideBySideComponentViewer = sideBySideComponentViewer;
    }

    private void selectMark(MarkDTO mark) {
        if (this.selectedMark != mark) {
            this.cancelFixPositionChooserAndNotification();
        }
        this.selectedMark = mark;
        if (this.selectedMark != null) {
            if (this.marksFromToTimes.get(this.selectedMark) != null) {
                this.timeRangeWithZoomProvider.setTimeRange((Date)((Util.Pair)this.marksFromToTimes.get(this.selectedMark)).getA(), (Date)((Util.Pair)this.marksFromToTimes.get(this.selectedMark)).getB(), new TimeRangeChangeListener[0]);
            }
            this.setWidget((Widget)this.chart);
            this.markSeries.remove();
            this.markSeries.setPlotOptions(this.markSeriesPlotOptions.setMarker(new Marker().setFillColor(this.selectedMark.color != null ? this.selectedMark.color.getAsHtml() : "#efab00").setLineColor("#fff").setLineWidth((Number)2)));
            this.chart.addSeries(this.markSeries);
            this.setSeriesPoints(this.selectedMark);
            this.onResize();
            this.hideAllCourseMarkOverlaysExceptSelected();
            this.raceMap.hideAllHelplines();
            if (this.marks != null) {
                for (Map.Entry e : this.marks.entrySet()) {
                    for (CanvasOverlayV3 overlay : ((SortedMap)e.getValue()).values()) {
                        overlay.setVisible(this.selectedMark.equals(e.getKey()));
                    }
                }
            }
            for (Map.Entry e : this.polylines.entrySet()) {
                ((Polyline)e.getValue()).setVisible(this.selectedMark.equals(e.getKey()));
            }
        } else {
            if (this.raceFromTime != null && this.raceToTime != null) {
                this.timeRangeWithZoomProvider.setTimeRange(this.raceFromTime, this.raceToTime, new TimeRangeChangeListener[0]);
            }
            this.setWidget((Widget)this.noMarkSelectedLabel);
            this.showAllCourseMarkOverlays();
            this.raceMap.showAllHelplinesToShow();
            this.hideAllFixOverlays();
            this.hideAllPolylines();
        }
    }

    public void onSelectionChange(SelectionChangeEvent event) {
        MarkDTO mark = this.marksPanel.getSelectedMark();
        this.retrieveAndSelectMarkIfNecessary(mark, null);
    }

    protected void retrieveAndSelectMarkIfNecessary(MarkDTO mark, Runnable callback) {
        if (mark != null && (this.marks.get(mark) == null || ((SortedMap)this.marks.get(mark)).isEmpty())) {
            if (this.marksCurrentlyRequestedViaRemoteCall.add(mark)) {
                this.markPositionService.getMarkTrack(this.raceIdentifierToLeaderboardRaceColumnAndFleetMapper.getLeaderboardNameAndRaceColumnNameAndFleetName(this.selectedRaceIdentifier), mark.getIdAsString(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        } else {
            this.selectMark(mark);
            if (callback != null) {
                callback.run();
            }
        }
    }

    public void showAllCourseMarkOverlays() {
        for (CourseMarkOverlay overlay : this.raceMap.getCourseMarkOverlays().values()) {
            overlay.setVisible(true);
        }
    }

    public void hideAllCourseMarkOverlaysExceptSelected() {
        for (Map.Entry overlay : this.raceMap.getCourseMarkOverlays().entrySet()) {
            ((CourseMarkOverlay)overlay.getValue()).setVisible(((String)overlay.getKey()).equals(this.selectedMark.getIdAsString()));
        }
    }

    public void hideAllFixOverlays() {
        if (this.marks != null) {
            for (Map.Entry mark : this.marks.entrySet()) {
                for (CanvasOverlayV3 overlay : ((SortedMap)mark.getValue()).values()) {
                    overlay.setVisible(false);
                }
            }
        }
    }

    public void hideAllPolylines() {
        for (Map.Entry polyline : this.polylines.entrySet()) {
            ((Polyline)polyline.getValue()).setVisible(false);
        }
    }

    public void createFixPositionChooserToAddFixToMark(MarkDTO mark, Callback<Position, Exception> callback) {
        if (this.currentFixPositionChooser != null) {
            return;
        }
        this.checkIfTracking(() -> {
            int index = 0;
            for (GPSFixDTO fix : ((SortedMap)this.marks.get(mark)).keySet()) {
                if (fix.timepoint.after(this.timer.getTime())) break;
                ++index;
            }
            Polyline polyline = (Polyline)this.polylines.get(mark);
            this.currentFixPositionChooser = new FixPositionChooser(this, this.stringMessages, this.map, index, polyline != null ? polyline.getPath() : null, this.map.getCenter(), this.raceMap.getCoordinateSystem(), callback);
        });
    }

    public void resetCurrentFixPositionChooser() {
        this.currentFixPositionChooser = null;
    }

    public void showNotification(String message) {
        this.showNotification(message, NotificationType.INFO);
    }

    public void showNotification(String message, NotificationType type) {
        if (this.notificationTimer != null && this.notificationTimer.isRunning()) {
            this.notificationTimer.run();
        }
        HTMLPanel text = new HTMLPanel("<div style = \" color: " + (type == NotificationType.ERROR ? "#c00" : (type == NotificationType.SUCCESS ? "#0c0" : "#000")) + "\">" + message + "</div>");
        text.setStyleName("EditMarkPositionNotification");
        this.map.setControls(ControlPosition.TOP_CENTER, (Widget)text);
        this.notificationTimer = new /* Unavailable Anonymous Inner Class!! */;
        this.notificationTimer.schedule(5000);
    }

    public boolean hasFixAtTimePoint(MarkDTO mark, Date timePoint) {
        boolean result = false;
        for (GPSFixDTO fix : ((SortedMap)this.marks.get(mark)).keySet()) {
            if (!fix.timepoint.equals(timePoint)) continue;
            result = true;
            break;
        }
        return result;
    }

    public List<GPSFixDTO> getMarkFixes() {
        if (this.selectedMark != null) {
            ArrayList<GPSFixDTO> set = new ArrayList<GPSFixDTO>();
            set.addAll(((SortedMap)this.marks.get(this.selectedMark)).keySet());
            return set;
        }
        return null;
    }

    public XAxis getXAxis() {
        return this.chart.getXAxis();
    }

    public void setLeaderboard(LeaderboardDTO leaderboard) {
        this.raceIdentifierToLeaderboardRaceColumnAndFleetMapper.setLeaderboard(leaderboard);
    }

    public AbstractSettings getSettings() {
        return null;
    }

    public String getId() {
        return "EditMarkPositionPanel";
    }

    public void checkBackendAvailability(Consumer<Boolean> callback) {
        HasAvailabilityCheck.validateBackendAvailabilityAndExecuteBusinessLogic((SailingServiceWriteAsync)this.sailingServiceWrite, callback, (com.sap.sse.gwt.client.StringMessages)this.stringMessages);
    }

    static /* synthetic */ Map access$3(EditMarkPositionPanel editMarkPositionPanel) {
        return editMarkPositionPanel.polylines;
    }

    static /* synthetic */ MapWidget access$4(EditMarkPositionPanel editMarkPositionPanel) {
        return editMarkPositionPanel.map;
    }

    static /* synthetic */ RaceMap access$5(EditMarkPositionPanel editMarkPositionPanel) {
        return editMarkPositionPanel.raceMap;
    }

    static /* synthetic */ void access$6(EditMarkPositionPanel editMarkPositionPanel, MarkDTO markDTO, GPSFixDTO gPSFixDTO, Position position) {
        editMarkPositionPanel.editMarkFix(markDTO, gPSFixDTO, position);
    }

    static /* synthetic */ FixPositionChooser access$7(EditMarkPositionPanel editMarkPositionPanel) {
        return editMarkPositionPanel.currentFixPositionChooser;
    }

    static /* synthetic */ void access$8(EditMarkPositionPanel editMarkPositionPanel, FixPositionChooser fixPositionChooser) {
        editMarkPositionPanel.currentFixPositionChooser = fixPositionChooser;
    }

    static /* synthetic */ void access$9(EditMarkPositionPanel editMarkPositionPanel, Runnable runnable) {
        editMarkPositionPanel.checkIfTracking(runnable);
    }

    static /* synthetic */ void access$10(EditMarkPositionPanel editMarkPositionPanel, MarkDTO markDTO, GPSFixDTO gPSFixDTO) {
        editMarkPositionPanel.removeMarkFix(markDTO, gPSFixDTO);
    }

    static /* synthetic */ void access$11(EditMarkPositionPanel editMarkPositionPanel, MarkDTO markDTO, GPSFixDTO gPSFixDTO, AsyncCallback asyncCallback) {
        editMarkPositionPanel.canRemoveMarkFix(markDTO, gPSFixDTO, asyncCallback);
    }

    static /* synthetic */ Map access$12(EditMarkPositionPanel editMarkPositionPanel) {
        return editMarkPositionPanel.marks;
    }

    static /* synthetic */ List access$13(EditMarkPositionPanel editMarkPositionPanel) {
        return editMarkPositionPanel.overlayClickHandlers;
    }

    static /* synthetic */ void access$14(EditMarkPositionPanel editMarkPositionPanel, Map map) {
        editMarkPositionPanel.marks = map;
    }

    static /* synthetic */ MarksPanel access$15(EditMarkPositionPanel editMarkPositionPanel) {
        return editMarkPositionPanel.marksPanel;
    }

    static /* synthetic */ void access$16(EditMarkPositionPanel editMarkPositionPanel, MarkDTO markDTO) {
        editMarkPositionPanel.updatePolylinePoints(markDTO);
    }

    static /* synthetic */ void access$17(EditMarkPositionPanel editMarkPositionPanel, MarkDTO markDTO) {
        editMarkPositionPanel.setSeriesPoints(markDTO);
    }

    static /* synthetic */ Set access$18(EditMarkPositionPanel editMarkPositionPanel) {
        return editMarkPositionPanel.marksCurrentlyRequestedViaRemoteCall;
    }

    static /* synthetic */ void access$19(EditMarkPositionPanel editMarkPositionPanel, MarkDTO markDTO, Iterable iterable) {
        editMarkPositionPanel.createMarkTrackUi(markDTO, iterable);
    }

    static /* synthetic */ void access$20(EditMarkPositionPanel editMarkPositionPanel, MarkDTO markDTO) {
        editMarkPositionPanel.selectMark(markDTO);
    }
}

