/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.charts;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.WidgetCollection;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.charts.AbstractRaceChart;
import com.sap.sailing.gwt.ui.client.shared.charts.ChartCssResources;
import com.sap.sailing.gwt.ui.client.shared.charts.ChartZoomChangedEvent;
import com.sap.sailing.gwt.ui.client.shared.charts.ChartZoomResetEvent;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.controls.busyindicator.SimpleBusyIndicator;
import com.sap.sse.gwt.client.controls.slider.TimeTicksCalculator;
import com.sap.sse.gwt.client.player.TimeListener;
import com.sap.sse.gwt.client.player.TimeRangeChangeListener;
import com.sap.sse.gwt.client.player.TimeRangeWithZoomProvider;
import com.sap.sse.gwt.client.player.TimeZoomChangeListener;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.AbstractCompositeComponent;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.util.Date;
import java.util.Iterator;
import org.moxieapps.gwt.highcharts.client.Chart;
import org.moxieapps.gwt.highcharts.client.PlotLine;
import org.moxieapps.gwt.highcharts.client.Point;
import org.moxieapps.gwt.highcharts.client.Series;
import org.moxieapps.gwt.highcharts.client.XAxis;
import org.moxieapps.gwt.highcharts.client.events.ChartClickEvent;
import org.moxieapps.gwt.highcharts.client.events.ChartSelectionEvent;

public abstract class AbstractRaceChart<SettingsType extends Settings>
extends AbstractCompositeComponent<SettingsType>
implements TimeListener,
TimeZoomChangeListener,
TimeRangeChangeListener {
    protected static final int MAX_SERIES_POINTS = 1000000;
    private ExposedAbsolutePanel rootPanel = new ExposedAbsolutePanel();
    protected Chart chart;
    protected PlotLine timePlotLine;
    protected final Timer timer;
    protected final TimeRangeWithZoomProvider timeRangeWithZoomProvider;
    protected final RegattaAndRaceIdentifier selectedRaceIdentifier;
    protected final DateTimeFormat dateFormat = DateTimeFormat.getFormat((String)"HH:mm:ss");
    protected final DateTimeFormat dateFormatHoursMinutes = DateTimeFormat.getFormat((String)"HH:mm");
    protected final StringMessages stringMessages;
    protected final ErrorReporter errorReporter;
    protected final AsyncActionsExecutor asyncActionsExecutor;
    protected final SailingServiceAsync sailingService;
    protected boolean isLoading = false;
    protected static ChartCssResources.ChartsCss chartsCss = ChartCssResources.INSTANCE.css();
    private final int TICKCOUNT = 10;
    public static final long MINUTE_IN_MILLIS = 60000L;
    private boolean ignoreNextClickEvent;
    private final SimpleBusyIndicator busyIndicator;
    private final Button settingsButton;
    private final FlowPanel toolbar = new FlowPanel();

    protected AbstractRaceChart(Component<?> parent, ComponentContext<?> context, SailingServiceAsync sailingService, RegattaAndRaceIdentifier selectedRaceIdentifier, Timer timer, TimeRangeWithZoomProvider timeRangeWithZoomProvider, StringMessages stringMessages, AsyncActionsExecutor asyncActionsExecutor, ErrorReporter errorReporter) {
        super(parent, context);
        this.sailingService = sailingService;
        this.selectedRaceIdentifier = selectedRaceIdentifier;
        this.timer = timer;
        this.timeRangeWithZoomProvider = timeRangeWithZoomProvider;
        this.stringMessages = stringMessages;
        this.asyncActionsExecutor = asyncActionsExecutor;
        this.errorReporter = errorReporter;
        timer.addTimeListener((TimeListener)this);
        timeRangeWithZoomProvider.addTimeZoomChangeListener((TimeZoomChangeListener)this);
        timeRangeWithZoomProvider.addTimeRangeChangeListener((TimeRangeChangeListener)this);
        chartsCss.ensureInjected();
        this.busyIndicator = new SimpleBusyIndicator(true, 2.0f);
        this.busyIndicator.setPanelStyleClass(chartsCss.busyIndicatorStyle());
        this.busyIndicator.setImageStyleClass(chartsCss.busyIndicatorImageStyle());
        this.toolbar.addStyleName(chartsCss.toolbar());
        this.add((Widget)this.toolbar);
        this.settingsButton = this.createSettingsButton();
        this.settingsButton.setStyleName(chartsCss.settingsButtonBackgroundImage());
        this.addToolbarButton(this.settingsButton);
        this.initWidget((Widget)this.rootPanel);
        this.getElement().getStyle().setMarginRight(12.0, Style.Unit.PX);
        this.getElement().getStyle().setMarginLeft(12.0, Style.Unit.PX);
    }

    protected abstract Button createSettingsButton();

    public void addToolbarButton(Button button) {
        this.toolbar.insert((Widget)button, 0);
    }

    private Button getSettingsButton() {
        return this.settingsButton;
    }

    protected void setWidget(Widget widget) {
        Button settingsButton = this.getSettingsButton();
        boolean foundWidget = false;
        Iterator i = this.rootPanel.getChildren().iterator();
        while (i.hasNext()) {
            Widget child = (Widget)i.next();
            if (child == widget) {
                foundWidget = true;
                continue;
            }
            if (child == settingsButton || child == this.toolbar) continue;
            i.remove();
        }
        if (!foundWidget) {
            this.add(widget);
        }
    }

    protected void showLoading(String message) {
        if (this.chart.isRendered()) {
            this.chart.showLoading(message);
        } else {
            this.add((Widget)this.busyIndicator);
        }
        this.isLoading = true;
    }

    protected void hideLoading() {
        this.chart.hideLoading();
        this.isLoading = false;
        this.remove((Widget)this.busyIndicator);
    }

    protected boolean onXAxisSelectionChange(ChartSelectionEvent chartSelectionEvent) {
        Long xAxisMin = chartSelectionEvent.getXAxisMinAsLongOrNull();
        Long xAxisMax = chartSelectionEvent.getXAxisMaxAsLongOrNull();
        if (xAxisMax != null && xAxisMin != null) {
            if (xAxisMax - xAxisMin > 60000L) {
                Date rangeStart = new Date(xAxisMin);
                Date rangeEnd = new Date(xAxisMax);
                if (this.timer.getPlayMode() == Timer.PlayModes.Live) {
                    this.timer.pause();
                }
                Scheduler.get().scheduleDeferred(() -> this.timeRangeWithZoomProvider.setTimeZoom(rangeStart, rangeEnd, new TimeZoomChangeListener[0]));
                return true;
            }
            return false;
        }
        this.ignoreNextClickEvent = true;
        this.timeRangeWithZoomProvider.resetTimeZoom(new TimeZoomChangeListener[0]);
        return false;
    }

    protected boolean onClick(ChartClickEvent chartClickEvent) {
        if (this.ignoreNextClickEvent) {
            this.ignoreNextClickEvent = false;
        } else if (!this.isLoading) {
            this.timer.setPlayMode(Timer.PlayModes.Replay);
            this.timer.setTime(chartClickEvent.getXAxisValueAsLong());
        }
        return true;
    }

    protected void updateChartIfEffectiveStepSizeChanged(Date minTimepoint, Date maxTimepoint) {
    }

    protected void changeMinMaxAndExtremesInterval(Date minTimepoint, Date maxTimepoint, boolean redraw) {
        if (this.chart != null) {
            XAxis xAxis = this.chart.getXAxis();
            if (this.timeRangeWithZoomProvider.isZoomed() && this.timer.getPlayMode() == Timer.PlayModes.Live) {
                Scheduler.get().scheduleDeferred(() -> this.timeRangeWithZoomProvider.resetTimeZoom(new TimeZoomChangeListener[0]));
                return;
            }
            if (minTimepoint != null && maxTimepoint != null) {
                xAxis.setExtremes((Number)minTimepoint.getTime(), (Number)maxTimepoint.getTime(), false, false);
                long tickInterval = (maxTimepoint.getTime() - minTimepoint.getTime()) / 10L;
                TimeTicksCalculator calculator = new TimeTicksCalculator();
                TimeTicksCalculator.NormalizedInterval normalizedInterval = calculator.normalizeTimeTickInterval(tickInterval);
                xAxis.setTickInterval((Number)((long)normalizedInterval.count * normalizedInterval.unitRange));
            }
            if (minTimepoint != null) {
                xAxis.setMin((Number)minTimepoint.getTime());
            }
            if (maxTimepoint != null) {
                xAxis.setMax((Number)maxTimepoint.getTime());
            }
            if (redraw) {
                this.chart.redraw();
            }
        }
    }

    protected void setSeriesPoints(Series series, Point[] points, boolean manageZoom) {
        if (manageZoom && this.timeRangeWithZoomProvider.isZoomed()) {
            Util.Pair timeZoom = this.timeRangeWithZoomProvider.getTimeZoom();
            this.resetMinMaxAndExtremesInterval(false);
            series.setPoints(points, false);
            this.changeMinMaxAndExtremesInterval((Date)timeZoom.getA(), (Date)timeZoom.getB(), false);
        } else {
            series.setPoints(points, false);
        }
    }

    protected void resetMinMaxAndExtremesInterval(boolean redraw) {
        this.changeMinMaxAndExtremesInterval(this.timeRangeWithZoomProvider.getFromTime(), this.timeRangeWithZoomProvider.getToTime(), redraw);
    }

    public void onTimeZoomChanged(Date zoomStartTimepoint, Date zoomEndTimepoint) {
        this.changeMinMaxAndExtremesInterval(zoomStartTimepoint, zoomEndTimepoint, true);
        this.chart.showResetZoom();
        this.fireEvent((GwtEvent)new ChartZoomChangedEvent(zoomStartTimepoint, zoomEndTimepoint));
    }

    public void onTimeRangeChanged(Date fromTime, Date toTime) {
        this.resetMinMaxAndExtremesInterval(true);
    }

    public void onTimeZoomReset() {
        this.fireEvent((GwtEvent)new ChartZoomResetEvent());
        this.chart.hideResetZoom();
        this.resetMinMaxAndExtremesInterval(true);
    }

    protected void updateTimePlotLine(Date date) {
        this.chart.getXAxis().removePlotLine(this.timePlotLine);
        this.timePlotLine.setValue((Number)date.getTime());
        this.chart.getXAxis().addPlotLines(new PlotLine[]{this.timePlotLine});
    }

    public void add(Widget widget) {
        this.rootPanel.add(widget);
    }

    public boolean remove(Widget widget) {
        return this.rootPanel.remove(widget);
    }

    public WidgetCollection getChildren() {
        return this.rootPanel.getChildren();
    }

    protected boolean shouldShowLoading(Long timestamp) {
        return timestamp == null || this.timer.getPlayState() != Timer.PlayStates.Playing && this.timer.getPlayMode() != Timer.PlayModes.Live;
    }

    public HandlerRegistration addChartZoomChangedHandler(ChartZoomChangedEvent.Handler handler) {
        return this.addHandler((EventHandler)handler, ChartZoomChangedEvent.TYPE);
    }

    public HandlerRegistration addChartZoomResetHandler(ChartZoomResetEvent.Handler handler) {
        return this.addHandler((EventHandler)handler, ChartZoomResetEvent.TYPE);
    }
}

