/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client;

import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RaceTimesCalculationUtil;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.gwt.ui.client.RaceTimePanelLifecycle;
import com.sap.sailing.gwt.ui.client.RaceTimePanelSettings;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProvider;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProviderListener;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.TimePanel;
import com.sap.sailing.gwt.ui.client.TimePanelSettings;
import com.sap.sailing.gwt.ui.shared.MarkPassingTimesDTO;
import com.sap.sailing.gwt.ui.shared.RaceTimesInfoDTO;
import com.sap.sailing.gwt.ui.shared.RaceWithCompetitorsAndBoatsDTO;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.DateAndTimeFormatterUtil;
import com.sap.sse.gwt.client.player.TimeRangeWithZoomProvider;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.UserStatusEventHandler;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RaceTimePanel
extends TimePanel<RaceTimePanelSettings>
implements RaceTimesInfoProviderListener {
    private final RaceTimesInfoProvider raceTimesInfoProvider;
    private final RegattaAndRaceIdentifier selectedRace;
    private boolean autoAdjustPlayMode;
    private RaceTimesInfoDTO lastRaceTimesInfo;
    private boolean hasCanReplayDuringLiveRacesPermission = false;
    private final UserService userService;
    private final RaceTimePanelLifecycle componentLifecycle;
    private final Set<RaceTimesInfoProviderListener> listeners;
    private final RaceWithCompetitorsAndBoatsDTO raceDTO;
    private final UserStatusEventHandler userStatusEventHandler = new /* Unavailable Anonymous Inner Class!! */;
    private boolean redrawAllMarkersPendingForMinMaxBeingInitialized;
    private final Duration initialTimeAfterRaceStartInReplayMode;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayModes;

    public RaceTimePanel(Component<?> parent, ComponentContext<?> context, RaceTimePanelLifecycle componentLifecycle, UserService userService, Timer timer, TimeRangeWithZoomProvider timeRangeProvider, StringMessages stringMessages, RaceTimesInfoProvider raceTimesInfoProvider, boolean canReplayWhileLiveIsPossible, boolean forcePaddingRightToAlignToCharts, RegattaAndRaceIdentifier selectedRaceIdentifier, Duration initialTimeAfterRaceStartInReplayMode, RaceWithCompetitorsAndBoatsDTO raceDTO) {
        super(parent, context, timer, timeRangeProvider, stringMessages, canReplayWhileLiveIsPossible, forcePaddingRightToAlignToCharts, userService, (SecuredDTO)raceDTO);
        this.raceDTO = raceDTO;
        this.componentLifecycle = componentLifecycle;
        this.userService = userService;
        this.raceTimesInfoProvider = raceTimesInfoProvider;
        this.listeners = new HashSet();
        this.autoAdjustPlayMode = true;
        this.selectedRace = selectedRaceIdentifier;
        this.initialTimeAfterRaceStartInReplayMode = initialTimeAfterRaceStartInReplayMode;
        if (!raceTimesInfoProvider.containsRaceIdentifier((RaceIdentifier)this.selectedRace)) {
            raceTimesInfoProvider.addRaceIdentifier(this.selectedRace, true);
        }
    }

    protected void onLoad() {
        super.onLoad();
        this.userService.addUserStatusEventHandler(this.userStatusEventHandler, true);
    }

    protected void onUnload() {
        super.onUnload();
        this.userService.removeUserStatusEventHandler(this.userStatusEventHandler);
    }

    public void addRaceTimesInfoProviderListener(RaceTimesInfoProviderListener listener) {
        this.listeners.add(listener);
    }

    public void removeRaceTimesInfoProviderListener(RaceTimesInfoProviderListener listener) {
        this.listeners.remove(listener);
    }

    protected boolean canReplayWhileLiveIsPossible() {
        return this.hasCanReplayDuringLiveRacesPermission;
    }

    protected String getTimeToStartLabelText(Date time) {
        String result = null;
        RaceTimesInfoDTO selectedRaceTimes = this.raceTimesInfoProvider.getRaceTimesInfo(this.selectedRace);
        if (selectedRaceTimes != null && selectedRaceTimes.startOfRace != null) {
            if (time.before(selectedRaceTimes.startOfRace) || time.equals(selectedRaceTimes.startOfRace)) {
                long timeToStartInMs = selectedRaceTimes.startOfRace.getTime() - time.getTime();
                result = timeToStartInMs < 1000L ? this.stringMessages.start() : this.stringMessages.timeToStart(DateAndTimeFormatterUtil.formatElapsedTime((long)timeToStartInMs));
            } else {
                long timeSinceStartInMs = time.getTime() - selectedRaceTimes.startOfRace.getTime();
                result = this.stringMessages.timeSinceStart(DateAndTimeFormatterUtil.formatElapsedTime((long)timeSinceStartInMs));
            }
        }
        return result;
    }

    public void updateSettings(RaceTimePanelSettings newSettings) {
        super.updateSettings((TimePanelSettings)newSettings);
        this.raceTimesInfoProvider.setRequestInterval(newSettings.getRefreshInterval());
    }

    public RaceTimePanelSettings getSettings() {
        return new RaceTimePanelSettings(this.timer.getRefreshInterval());
    }

    public SettingsDialogComponent<RaceTimePanelSettings> getSettingsDialogComponent(RaceTimePanelSettings settings) {
        return this.componentLifecycle.getSettingsDialogComponent(settings);
    }

    public RaceTimesInfoDTO getLastRaceTimesInfo() {
        return this.lastRaceTimesInfo;
    }

    private void updateTimeInfo(RaceTimesInfoDTO raceTimesInfo) {
        if (raceTimesInfo == null) {
            this.resetTimeSlider();
        } else {
            this.timer.setLivePlayDelayInMillis(raceTimesInfo.delayToLiveInMs);
            if (!(raceTimesInfo.startOfTracking == null && raceTimesInfo.startOfRace == null || raceTimesInfo.newestTrackingEvent == null && raceTimesInfo.endOfRace == null && raceTimesInfo.endOfTracking == null)) {
                boolean timerAlreadyInitialized;
                boolean liveModeToBeMadePossible = this.isLiveModeToBeMadePossible();
                this.setLiveGenerallyPossible(liveModeToBeMadePossible);
                this.setJumpToLiveEnablement(liveModeToBeMadePossible && this.timer.getPlayMode() != Timer.PlayModes.Live);
                if (this.autoAdjustPlayMode && liveModeToBeMadePossible) {
                    this.timer.setPlayMode(Timer.PlayModes.Live);
                }
                this.updatePlayPauseButtonsVisibility(this.timer.getPlayMode());
                if (liveModeToBeMadePossible && !this.canReplayWhileLiveIsPossible() && this.timer.getPlayMode() == Timer.PlayModes.Replay && this.timer.getPlayState() == Timer.PlayStates.Playing) {
                    this.timer.pause();
                }
                boolean bl = timerAlreadyInitialized = this.getFromTime() != null && this.getToTime() != null && this.timeSlider.getCurrentValue() != null;
                if (!this.timeRangeProvider.isZoomed()) {
                    this.updateMinMax(raceTimesInfo);
                    if (!timerAlreadyInitialized) {
                        this.initTimerPosition(raceTimesInfo);
                    }
                    this.updateLegMarkers(raceTimesInfo);
                }
            }
        }
        this.lastRaceTimesInfo = raceTimesInfo;
    }

    public void onTimeZoomChanged(Date zoomStartTimepoint, Date zoomEndTimepoint) {
        super.onTimeZoomChanged(zoomStartTimepoint, zoomEndTimepoint);
        this.timeSlider.setZoomed(true);
        this.setMinMax(zoomStartTimepoint, zoomEndTimepoint, false);
        this.timeSlider.clearMarkersAndLabelsAndTicks();
        if (this.lastRaceTimesInfo != null) {
            this.redrawAllMarkers(this.lastRaceTimesInfo);
        }
    }

    public void onTimeZoomReset() {
        super.onTimeZoomReset();
        this.timeSlider.setZoomed(false);
        this.timeSlider.setMinValue(Double.valueOf(this.timeRangeProvider.getFromTime().getTime()), false);
        this.timeSlider.setMaxValue(Double.valueOf(this.timeRangeProvider.getToTime().getTime()), false);
        this.timeSlider.setCurrentValue(Double.valueOf(this.timer.getTime().getTime()), true);
        this.timeSlider.clearMarkersAndLabelsAndTicks();
        if (this.lastRaceTimesInfo != null) {
            this.redrawAllMarkers(this.lastRaceTimesInfo);
        }
    }

    protected boolean isLiveModeToBeMadePossible() {
        RaceTimesInfoDTO lastRaceTimesInfo;
        RaceTimesInfoDTO raceTimesInfoDTO = lastRaceTimesInfo = this.raceTimesInfoProvider != null ? this.raceTimesInfoProvider.getRaceTimesInfo(this.selectedRace) : null;
        if (lastRaceTimesInfo == null) {
            return false;
        }
        Date timePoint = this.timer.getLiveTimePointAsDate();
        Util.Pair minMax = RaceTimesCalculationUtil.calculateRaceMinMax((Date)this.timer.getLiveTimePointAsDate(), (Date)lastRaceTimesInfo.startOfTracking, (Date)lastRaceTimesInfo.startOfRace, (Date)lastRaceTimesInfo.raceFinishingTime, (Date)lastRaceTimesInfo.raceFinishedTime, (Date)lastRaceTimesInfo.endOfRace, (Date)lastRaceTimesInfo.endOfTracking);
        Date min = (Date)minMax.getA();
        Date max = (Date)minMax.getB();
        if (max == null && lastRaceTimesInfo.newestTrackingEvent != null) {
            max = new Date(lastRaceTimesInfo.newestTrackingEvent.getTime() + 300000L);
        }
        boolean beforeEnd = true;
        if (max != null) {
            boolean bl = beforeEnd = !timePoint.after(max);
        }
        if (min != null) {
            return !timePoint.before(min) && beforeEnd;
        }
        return beforeEnd;
    }

    /*
     * Exception decompiling
     */
    public void playStateChanged(Timer.PlayStates playState, Timer.PlayModes playMode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateMinMax(RaceTimesInfoDTO newRaceTimesInfo) {
        Util.Pair raceMinMax = RaceTimesCalculationUtil.calculateRaceMinMax((Date)this.timer.getLiveTimePointAsDate(), (Date)newRaceTimesInfo.startOfTracking, (Date)newRaceTimesInfo.startOfRace, (Date)newRaceTimesInfo.raceFinishingTime, (Date)newRaceTimesInfo.raceFinishedTime, (Date)newRaceTimesInfo.endOfRace, (Date)newRaceTimesInfo.endOfTracking);
        Date min = (Date)raceMinMax.getA();
        Date max = (Date)raceMinMax.getB();
        if (min != null && max != null && (this.getToTime() == null || this.getToTime().before(max) || this.getFromTime() == null || this.getFromTime().after(min))) {
            this.setMinMax(min, max, false);
        }
    }

    public void setMinMax(Date min, Date max, boolean fireEvent) {
        super.setMinMax(min, max, fireEvent);
        if (this.redrawAllMarkersPendingForMinMaxBeingInitialized && this.timeSlider.isMinMaxInitialized()) {
            this.redrawAllMarkers(this.lastRaceTimesInfo);
            this.redrawAllMarkersPendingForMinMaxBeingInitialized = false;
        }
    }

    /*
     * Exception decompiling
     */
    private void initTimerPosition(RaceTimesInfoDTO newRaceTimesInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateLegMarkers(RaceTimesInfoDTO newRaceTimesInfo) {
        boolean requiresMarkerUpdate = true;
        if (this.lastRaceTimesInfo != null && this.lastRaceTimesInfo.markPassingTimes.size() == newRaceTimesInfo.markPassingTimes.size()) {
            requiresMarkerUpdate = false;
            int numberOfLegs = newRaceTimesInfo.markPassingTimes.size();
            int i = 0;
            while (i < numberOfLegs) {
                if (!Util.equalsWithNull((Object)((MarkPassingTimesDTO)newRaceTimesInfo.markPassingTimes.get((int)i)).firstPassingDate, (Object)((MarkPassingTimesDTO)this.lastRaceTimesInfo.markPassingTimes.get((int)i)).firstPassingDate)) {
                    requiresMarkerUpdate = true;
                    break;
                }
                ++i;
            }
            if (!(requiresMarkerUpdate || Util.equalsWithNull((Object)this.lastRaceTimesInfo.startOfRace, (Object)newRaceTimesInfo.startOfRace) && Util.equalsWithNull((Object)this.lastRaceTimesInfo.endOfRace, (Object)newRaceTimesInfo.endOfRace))) {
                requiresMarkerUpdate = true;
            }
        }
        if (requiresMarkerUpdate) {
            if (this.timeSlider.isMinMaxInitialized()) {
                this.redrawAllMarkers(newRaceTimesInfo);
            } else {
                this.redrawAllMarkersPendingForMinMaxBeingInitialized = true;
            }
        }
    }

    private void redrawAllMarkers(RaceTimesInfoDTO newRaceTimesInfo) {
        List markPassingTimes = newRaceTimesInfo.getMarkPassingTimes();
        this.timeSlider.clearMarkers();
        if (newRaceTimesInfo.startOfRace != null) {
            long markerTime = newRaceTimesInfo.startOfRace.getTime();
            if (!this.timeSlider.isZoomed() || this.timeSlider.isZoomed() && (double)markerTime > this.timeSlider.getMinValue() && (double)markerTime < this.timeSlider.getMaxValue()) {
                this.timeSlider.addMarker("S", Double.valueOf(markerTime));
            }
        }
        int markPassingCounter = 1;
        for (MarkPassingTimesDTO markPassingTimesDTO : markPassingTimes) {
            if (markPassingCounter > 1 && markPassingTimesDTO.firstPassingDate != null) {
                long markerTime = markPassingTimesDTO.firstPassingDate.getTime();
                if (!this.timeSlider.isZoomed() || this.timeSlider.isZoomed() && (double)markerTime > this.timeSlider.getMinValue() && (double)markerTime < this.timeSlider.getMaxValue()) {
                    this.timeSlider.addMarker(markPassingTimesDTO.getName(), Double.valueOf(markerTime));
                }
            }
            ++markPassingCounter;
        }
        if (newRaceTimesInfo.endOfRace != null) {
            long markerTime = newRaceTimesInfo.endOfRace.getTime();
            if (newRaceTimesInfo.getFinishedTime() != null) {
                markerTime = newRaceTimesInfo.getFinishedTime().getTime();
            }
            if (!this.timeSlider.isZoomed() || this.timeSlider.isZoomed() && (double)markerTime > this.timeSlider.getMinValue() && (double)markerTime < this.timeSlider.getMaxValue()) {
                this.timeSlider.addMarker("E", Double.valueOf(markerTime));
            }
        }
        this.timeSlider.redraw();
    }

    public void raceTimesInfosReceived(Map<RegattaAndRaceIdentifier, RaceTimesInfoDTO> raceTimesInfos, long clientTimeWhenRequestWasSent, Date serverTimeDuringRequest, long clientTimeWhenResponseWasReceived) {
        this.timer.adjustClientServerOffset(clientTimeWhenRequestWasSent, serverTimeDuringRequest, clientTimeWhenResponseWasReceived);
        this.updateTimeInfo(raceTimesInfos.get(this.selectedRace));
        for (RaceTimesInfoProviderListener listener : this.listeners) {
            listener.raceTimesInfosReceived(raceTimesInfos, clientTimeWhenRequestWasSent, serverTimeDuringRequest, clientTimeWhenResponseWasReceived);
        }
    }

    public String getId() {
        return this.componentLifecycle.getComponentId();
    }

    static /* synthetic */ UserService access$3(RaceTimePanel raceTimePanel) {
        return raceTimePanel.userService;
    }

    static /* synthetic */ RaceWithCompetitorsAndBoatsDTO access$4(RaceTimePanel raceTimePanel) {
        return raceTimePanel.raceDTO;
    }

    static /* synthetic */ void access$5(RaceTimePanel raceTimePanel, boolean bl) {
        raceTimePanel.hasCanReplayDuringLiveRacesPermission = bl;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayModes() {
        if ($SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayModes != null) {
            return $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayModes;
        }
        int[] nArray = new int[Timer.PlayModes.values().length];
        try {
            nArray[Timer.PlayModes.Live.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Timer.PlayModes.Replay.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sap$sse$gwt$client$player$Timer$PlayModes = nArray;
        return nArray;
    }
}

