/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole.coursecreation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionModel;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.coursecreation.MarkTemplateEditDialog;
import com.sap.sailing.gwt.ui.adminconsole.coursecreation.MarkTemplatePanel;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.courseCreation.MarkTemplateDTO;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.adminconsole.FilterablePanelProvider;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.Flushable;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.SelectionCheckboxColumn;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.AbstractFilterablePanel;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import com.sap.sse.security.ui.client.component.DefaultActionsImagesBarCell;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.SecuredDTOOwnerColumn;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class MarkTemplatePanel
extends FlowPanel
implements FilterablePanelProvider<MarkTemplateDTO> {
    private static AdminConsoleTableResources tableResources = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final LabeledAbstractFilterablePanel<MarkTemplateDTO> filterableMarkTemplates;
    private List<MarkTemplateDTO> allMarkTemplates;
    private final ErrorReporter errorReporter;
    private final StringMessages stringMessages;
    private FlushableCellTable<MarkTemplateDTO> markTemplateTable;
    private ListDataProvider<MarkTemplateDTO> markTemplateListDataProvider = new ListDataProvider();
    private RefreshableMultiSelectionModel<MarkTemplateDTO> refreshableSelectionModel;

    public MarkTemplatePanel(SailingServiceWriteAsync sailingServiceWrite, ErrorReporter errorReporter, StringMessages stringMessages, UserService userService) {
        this.sailingServiceWrite = sailingServiceWrite;
        this.stringMessages = stringMessages;
        this.errorReporter = errorReporter;
        AccessControlledButtonPanel buttonAndFilterPanel = new AccessControlledButtonPanel(userService, SecuredDomainType.MARK_TEMPLATE);
        this.add((Widget)buttonAndFilterPanel);
        this.allMarkTemplates = new ArrayList();
        buttonAndFilterPanel.addUnsecuredAction(stringMessages.refresh(), (Command)new /* Unavailable Anonymous Inner Class!! */);
        buttonAndFilterPanel.addCreateAction(stringMessages.add(), (Command)new /* Unavailable Anonymous Inner Class!! */);
        Label lblFilterRaces = new Label(String.valueOf(stringMessages.filterMarkTemplateByName()) + ":");
        lblFilterRaces.setWordWrap(false);
        buttonAndFilterPanel.addUnsecuredWidget((Widget)lblFilterRaces);
        this.filterableMarkTemplates = new /* Unavailable Anonymous Inner Class!! */;
        this.createMarkTemplatesTable(userService);
        this.filterableMarkTemplates.getTextBox().ensureDebugId("MarkTemplatesFilterTextBox");
        buttonAndFilterPanel.addUnsecuredWidget((Widget)this.filterableMarkTemplates);
        this.filterableMarkTemplates.setUpdatePermissionFilterForCheckbox(event -> userService.hasPermission((SecuredDTO)event, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
    }

    public void loadMarkTemplates() {
        this.markTemplateListDataProvider.getList().clear();
        this.sailingServiceWrite.getMarkTemplates((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createMarkTemplatesTable(UserService userService) {
        this.markTemplateTable = new FlushableCellTable(1000, (CellTable.Resources)tableResources);
        this.markTemplateTable.setWidth("100%");
        ColumnSortEvent.ListHandler sortHandler = new ColumnSortEvent.ListHandler(this.markTemplateListDataProvider.getList());
        this.markTemplateTable.addColumnSortHandler((ColumnSortEvent.Handler)sortHandler);
        this.initTableColumns(sortHandler, userService);
        this.markTemplateListDataProvider.addDataDisplay((HasData)this.markTemplateTable);
        this.add((Widget)this.markTemplateTable);
        this.allMarkTemplates.clear();
        this.allMarkTemplates.addAll(this.markTemplateListDataProvider.getList());
    }

    private void initTableColumns(ColumnSortEvent.ListHandler<MarkTemplateDTO> sortHandler, UserService userService) {
        SelectionCheckboxColumn checkColumn = new SelectionCheckboxColumn(tableResources.cellTableStyle().cellTableCheckboxSelected(), tableResources.cellTableStyle().cellTableCheckboxDeselected(), tableResources.cellTableStyle().cellTableCheckboxColumnCell(), (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */, this.filterableMarkTemplates.getAllListDataProvider(), (Flushable)this.markTemplateTable);
        this.markTemplateTable.addColumn((Column)checkColumn, SafeHtmlUtils.fromSafeConstant((String)"<br/>"));
        this.markTemplateTable.setColumnWidth((Column)checkColumn, 40.0, Style.Unit.PX);
        6 idColumn = new /* Unavailable Anonymous Inner Class!! */;
        7 nameColumn = new /* Unavailable Anonymous Inner Class!! */;
        8 shortNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        9 colorColumn = new /* Unavailable Anonymous Inner Class!! */;
        10 shapeColumn = new /* Unavailable Anonymous Inner Class!! */;
        11 patternColumn = new /* Unavailable Anonymous Inner Class!! */;
        12 typeColumn = new /* Unavailable Anonymous Inner Class!! */;
        nameColumn.setSortable(true);
        sortHandler.setComparator((Column)nameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.markTemplateTable.addColumn((Column)nameColumn, this.stringMessages.name());
        this.markTemplateTable.addColumn((Column)shortNameColumn, this.stringMessages.shortName());
        this.markTemplateTable.addColumn((Column)colorColumn, this.stringMessages.color());
        this.markTemplateTable.addColumn((Column)shapeColumn, this.stringMessages.shape());
        this.markTemplateTable.addColumn((Column)patternColumn, this.stringMessages.pattern());
        this.markTemplateTable.addColumn((Column)typeColumn, this.stringMessages.type());
        SecuredDTOOwnerColumn.configureOwnerColumns((AbstractCellTable)this.markTemplateTable, sortHandler, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        HasPermissions type = SecuredDomainType.MARK_TEMPLATE;
        AccessControlledActionsColumn actionsColumn = AccessControlledActionsColumn.create((ImagesBarCell)new DefaultActionsImagesBarCell((com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages), (UserService)userService);
        EditOwnershipDialog.DialogConfig configOwnership = EditOwnershipDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, markTemplate -> this.markTemplateListDataProvider.refresh(), (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, markTemplate -> {
            AccessControlListDTO accessControlListDTO = markTemplate.getAccessControlList();
        }, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        actionsColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, arg_0 -> ((EditOwnershipDialog.DialogConfig)configOwnership).openOwnershipDialog(arg_0));
        actionsColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL, markTemplate -> configACL.openDialog((SecuredDTO)markTemplate));
        this.markTemplateTable.addColumn((Column)idColumn, this.stringMessages.id());
        this.markTemplateTable.addColumn((Column)actionsColumn, this.stringMessages.actions());
        this.refreshableSelectionModel = checkColumn.getSelectionModel();
        this.markTemplateTable.setSelectionModel((SelectionModel)this.refreshableSelectionModel, checkColumn.getSelectionManager());
    }

    public void refreshMarkTemplates() {
        this.loadMarkTemplates();
    }

    void openEditMarkTemplateDialog(MarkTemplateDTO originalMarkTemplate) {
        MarkTemplateEditDialog dialog = new MarkTemplateEditDialog(this.stringMessages, originalMarkTemplate, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.ensureDebugId("MarkTemplateEditDialog");
        dialog.show();
    }

    public AbstractFilterablePanel<MarkTemplateDTO> getFilterablePanel() {
        return this.filterableMarkTemplates;
    }

    static /* synthetic */ FlushableCellTable access$0(MarkTemplatePanel markTemplatePanel) {
        return markTemplatePanel.markTemplateTable;
    }

    static /* synthetic */ ErrorReporter access$1(MarkTemplatePanel markTemplatePanel) {
        return markTemplatePanel.errorReporter;
    }

    static /* synthetic */ ListDataProvider access$2(MarkTemplatePanel markTemplatePanel) {
        return markTemplatePanel.markTemplateListDataProvider;
    }

    static /* synthetic */ LabeledAbstractFilterablePanel access$3(MarkTemplatePanel markTemplatePanel) {
        return markTemplatePanel.filterableMarkTemplates;
    }

    static /* synthetic */ SailingServiceWriteAsync access$4(MarkTemplatePanel markTemplatePanel) {
        return markTemplatePanel.sailingServiceWrite;
    }
}

