/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.AbstractEventManagementPanel;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.adminconsole.yellowbrick.YellowBrickConfigurationDialog;
import com.sap.sailing.gwt.ui.adminconsole.yellowbrick.YellowBrickConfigurationTableWrapper;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.YellowBrickConfigurationWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.YellowBrickRaceRecordDTO;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.adminconsole.FilterablePanelProvider;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import com.sap.sse.gwt.client.celltable.AbstractSortableTextColumn;
import com.sap.sse.gwt.client.celltable.CellTableWithCheckboxResources;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.TableWrapperWithMultiSelectionAndFilter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.AbstractFilterablePanel;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;

public class YellowBrickEventManagementPanel
extends AbstractEventManagementPanel
implements FilterablePanelProvider<YellowBrickConfigurationWithSecurityDTO> {
    private final ErrorReporter errorReporter;
    private YellowBrickConfigurationTableWrapper connectionsTable;
    private Label loadingMessageLabel;
    private TableWrapperWithMultiSelectionAndFilter<YellowBrickRaceRecordDTO, StringMessages, AdminConsoleTableResources> racesTableWrapper;
    private final UserService userService;
    private final CellTableWithCheckboxResources tableResources;
    private final SailingServiceWriteAsync sailingServiceWrite;

    public YellowBrickEventManagementPanel(AdminConsoleView.Presenter presenter, StringMessages stringMessages, CellTableWithCheckboxResources tableResources) {
        super(presenter, true, stringMessages);
        this.userService = presenter.getUserService();
        this.errorReporter = presenter.getErrorReporter();
        this.sailingServiceWrite = presenter.getSailingService();
        this.tableResources = tableResources;
        this.setWidget(this.createContent());
    }

    protected Widget createContent() {
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setWidth("100%");
        CaptionPanel connectionsPanel = this.createConnectionsPanel();
        mainPanel.add((Widget)connectionsPanel);
        HorizontalPanel racesPanel = this.createRacesPanel();
        racesPanel.setWidth("100%");
        mainPanel.add((Widget)racesPanel);
        return mainPanel;
    }

    protected CaptionPanel createConnectionsPanel() {
        CaptionPanel connectionsPanel = new CaptionPanel("YellowBrick " + this.stringMessages.connections());
        connectionsPanel.ensureDebugId("YellowBrickConfigurationsSection");
        connectionsPanel.setStyleName("bold");
        VerticalPanel tableAndConfigurationPanel = new VerticalPanel();
        this.connectionsTable = new YellowBrickConfigurationTableWrapper(this.userService, this.sailingServiceWrite, this.stringMessages, this.errorReporter, true, this.tableResources, () -> {});
        this.connectionsTable.refreshYellowBrickConfigurationList();
        Grid grid = new Grid(1, 2);
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(this.userService, SecuredDomainType.TRACKED_RACE);
        buttonPanel.addUnsecuredAction(this.stringMessages.refresh(), () -> this.connectionsTable.refreshYellowBrickConfigurationList());
        Button addCreateAction = buttonPanel.addCreateAction(this.stringMessages.addYellowBrickConfiguration(), () -> new YellowBrickConfigurationDialog((DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */, this.userService, this.errorReporter).show());
        addCreateAction.ensureDebugId("AddConnectionButton");
        buttonPanel.addRemoveAction(this.stringMessages.remove(), (SetSelectionModel)this.connectionsTable.getSelectionModel(), false, () -> this.sailingServiceWrite.deleteYellowBrickConfigurations((Collection)((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).getSelectedSet(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        this.loadingMessageLabel = new Label();
        Button listRacesButton = buttonPanel.addUnsecuredAction(this.stringMessages.listRaces(), () -> {
            this.loadingMessageLabel.setText(this.stringMessages.loading());
            this.fillRaces((SailingServiceAsync)this.sailingServiceWrite);
        });
        listRacesButton.ensureDebugId("ListRacesButton");
        listRacesButton.setEnabled(false);
        buttonPanel.addUnsecuredWidget((Widget)this.loadingMessageLabel);
        ((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).addSelectionChangeHandler(e -> {
            boolean objectSelected = ((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).getSelectedSet().size() == 1;
            listRacesButton.setEnabled(objectSelected);
        });
        tableAndConfigurationPanel.add((Widget)buttonPanel);
        tableAndConfigurationPanel.add((Widget)grid);
        tableAndConfigurationPanel.add((IsWidget)this.connectionsTable);
        connectionsPanel.setContentWidget((Widget)tableAndConfigurationPanel);
        return connectionsPanel;
    }

    protected HorizontalPanel createRacesPanel() {
        HorizontalPanel racesPanel = new HorizontalPanel();
        CaptionPanel trackableRacesPanel = this.createTrackableRacesPanel();
        racesPanel.add((Widget)trackableRacesPanel);
        racesPanel.setCellWidth((Widget)trackableRacesPanel, "50%");
        CaptionPanel trackedRacesPanel = this.createTrackedRacesPanel();
        racesPanel.add((Widget)trackedRacesPanel);
        racesPanel.setCellWidth((Widget)trackedRacesPanel, "50%");
        return racesPanel;
    }

    protected CaptionPanel createTrackableRacesPanel() {
        CaptionPanel trackableRacesPanel = new CaptionPanel(this.stringMessages.trackableRaces());
        trackableRacesPanel.ensureDebugId("YellowBrickTrackableRacesSection");
        trackableRacesPanel.setStyleName("bold");
        FlexTable layoutTable = new FlexTable();
        layoutTable.setWidth("100%");
        HTMLTable.ColumnFormatter columnFormatter = layoutTable.getColumnFormatter();
        FlexTable.FlexCellFormatter cellFormatter = layoutTable.getFlexCellFormatter();
        columnFormatter.setWidth(0, "130px");
        Label regattaForTrackingLabel = new Label(this.stringMessages.regattaUsedForTheTrackedRace());
        regattaForTrackingLabel.setWordWrap(false);
        int row = 0;
        layoutTable.setWidget(row, 0, (Widget)regattaForTrackingLabel);
        layoutTable.setWidget(row, 1, (Widget)this.getAvailableRegattasListBox());
        Label trackSettingsLabel = new Label(String.valueOf(this.stringMessages.trackSettings()) + ":");
        CheckBox trackWindCheckBox = new CheckBox(this.stringMessages.trackWind());
        trackWindCheckBox.ensureDebugId("YellowBrickTrackWindCheckBox");
        trackWindCheckBox.setWordWrap(false);
        trackWindCheckBox.setValue(Boolean.TRUE);
        CheckBox correctWindCheckBox = new CheckBox(this.stringMessages.declinationCheckbox());
        correctWindCheckBox.ensureDebugId("YellowBrickCorrectWindCheckBox");
        correctWindCheckBox.setWordWrap(false);
        correctWindCheckBox.setValue(Boolean.TRUE);
        layoutTable.setWidget(++row, 0, (Widget)trackSettingsLabel);
        layoutTable.setWidget(row, 1, (Widget)trackWindCheckBox);
        layoutTable.setWidget(++row, 1, (Widget)correctWindCheckBox);
        AdminConsoleTableResources tableResources = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);
        this.racesTableWrapper = new /* Unavailable Anonymous Inner Class!! */;
        this.racesTableWrapper.getTable().ensureDebugId("YellowBrickTrackableRacesCellTable");
        AbstractSortableTextColumn raceNameColumn = new AbstractSortableTextColumn(o -> o.getName(), this.racesTableWrapper.getColumnSortHandler());
        AbstractSortableTextColumn raceUrlColumn = new AbstractSortableTextColumn(o -> o.getRaceUrl(), this.racesTableWrapper.getColumnSortHandler());
        AbstractSortableTextColumn timePointOfLastFixColumn = new AbstractSortableTextColumn(o -> "" + o.getTimePointOfLastFix(), this.racesTableWrapper.getColumnSortHandler(), Comparator.comparing(o -> o.getTimePointOfLastFix()));
        AbstractSortableTextColumn numberOfCompetitorsColumn = new AbstractSortableTextColumn(o -> Integer.toString(o.getNumberOfCompetitors()), this.racesTableWrapper.getColumnSortHandler(), Comparator.comparing(o -> o.getNumberOfCompetitors()));
        this.racesTableWrapper.addColumn((Column)raceNameColumn, this.stringMessages.race());
        this.racesTableWrapper.addColumn((Column)raceUrlColumn, this.stringMessages.raceUrl());
        this.racesTableWrapper.addColumn((Column)timePointOfLastFixColumn, this.stringMessages.timePointOfLastFix());
        this.racesTableWrapper.addColumn((Column)numberOfCompetitorsColumn, this.stringMessages.numberOfCompetitors());
        layoutTable.setWidget(++row, 0, (IsWidget)this.racesTableWrapper);
        cellFormatter.setColSpan(row, 0, 2);
        Button startTrackingButton = new Button(this.stringMessages.startTracking());
        startTrackingButton.setEnabled(false);
        ((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).addSelectionChangeHandler(e -> startTrackingButton.setEnabled(((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).getSelectedSet().size() == 1));
        startTrackingButton.ensureDebugId("StartTrackingButton");
        startTrackingButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        layoutTable.setWidget(++row, 1, (Widget)startTrackingButton);
        trackableRacesPanel.setContentWidget((Widget)layoutTable);
        return trackableRacesPanel;
    }

    protected CaptionPanel createTrackedRacesPanel() {
        CaptionPanel trackedRacesPanel = new CaptionPanel(this.stringMessages.trackedRaces());
        trackedRacesPanel.ensureDebugId("TrackedRacesSection");
        trackedRacesPanel.setStyleName("bold");
        trackedRacesPanel.setContentWidget((Widget)this.trackedRacesListComposite);
        return trackedRacesPanel;
    }

    protected void reportError(String message) {
        this.errorReporter.reportError(message);
    }

    private void fillRaces(SailingServiceAsync sailingService) {
        Set selectedConnections = ((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).getSelectedSet();
        if (!selectedConnections.isEmpty()) {
            YellowBrickConfigurationWithSecurityDTO selectedConnection = (YellowBrickConfigurationWithSecurityDTO)selectedConnections.iterator().next();
            sailingService.listYellowBrickRacesInEvent(selectedConnection, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        }
    }

    private void trackSelectedRaces(boolean trackWind, boolean correctWind) {
        YellowBrickConfigurationWithSecurityDTO selectedConnection = (YellowBrickConfigurationWithSecurityDTO)((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).getSelectedSet().iterator().next();
        String creatorName = selectedConnection.getCreatorName();
        String raceUrl = selectedConnection.getRaceUrl();
        RegattaDTO selectedRegatta = this.getSelectedRegatta();
        RegattaName regattaIdentifier = null;
        if (selectedRegatta != null) {
            regattaIdentifier = new RegattaName(selectedRegatta.getName());
        }
        RefreshableMultiSelectionModel selectionModel = (RefreshableMultiSelectionModel)this.racesTableWrapper.getSelectionModel();
        ArrayList selectedRaces = new ArrayList(selectionModel.getSelectedSet());
        this.sailingServiceWrite.trackWithYellowBrick((RegattaIdentifier)regattaIdentifier, selectedRaces, trackWind, correctWind, creatorName, raceUrl, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    public void refreshYellowBrickConnectors() {
        this.connectionsTable.refreshYellowBrickConfigurationList();
    }

    public AbstractFilterablePanel<YellowBrickConfigurationWithSecurityDTO> getFilterablePanel() {
        return this.connectionsTable.getFilterField();
    }

    static /* synthetic */ ErrorReporter access$0(YellowBrickEventManagementPanel yellowBrickEventManagementPanel) {
        return yellowBrickEventManagementPanel.errorReporter;
    }

    static /* synthetic */ YellowBrickConfigurationTableWrapper access$1(YellowBrickEventManagementPanel yellowBrickEventManagementPanel) {
        return yellowBrickEventManagementPanel.connectionsTable;
    }

    static /* synthetic */ SailingServiceWriteAsync access$2(YellowBrickEventManagementPanel yellowBrickEventManagementPanel) {
        return yellowBrickEventManagementPanel.sailingServiceWrite;
    }

    static /* synthetic */ void access$3(YellowBrickEventManagementPanel yellowBrickEventManagementPanel, boolean bl, boolean bl2) {
        yellowBrickEventManagementPanel.trackSelectedRaces(bl, bl2);
    }

    static /* synthetic */ Label access$4(YellowBrickEventManagementPanel yellowBrickEventManagementPanel) {
        return yellowBrickEventManagementPanel.loadingMessageLabel;
    }

    static /* synthetic */ TableWrapperWithMultiSelectionAndFilter access$5(YellowBrickEventManagementPanel yellowBrickEventManagementPanel) {
        return yellowBrickEventManagementPanel.racesTableWrapper;
    }

    static /* synthetic */ StringMessages access$6(YellowBrickEventManagementPanel yellowBrickEventManagementPanel) {
        return yellowBrickEventManagementPanel.stringMessages;
    }

    static /* synthetic */ AdminConsoleView.Presenter access$7(YellowBrickEventManagementPanel yellowBrickEventManagementPanel) {
        return yellowBrickEventManagementPanel.presenter;
    }
}

