/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.BranchIO;
import com.sap.sailing.domain.common.MailInvitationType;
import com.sap.sailing.gwt.ui.adminconsole.RegistrationLinkWithQRCode;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.controls.GenericListBox;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.shared.ClientConfiguration;
import java.util.HashMap;
import java.util.Optional;

/*
 * Exception performing whole class analysis ignored.
 */
public class RegistrationLinkWithQRCodeDialog
extends DataEntryDialog<RegistrationLinkWithQRCode> {
    private final String regattaName;
    private final SailingServiceAsync sailingService;
    private final StringMessages stringMessages;
    private final CaptionPanel registrationLinkPanel;
    private final VerticalPanel registrationLinkPanelContent;
    private final Label registrationLinkExplain;
    private final CaptionPanel barcodePanel;
    private final VerticalPanel barcodePanelContent;
    private final Label barcodeExplainLabel;
    private final TextBox urlTextBox;
    private final Image qrCodeImage;
    private final String secret;
    private final GenericListBox<EventDTO> events;
    private RegistrationLinkWithQRCode registrationLinkWithQRCode;
    private MailInvitationType invitationType;

    public RegistrationLinkWithQRCodeDialog(SailingServiceAsync sailingService, StringMessages stringMessages, String regattaName, RegistrationLinkWithQRCode registrationLinkWithQRCode, DataEntryDialog.DialogCallback<RegistrationLinkWithQRCode> callback, String secret, MailInvitationType invitationType) {
        super(stringMessages.registrationLinkDialog(), stringMessages.explainRegistrationLinkDialog(), stringMessages.ok(), stringMessages.cancel(), null, true, callback);
        this.sailingService = sailingService;
        this.stringMessages = stringMessages;
        this.regattaName = regattaName;
        this.invitationType = invitationType;
        this.registrationLinkWithQRCode = registrationLinkWithQRCode == null ? new RegistrationLinkWithQRCode() : registrationLinkWithQRCode;
        this.registrationLinkPanel = new CaptionPanel(stringMessages.registrationLinkUrl());
        this.registrationLinkPanelContent = new VerticalPanel();
        this.registrationLinkPanel.add((Widget)this.registrationLinkPanelContent);
        Label eventExplain = new Label(stringMessages.event());
        this.events = this.createGenericListBox((GenericListBox.ValueBuilder)new /* Unavailable Anonymous Inner Class!! */, false);
        sailingService.getEventsForLeaderboard(regattaName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.events.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.registrationLinkPanelContent.add((Widget)eventExplain);
        this.registrationLinkPanelContent.add((Widget)this.events);
        this.registrationLinkExplain = new Label(stringMessages.registrationLinkUrlExplain());
        this.registrationLinkPanelContent.add((Widget)this.registrationLinkExplain);
        this.urlTextBox = this.createTextBox("URL", 100);
        this.urlTextBox.ensureDebugId("RegistrationLinkUrl");
        this.registrationLinkPanelContent.add((Widget)this.urlTextBox);
        Anchor copyAnchor = new Anchor(stringMessages.copyToClipboard());
        copyAnchor.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.registrationLinkPanelContent.add((Widget)copyAnchor);
        this.barcodePanel = new CaptionPanel(stringMessages.registrationLinkDialogQrcode());
        this.barcodePanelContent = new VerticalPanel();
        this.barcodePanel.add((Widget)this.barcodePanelContent);
        this.barcodeExplainLabel = new Label(stringMessages.registrationLinkDialogQrcodeExplain());
        this.barcodePanelContent.add((Widget)this.barcodeExplainLabel);
        this.qrCodeImage = new Image();
        this.qrCodeImage.ensureDebugId("OpenRegattaRegistrationLinkQrCode");
        this.barcodePanelContent.add((Widget)this.qrCodeImage);
        this.secret = secret;
    }

    protected RegistrationLinkWithQRCode getResult() {
        return this.registrationLinkWithQRCode;
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel panel = new VerticalPanel();
        Widget additionalWidget = super.getAdditionalWidget();
        if (additionalWidget != null) {
            panel.add(additionalWidget);
        }
        VerticalPanel dialogPanel = new VerticalPanel();
        panel.add((Widget)dialogPanel);
        dialogPanel.add((Widget)this.registrationLinkPanel);
        dialogPanel.add((Widget)this.barcodePanel);
        return panel;
    }

    private void updateDisplayWidgets() {
        if (this.events.getValue() == null) {
            Notification.notify((String)this.stringMessages.noEventSelected(), (Notification.NotificationType)Notification.NotificationType.ERROR);
            return;
        }
        String baseUrl = GWT.getHostPageBaseURL();
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.lastIndexOf("/"));
            baseUrl = baseUrl.substring(0, baseUrl.indexOf("/gwt"));
        }
        String eventIdAsString = ((EventDTO)this.events.getValue()).id.toString();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("regatta_name", this.regattaName);
        parameters.put("secret", this.secret);
        parameters.put("server", baseUrl);
        parameters.put("event_id", eventIdAsString);
        if (this.invitationType.isSupportsOpenRegattas()) {
            String deeplinkUrl = BranchIO.generateLink((String)this.invitationType.getBranchIOopenRegattaURL(), parameters, URL::encodeQueryString);
            this.urlTextBox.setText(deeplinkUrl);
            this.sailingService.openRegattaRegistrationQrCode(deeplinkUrl, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            if (ClientConfiguration.getInstance().isBrandingActive()) {
                this.getStatusLabel().setText(this.stringMessages.warningSailInsightVersion(ClientConfiguration.getInstance().getBrandTitle(Optional.empty())));
            } else {
                this.getStatusLabel().setText(this.stringMessages.warningSailInsightVersion(""));
            }
            this.getStatusLabel().setStyleName("errorLabel");
        }
    }

    private static native boolean copyToClipboard();

    static /* synthetic */ GenericListBox access$1(RegistrationLinkWithQRCodeDialog registrationLinkWithQRCodeDialog) {
        return registrationLinkWithQRCodeDialog.events;
    }

    static /* synthetic */ void access$2(RegistrationLinkWithQRCodeDialog registrationLinkWithQRCodeDialog) {
        registrationLinkWithQRCodeDialog.updateDisplayWidgets();
    }

    static /* synthetic */ TextBox access$3(RegistrationLinkWithQRCodeDialog registrationLinkWithQRCodeDialog) {
        return registrationLinkWithQRCodeDialog.urlTextBox;
    }

    static /* synthetic */ boolean access$4() {
        return RegistrationLinkWithQRCodeDialog.copyToClipboard();
    }

    static /* synthetic */ Image access$5(RegistrationLinkWithQRCodeDialog registrationLinkWithQRCodeDialog) {
        return registrationLinkWithQRCodeDialog.qrCodeImage;
    }
}

