/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.sap.sailing.domain.common.impl.NauticalMileDistance;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveLegTypes;
import com.sap.sailing.domain.common.orc.impl.ORCPerformanceCurveLegImpl;
import com.sap.sailing.gwt.ui.adminconsole.AbstractORCPerformanceCurveLegDialog;
import com.sap.sailing.gwt.ui.adminconsole.CourseManagementWidget;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.WaypointDTO;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.dialog.DoubleBox;
import java.util.stream.IntStream;

public class ORCPerformanceCurveAllLegsDialog
extends AbstractORCPerformanceCurveLegDialog<ORCPerformanceCurveLegImpl[]> {
    private final ListBox commonLegTypeBox;
    private final DoubleBox desiredTotalCourseDistanceInNauticalMilesBox;
    private final ListBox[] legTypeBoxes;
    private final Label totalDistanceInNauticalMilesLabel;
    private final DoubleBox[] distanceInNauticalMilesBoxes;
    private final DoubleBox[] twdBoxes;
    private final DoubleBox[] legDirectionBoxes;
    private final DoubleBox[] twaBoxes;
    private final StringMessages stringMessages;
    private final ListDataProvider<WaypointDTO> waypointList;
    private final CourseManagementWidget.LegGeometrySupplier legGeometrySupplier;
    private ORCPerformanceCurveLegImpl[] trackingBasedCourseGeometry;
    private final Label[] trackedTwaInDegreesLabels;
    private final Label[] trackedDistanceInNauticalMilesLabels;
    final Button spreadTotalDistanceProportionallyAcrossLegsButton;

    public ORCPerformanceCurveAllLegsDialog(StringMessages stringMessages, ListDataProvider<WaypointDTO> waypointList, ORCPerformanceCurveLegImpl[] orcLegParametersSoFar, CourseManagementWidget.LegGeometrySupplier legGeometrySupplier, DataEntryDialog.Validator<ORCPerformanceCurveLegImpl[]> validator, DataEntryDialog.DialogCallback<ORCPerformanceCurveLegImpl[]> callback) {
        super(stringMessages.orcPerformanceCurveLegs(), stringMessages.orcPerformanceCurveLegs(), stringMessages, validator, callback);
        this.stringMessages = stringMessages;
        this.waypointList = waypointList;
        this.legGeometrySupplier = legGeometrySupplier;
        this.commonLegTypeBox = this.createLegTypeBox(null);
        this.desiredTotalCourseDistanceInNauticalMilesBox = this.createDoubleBox(5);
        this.totalDistanceInNauticalMilesLabel = new Label();
        this.legTypeBoxes = new ListBox[waypointList.getList().size() - 1];
        this.twdBoxes = new DoubleBox[waypointList.getList().size() - 1];
        this.legDirectionBoxes = new DoubleBox[waypointList.getList().size() - 1];
        this.twaBoxes = new DoubleBox[waypointList.getList().size() - 1];
        this.distanceInNauticalMilesBoxes = new DoubleBox[waypointList.getList().size() - 1];
        this.trackedTwaInDegreesLabels = new Label[waypointList.getList().size() - 1];
        this.trackedDistanceInNauticalMilesLabels = new Label[waypointList.getList().size() - 1];
        int i = 0;
        while (i < waypointList.getList().size() - 1) {
            int zeroBasedLegNumber = i;
            this.legTypeBoxes[i] = this.createLegTypeBox(orcLegParametersSoFar[i]);
            this.distanceInNauticalMilesBoxes[i] = this.createDoubleBox(5);
            this.distanceInNauticalMilesBoxes[i].addChangeHandler(e -> this.updateTotalDistanceLabel());
            this.twdBoxes[i] = this.createDoubleBox(5);
            this.legDirectionBoxes[i] = this.createDoubleBox(5);
            this.twaBoxes[i] = this.createDoubleBox(5);
            this.twdBoxes[i].addValueChangeHandler(e -> this.updateTwaBoxFromTwdAndLegDirection(this.twdBoxes[zeroBasedLegNumber], this.legDirectionBoxes[zeroBasedLegNumber], this.twaBoxes[zeroBasedLegNumber]));
            this.legDirectionBoxes[i].addValueChangeHandler(e -> this.updateTwaBoxFromTwdAndLegDirection(this.twdBoxes[zeroBasedLegNumber], this.legDirectionBoxes[zeroBasedLegNumber], this.twaBoxes[zeroBasedLegNumber]));
            if (orcLegParametersSoFar != null && orcLegParametersSoFar[i] != null) {
                this.distanceInNauticalMilesBoxes[i].setValue((Object)orcLegParametersSoFar[i].getLength().getNauticalMiles());
                this.twaBoxes[i].setValue(orcLegParametersSoFar[i].getTwa() == null ? null : Double.valueOf(orcLegParametersSoFar[i].getTwa().getDegrees()));
            }
            this.trackedTwaInDegreesLabels[i] = new Label();
            this.trackedDistanceInNauticalMilesLabels[i] = new Label();
            this.legTypeBoxes[i].addChangeHandler(e -> this.updateAfterLegTypeChange(zeroBasedLegNumber));
            this.updateAfterLegTypeChange(zeroBasedLegNumber);
            ++i;
        }
        this.spreadTotalDistanceProportionallyAcrossLegsButton = new Button(stringMessages.spreadTotalDistanceProportionallyAcrossLegs());
        this.desiredTotalCourseDistanceInNauticalMilesBox.addChangeHandler(e -> this.adjustEnablednessOfSpreadButton());
        this.spreadTotalDistanceProportionallyAcrossLegsButton.addClickHandler(e -> this.spreadTotalDistance());
        this.adjustEnablednessOfSpreadButton();
        this.commonLegTypeBox.addChangeHandler(e -> {
            int zeroBasedLegNumber = 0;
            ListBox[] listBoxArray = this.legTypeBoxes;
            int n = this.legTypeBoxes.length;
            int n2 = 0;
            while (n2 < n) {
                ListBox legTypeBox = listBoxArray[n2];
                legTypeBox.setSelectedIndex(this.commonLegTypeBox.getSelectedIndex());
                this.updateAfterLegTypeChange(zeroBasedLegNumber++);
                ++n2;
            }
            this.validateAndUpdate();
        });
        this.fetchTrackingBasedDistanceAndTwa();
    }

    private void adjustEnablednessOfSpreadButton() {
        this.spreadTotalDistanceProportionallyAcrossLegsButton.setEnabled(this.desiredTotalCourseDistanceInNauticalMilesBox.getValue() != null);
    }

    private void updateAfterLegTypeChange(int zeroBasedLegNumber) {
        this.twaBoxes[zeroBasedLegNumber].setEnabled(this.getSelectedLegType(zeroBasedLegNumber) == ORCPerformanceCurveLegTypes.TWA);
        this.distanceInNauticalMilesBoxes[zeroBasedLegNumber].setEnabled(this.getSelectedLegType(zeroBasedLegNumber) != null);
    }

    private void updateTotalDistanceLabel() {
        Distance totalDistance = this.getEffectiveTotalDistance(this.getResult());
        this.totalDistanceInNauticalMilesLabel.setText(Util.padPositiveValue((double)totalDistance.getNauticalMiles(), (int)1, (int)3, (boolean)true));
    }

    protected void validateAndUpdate() {
        this.updateTotalDistanceLabel();
        super.validateAndUpdate();
    }

    private Distance getEffectiveTotalDistance(ORCPerformanceCurveLegImpl[] explicitLegSpecs) {
        Distance.NullDistance totalDistance = Distance.NULL;
        int i = 0;
        while (i < explicitLegSpecs.length) {
            Distance legDistance = this.getEffectiveLegDistance(explicitLegSpecs, i);
            totalDistance = totalDistance.add(legDistance);
            ++i;
        }
        return totalDistance;
    }

    protected Distance getEffectiveLegDistance(ORCPerformanceCurveLegImpl[] explicitLegSpecs, int zeroBasedLegIndex) {
        Object legDistance = explicitLegSpecs[zeroBasedLegIndex] != null && explicitLegSpecs[zeroBasedLegIndex].getLength() != null ? explicitLegSpecs[zeroBasedLegIndex].getLength() : (this.trackingBasedCourseGeometry != null && this.trackingBasedCourseGeometry.length > zeroBasedLegIndex && this.trackingBasedCourseGeometry[zeroBasedLegIndex] != null ? this.trackingBasedCourseGeometry[zeroBasedLegIndex].getLength() : Distance.NULL);
        return legDistance;
    }

    private void fetchTrackingBasedDistanceAndTwa() {
        this.legGeometrySupplier.getLegGeometry(IntStream.range(0, this.waypointList.getList().size() - 1).toArray(), this.getSelectedLegTypes(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private ORCPerformanceCurveLegTypes getSelectedLegType(int zeroBasedLegNumber) {
        String selectedValue = this.legTypeBoxes[zeroBasedLegNumber].getSelectedValue();
        return selectedValue == null || selectedValue.equals("null") ? null : ORCPerformanceCurveLegTypes.valueOf((String)selectedValue);
    }

    private ORCPerformanceCurveLegTypes[] getSelectedLegTypes() {
        ORCPerformanceCurveLegTypes[] result = new ORCPerformanceCurveLegTypes[this.legTypeBoxes.length];
        int i = 0;
        while (i < this.legTypeBoxes.length) {
            result[i] = this.getSelectedLegType(i);
            ++i;
        }
        return result;
    }

    protected Widget getAdditionalWidget() {
        Grid result = new Grid(this.waypointList.getList().size() + 1, 9);
        int row = 0;
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.setAllLegsToType()));
        result.setWidget(row, 1, (Widget)this.commonLegTypeBox);
        result.setWidget(row, 2, (Widget)new Label(this.stringMessages.totalDistance()));
        result.setWidget(row, 3, (Widget)this.totalDistanceInNauticalMilesLabel);
        result.setWidget(row, 4, (Widget)new Label(this.stringMessages.desiredTotalDistanceInNauticalMiles()));
        result.setWidget(row, 5, (Widget)this.desiredTotalCourseDistanceInNauticalMilesBox);
        result.setWidget(row, 6, (Widget)this.spreadTotalDistanceProportionallyAcrossLegsButton);
        result.setWidget(++row, 1, (Widget)new Label(this.stringMessages.legType()));
        result.setWidget(row, 2, (Widget)new Label(this.stringMessages.distanceInNauticalMiles()));
        result.setWidget(row, 3, (Widget)new Label(this.stringMessages.twdInDegrees()));
        result.setWidget(row, 4, (Widget)new Label(this.stringMessages.legDirectionInDegrees()));
        result.setWidget(row, 5, (Widget)new Label(this.stringMessages.legTwaInDegrees()));
        result.setWidget(row, 6, (Widget)new Label(this.stringMessages.trackedDistanceInNauticalMiles()));
        result.setWidget(row, 7, (Widget)new Label(this.stringMessages.trackedTwaInDegrees()));
        ++row;
        int i = 0;
        while (i < this.waypointList.getList().size() - 1) {
            int index = i;
            result.setWidget(row, 0, (Widget)new Label(String.valueOf(((WaypointDTO)this.waypointList.getList().get(i)).getName()) + " - " + ((WaypointDTO)this.waypointList.getList().get(i + 1)).getName()));
            result.setWidget(row, 1, (Widget)this.legTypeBoxes[i]);
            result.setWidget(row, 2, (Widget)this.distanceInNauticalMilesBoxes[i]);
            result.setWidget(row, 3, (Widget)this.twdBoxes[i]);
            result.setWidget(row, 4, (Widget)this.legDirectionBoxes[i]);
            result.setWidget(row, 5, (Widget)this.twaBoxes[i]);
            result.setWidget(row, 6, (Widget)this.trackedDistanceInNauticalMilesLabels[i]);
            result.setWidget(row, 7, (Widget)this.trackedTwaInDegreesLabels[i]);
            Button useTrackedDataButton = new Button(this.stringMessages.useTrackedData());
            useTrackedDataButton.addClickHandler(e -> {
                this.twaBoxes[index].setValue(this.trackingBasedCourseGeometry.length <= index || this.trackingBasedCourseGeometry[index] == null ? null : Double.valueOf(this.trackingBasedCourseGeometry[index].getTwa().getDegrees()));
                this.distanceInNauticalMilesBoxes[index].setValue(this.trackingBasedCourseGeometry.length <= index || this.trackingBasedCourseGeometry[index] == null ? null : Double.valueOf(this.trackingBasedCourseGeometry[index].getLength().getNauticalMiles()));
                this.validateAndUpdate();
            });
            result.setWidget(row, 8, (Widget)useTrackedDataButton);
            ++row;
            ++i;
        }
        return result;
    }

    private void spreadTotalDistance() {
        Double desiredTotalDistanceInNauticalMiles = (Double)this.desiredTotalCourseDistanceInNauticalMilesBox.getValue();
        if (desiredTotalDistanceInNauticalMiles != null) {
            NauticalMileDistance desiredTotalDistance = new NauticalMileDistance(desiredTotalDistanceInNauticalMiles.doubleValue());
            ORCPerformanceCurveLegImpl[] legData = this.getResult();
            Distance currentTotalDistance = this.getEffectiveTotalDistance(legData);
            Distance.NullDistance checkSum = Distance.NULL;
            int zeroBasedLegIndex = 0;
            while (zeroBasedLegIndex < this.waypointList.getList().size() - 1) {
                Distance effectiveLegDistance = this.getEffectiveLegDistance(legData, zeroBasedLegIndex);
                Distance newExplicitLegDistance = desiredTotalDistance.scale(effectiveLegDistance.divide(currentTotalDistance));
                this.distanceInNauticalMilesBoxes[zeroBasedLegIndex].setValue((Object)newExplicitLegDistance.getNauticalMiles());
                checkSum = checkSum.add(effectiveLegDistance);
                ++zeroBasedLegIndex;
            }
            this.updateTotalDistanceLabel();
            this.validateAndUpdate();
        }
    }

    public FocusWidget getInitialFocusWidget() {
        return this.desiredTotalCourseDistanceInNauticalMilesBox;
    }

    protected ORCPerformanceCurveLegImpl[] getResult() {
        ORCPerformanceCurveLegImpl[] result = new ORCPerformanceCurveLegImpl[this.waypointList.getList().size() - 1];
        int i = 0;
        while (i < result.length) {
            ORCPerformanceCurveLegTypes selectedLegType = this.getSelectedLegType(i);
            result[i] = selectedLegType == null ? null : (selectedLegType == ORCPerformanceCurveLegTypes.TWA ? new ORCPerformanceCurveLegImpl((Distance)(this.distanceInNauticalMilesBoxes[i].getValue() == null ? null : new NauticalMileDistance(((Double)this.distanceInNauticalMilesBoxes[i].getValue()).doubleValue())), (Bearing)(this.twaBoxes[i].getValue() == null ? null : new DegreeBearingImpl(((Double)this.twaBoxes[i].getValue()).doubleValue()))) : new ORCPerformanceCurveLegImpl((Distance)(this.distanceInNauticalMilesBoxes[i].getValue() == null ? null : new NauticalMileDistance(((Double)this.distanceInNauticalMilesBoxes[i].getValue()).doubleValue())), selectedLegType));
            ++i;
        }
        return result;
    }

    static /* synthetic */ void access$2(ORCPerformanceCurveAllLegsDialog oRCPerformanceCurveAllLegsDialog, ORCPerformanceCurveLegImpl[] oRCPerformanceCurveLegImplArray) {
        oRCPerformanceCurveAllLegsDialog.trackingBasedCourseGeometry = oRCPerformanceCurveLegImplArray;
    }

    static /* synthetic */ Label[] access$3(ORCPerformanceCurveAllLegsDialog oRCPerformanceCurveAllLegsDialog) {
        return oRCPerformanceCurveAllLegsDialog.trackedTwaInDegreesLabels;
    }

    static /* synthetic */ Label[] access$4(ORCPerformanceCurveAllLegsDialog oRCPerformanceCurveAllLegsDialog) {
        return oRCPerformanceCurveAllLegsDialog.trackedDistanceInNauticalMilesLabels;
    }
}

