/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTOImpl;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorImportProviderSelectionDialog;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorInvitationHelper;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.Displayer;
import com.sap.sailing.gwt.ui.client.Refresher;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.adminconsole.FilterablePanelProvider;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.controls.busyindicator.BusyDisplay;
import com.sap.sse.gwt.client.controls.busyindicator.BusyIndicator;
import com.sap.sse.gwt.client.controls.busyindicator.SimpleBusyIndicator;
import com.sap.sse.gwt.client.panels.AbstractFilterablePanel;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import java.util.Set;

public class CompetitorPanel
extends SimplePanel
implements BusyDisplay,
FilterablePanelProvider<CompetitorDTO> {
    private final CompetitorTableWrapper<RefreshableMultiSelectionModel<CompetitorDTO>> competitorTable;
    private final RefreshableMultiSelectionModel<CompetitorDTO> refreshableCompetitorSelectionModel;
    private final String leaderboardName;
    private final String boatClassName;
    private final BusyIndicator busyIndicator;
    private final Displayer<CompetitorDTO> competitorsDisplayer = new /* Unavailable Anonymous Inner Class!! */;

    public CompetitorPanel(AdminConsoleView.Presenter presenter, StringMessages stringMessages) {
        this(presenter.getSailingService(), presenter.getUserService(), presenter.getCompetitorsRefresher(), presenter.getBoatsRefresher(), null, null, true, stringMessages, presenter.getErrorReporter());
    }

    public CompetitorPanel(SailingServiceWriteAsync sailingServiceWrite, UserService userService, Refresher<CompetitorDTO> competitorsRefresher, Refresher<BoatDTO> boatsRefresher, String leaderboardName, String boatClassName, boolean createWithBoatByDefault, StringMessages stringMessages, ErrorReporter errorReporter) {
        this.leaderboardName = leaderboardName;
        this.boatClassName = boatClassName;
        this.competitorTable = new CompetitorTableWrapper(sailingServiceWrite, userService, competitorsRefresher, boatsRefresher, stringMessages, errorReporter, true, true, false, false);
        this.refreshableCompetitorSelectionModel = (RefreshableMultiSelectionModel)this.competitorTable.getSelectionModel();
        this.busyIndicator = new SimpleBusyIndicator(false, 0.8f);
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setWidth("100%");
        this.setWidget((Widget)mainPanel);
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(userService, SecuredDomainType.COMPETITOR);
        mainPanel.add((Widget)buttonPanel);
        Button refreshButton = buttonPanel.addUnsecuredAction(stringMessages.refresh(), () -> competitorsRefresher.reloadAndCallFillAll());
        refreshButton.ensureDebugId("RefreshButton");
        Button allowReloadButton = buttonPanel.addUnsecuredAction(stringMessages.allowReload(), () -> this.competitorTable.allowUpdate((Iterable)this.refreshableCompetitorSelectionModel.getSelectedSet()));
        this.refreshableCompetitorSelectionModel.addSelectionChangeHandler(event -> allowReloadButton.setEnabled(!this.refreshableCompetitorSelectionModel.getSelectedSet().isEmpty()));
        allowReloadButton.setEnabled(!this.refreshableCompetitorSelectionModel.getSelectedSet().isEmpty());
        Button addCompetitorButton = buttonPanel.addCreateAction(stringMessages.add(), () -> this.openAddCompetitorDialog(createWithBoatByDefault));
        addCompetitorButton.ensureDebugId("AddCompetitorButton");
        buttonPanel.addUnsecuredAction(stringMessages.selectAll(), () -> {
            for (CompetitorDTO c : this.competitorTable.getDataProvider().getList()) {
                this.refreshableCompetitorSelectionModel.setSelected((Object)c, true);
            }
        });
        buttonPanel.addCreateAction(stringMessages.importCompetitors(), () -> sailingServiceWrite.getCompetitorProviderNames((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        if (leaderboardName != null) {
            buttonPanel.addCreateAction(stringMessages.inviteSelectedCompetitors(), () -> {
                Set competitors = this.refreshableCompetitorSelectionModel.getSelectedSet();
                CompetitorInvitationHelper helper = new CompetitorInvitationHelper(sailingServiceWrite, stringMessages, errorReporter);
                helper.inviteCompetitors(competitors, leaderboardName);
            });
        }
        mainPanel.add((Widget)this.busyIndicator);
        mainPanel.add((IsWidget)this.competitorTable);
        if (leaderboardName != null) {
            this.refreshCompetitorList();
        }
    }

    public Displayer<CompetitorDTO> getCompetitorsDisplayer() {
        return this.competitorsDisplayer;
    }

    private CompetitorImportProviderSelectionDialog.MatchImportedCompetitorsDialogFactory getMatchCompetitorsDialogFactory(SailingServiceWriteAsync sailingServiceWrite, UserService userService, Refresher<CompetitorDTO> competitorsRefresher, Refresher<BoatDTO> boatsRefresher, StringMessages stringMessages, ErrorReporter errorReporter) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void openAddCompetitorDialog(boolean createWithBoatByDefault) {
        CompetitorWithBoatDTOImpl competitorDTO = new CompetitorWithBoatDTOImpl();
        BoatClassDTO boatClassDTO = new BoatClassDTO(this.boatClassName, null, null);
        BoatDTO boatDTO = new BoatDTO();
        boatDTO.setBoatClass(boatClassDTO);
        competitorDTO.setBoat(boatDTO);
        this.competitorTable.openCompetitorWithBoatAddDialog((CompetitorWithBoatDTO)competitorDTO, createWithBoatByDefault);
    }

    public void refreshCompetitorList() {
        this.competitorTable.refreshCompetitorList(this.leaderboardName);
    }

    public void setBusy(boolean isBusy) {
        if (this.busyIndicator.isBusy() != isBusy) {
            this.busyIndicator.setBusy(isBusy);
        }
    }

    public AbstractFilterablePanel<CompetitorDTO> getFilterablePanel() {
        return this.competitorTable.getFilterField();
    }

    static /* synthetic */ CompetitorTableWrapper access$0(CompetitorPanel competitorPanel) {
        return competitorPanel.competitorTable;
    }

    static /* synthetic */ CompetitorImportProviderSelectionDialog.MatchImportedCompetitorsDialogFactory access$1(CompetitorPanel competitorPanel, SailingServiceWriteAsync sailingServiceWriteAsync, UserService userService, Refresher refresher, Refresher refresher2, StringMessages stringMessages, ErrorReporter errorReporter) {
        return competitorPanel.getMatchCompetitorsDialogFactory(sailingServiceWriteAsync, userService, refresher, refresher2, stringMessages, errorReporter);
    }
}

