/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SingleSelectionModel;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sailing.domain.common.racelog.tracking.MappableToDevice;
import com.sap.sailing.gwt.ui.adminconsole.BoatTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.MarkTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.TrackFileImportDeviceIdentifierTableWrapper;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.DeviceIdentifierDTO;
import com.sap.sailing.gwt.ui.shared.DeviceMappingDTO;
import com.sap.sailing.gwt.ui.shared.MarkDTO;
import com.sap.sailing.gwt.ui.shared.TrackFileImportDeviceIdentifierDTO;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.RefreshableSingleSelectionModel;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.ui.client.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;

/*
 * Exception performing whole class analysis ignored.
 */
public class AbstractRegattaLogFixesAddMappingsDialog
extends DataEntryDialog<Collection<DeviceMappingDTO>> {
    private final String leaderboardName;
    private final StringMessages stringMessages;
    private final SimplePanel importWidgetHolder;
    protected final TrackFileImportDeviceIdentifierTableWrapper deviceIdTable;
    private final CompetitorTableWrapper<RefreshableSingleSelectionModel<CompetitorDTO>> competitorTable;
    private final MarkTableWrapper<RefreshableSingleSelectionModel<MarkDTO>> markTable;
    private final BoatTableWrapper<RefreshableSingleSelectionModel<BoatDTO>> boatTable;
    private TrackFileImportDeviceIdentifierDTO deviceToSelect;
    private CompetitorWithBoatDTO compToSelect;
    private MarkDTO markToSelect;
    private BoatDTO boatToSelect;
    private boolean inInstableTransitionState = false;

    public AbstractRegattaLogFixesAddMappingsDialog(SailingServiceWriteAsync sailingServiceWrite, UserService userService, ErrorReporter errorReporter, StringMessages stringMessages, String leaderboardName, DataEntryDialog.DialogCallback<Collection<DeviceMappingDTO>> callback) {
        super(stringMessages.add(stringMessages.deviceMappings()), stringMessages.add(stringMessages.deviceMappings()), stringMessages.add(), stringMessages.cancel(), (DataEntryDialog.Validator)new /* Unavailable Anonymous Inner Class!! */, true, callback);
        this.leaderboardName = leaderboardName;
        this.stringMessages = stringMessages;
        this.importWidgetHolder = new SimplePanel();
        this.deviceIdTable = new TrackFileImportDeviceIdentifierTableWrapper(sailingServiceWrite, stringMessages, errorReporter);
        this.registerSelectionChangeHandler((SingleSelectionModel)this.deviceIdTable.getSelectionModel(), arg_0 -> this.deviceSelectionChanged(arg_0));
        this.competitorTable = new CompetitorTableWrapper(sailingServiceWrite, userService, null, null, stringMessages, errorReporter, false, true, false, false);
        this.markTable = new MarkTableWrapper(false, sailingServiceWrite, stringMessages, errorReporter);
        this.boatTable = new BoatTableWrapper(sailingServiceWrite, userService, null, null, stringMessages, errorReporter, false, true, false);
        this.registerSelectionChangeHandler((SingleSelectionModel)this.competitorTable.getSelectionModel(), arg_0 -> this.mappedToSelectionChanged(arg_0));
        this.registerSelectionChangeHandler((SingleSelectionModel)this.markTable.getSelectionModel(), arg_0 -> this.mappedToSelectionChanged(arg_0));
        this.registerSelectionChangeHandler((SingleSelectionModel)this.boatTable.getSelectionModel(), arg_0 -> this.mappedToSelectionChanged(arg_0));
        this.getBoatRegistrations((SailingServiceAsync)sailingServiceWrite, errorReporter);
        this.getCompetitorRegistrations((SailingServiceAsync)sailingServiceWrite, errorReporter);
        this.getMarks((SailingServiceAsync)sailingServiceWrite, errorReporter);
    }

    private void getMarks(SailingServiceAsync sailingService, ErrorReporter errorReporter) {
        sailingService.getMarksInRegattaLog(this.leaderboardName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void getBoatRegistrations(SailingServiceAsync sailingService, ErrorReporter errorReporter) {
        sailingService.getBoatRegistrationsForLeaderboard(this.leaderboardName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void getCompetitorRegistrations(SailingServiceAsync sailingService, ErrorReporter errorReporter) {
        sailingService.getCompetitorRegistrationsForLeaderboard(this.leaderboardName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static <T> void selectOrClear(SingleSelectionModel<T> selectionModel, T object) {
        if (object == null) {
            selectionModel.clear();
        } else {
            selectionModel.setSelected(object, true);
        }
    }

    private void select() {
        if (this.inInstableTransitionState) {
            if (((RefreshableSingleSelectionModel)this.deviceIdTable.getSelectionModel()).getSelectedObject() == this.deviceToSelect && ((RefreshableSingleSelectionModel)this.competitorTable.getSelectionModel()).getSelectedObject() == this.compToSelect && ((RefreshableSingleSelectionModel)this.boatTable.getSelectionModel()).getSelectedObject() == this.boatToSelect && ((RefreshableSingleSelectionModel)this.markTable.getSelectionModel()).getSelectedObject() == this.markToSelect) {
                this.inInstableTransitionState = false;
            }
        } else {
            this.inInstableTransitionState = true;
            AbstractRegattaLogFixesAddMappingsDialog.selectOrClear((SingleSelectionModel)((SingleSelectionModel)this.deviceIdTable.getSelectionModel()), (Object)this.deviceToSelect);
            AbstractRegattaLogFixesAddMappingsDialog.selectOrClear((SingleSelectionModel)((SingleSelectionModel)this.competitorTable.getSelectionModel()), (Object)this.compToSelect);
            AbstractRegattaLogFixesAddMappingsDialog.selectOrClear((SingleSelectionModel)((SingleSelectionModel)this.boatTable.getSelectionModel()), (Object)this.boatToSelect);
            AbstractRegattaLogFixesAddMappingsDialog.selectOrClear((SingleSelectionModel)((SingleSelectionModel)this.markTable.getSelectionModel()), (Object)this.markToSelect);
        }
    }

    private <T> void registerSelectionChangeHandler(SingleSelectionModel<T> selectionModel, Consumer<T> callback) {
        selectionModel.addSelectionChangeHandler(event -> callback.accept(selectionModel.getSelectedObject()));
    }

    private void mappedToSelectionChanged(MappableToDevice mappedTo) {
        if (!this.inInstableTransitionState) {
            this.deviceIdTable.setMappedObjectForSelectedDevice(mappedTo);
            if (mappedTo instanceof CompetitorWithBoatDTO) {
                this.compToSelect = (CompetitorWithBoatDTO)mappedTo;
                this.boatToSelect = null;
                this.markToSelect = null;
            } else if (mappedTo instanceof BoatDTO) {
                this.compToSelect = null;
                this.boatToSelect = (BoatDTO)mappedTo;
                this.markToSelect = null;
            } else if (mappedTo instanceof MarkDTO) {
                this.compToSelect = null;
                this.boatToSelect = null;
                this.markToSelect = (MarkDTO)mappedTo;
            }
        }
        this.select();
        this.validateAndUpdate();
    }

    private void deviceSelectionChanged(TrackFileImportDeviceIdentifierDTO deviceId) {
        if (!this.inInstableTransitionState) {
            this.deviceToSelect = deviceId;
            this.compToSelect = null;
            this.boatToSelect = null;
            this.markToSelect = null;
            if (deviceId != null) {
                MappableToDevice mappedTo = this.deviceIdTable.getMappedObjectForDeviceId(deviceId);
                if (mappedTo instanceof CompetitorWithBoatDTO) {
                    this.compToSelect = (CompetitorWithBoatDTO)mappedTo;
                } else if (mappedTo instanceof BoatDTO) {
                    this.boatToSelect = (BoatDTO)mappedTo;
                } else if (mappedTo instanceof MarkDTO) {
                    this.markToSelect = (MarkDTO)mappedTo;
                }
            }
        }
        this.select();
    }

    protected Widget getAdditionalWidget() {
        HorizontalPanel panel = new HorizontalPanel();
        VerticalPanel leftPanel = new VerticalPanel();
        VerticalPanel tablesPanel = new VerticalPanel();
        CaptionPanel marksPanel = new CaptionPanel(this.stringMessages.mark());
        CaptionPanel boatsPanel = new CaptionPanel(this.stringMessages.boat());
        CaptionPanel competitorsPanel = new CaptionPanel(this.stringMessages.competitor());
        leftPanel.add((Widget)this.importWidgetHolder);
        leftPanel.add((IsWidget)this.deviceIdTable);
        panel.add((Widget)leftPanel);
        panel.add((Widget)tablesPanel);
        tablesPanel.add((Widget)marksPanel);
        tablesPanel.add((Widget)boatsPanel);
        tablesPanel.add((Widget)competitorsPanel);
        marksPanel.setContentWidget(this.markTable.asWidget());
        boatsPanel.setContentWidget(this.boatTable.asWidget());
        competitorsPanel.setContentWidget(this.competitorTable.asWidget());
        return panel;
    }

    protected Collection<DeviceMappingDTO> getResult() {
        ArrayList<DeviceMappingDTO> result = new ArrayList<DeviceMappingDTO>();
        for (Map.Entry deviceEntry : this.deviceIdTable.getMappings().entrySet()) {
            TrackFileImportDeviceIdentifierDTO device = (TrackFileImportDeviceIdentifierDTO)deviceEntry.getKey();
            DeviceIdentifierDTO deviceIdDto = new DeviceIdentifierDTO("FILE", device.uuidAsString);
            MappableToDevice mappedTo = (MappableToDevice)deviceEntry.getValue();
            DeviceMappingDTO mapping = new DeviceMappingDTO(deviceIdDto, device.from, device.to, mappedTo, null);
            result.add(mapping);
        }
        return result;
    }

    protected void setImportWidget(Widget importWidget) {
        this.importWidgetHolder.setWidget(importWidget);
    }

    static /* synthetic */ MarkTableWrapper access$1(AbstractRegattaLogFixesAddMappingsDialog abstractRegattaLogFixesAddMappingsDialog) {
        return abstractRegattaLogFixesAddMappingsDialog.markTable;
    }

    static /* synthetic */ BoatTableWrapper access$2(AbstractRegattaLogFixesAddMappingsDialog abstractRegattaLogFixesAddMappingsDialog) {
        return abstractRegattaLogFixesAddMappingsDialog.boatTable;
    }

    static /* synthetic */ CompetitorTableWrapper access$3(AbstractRegattaLogFixesAddMappingsDialog abstractRegattaLogFixesAddMappingsDialog) {
        return abstractRegattaLogFixesAddMappingsDialog.competitorTable;
    }
}

