/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.settings.client.regattaoverview;

import com.sap.sailing.domain.common.dto.CourseAreaDTO;
import com.sap.sailing.gwt.ui.shared.RaceGroupDTO;
import com.sap.sse.common.settings.generic.AbstractGenericSerializableSettings;
import com.sap.sse.common.settings.generic.BooleanSetting;
import com.sap.sse.common.settings.generic.StringSetSetting;
import com.sap.sse.common.settings.generic.UUIDSetSetting;
import java.util.Collections;
import java.util.HashSet;
import java.util.UUID;

public final class RegattaRaceStatesSettings
extends AbstractGenericSerializableSettings {
    private static final long serialVersionUID = 7059340304556830062L;
    private transient UUIDSetSetting visibleCourseAreas;
    private transient StringSetSetting visibleRegattas;
    private transient BooleanSetting showOnlyRacesOfSameDay;
    private transient BooleanSetting showOnlyCurrentlyRunningRaces;

    public RegattaRaceStatesSettings() {
    }

    public RegattaRaceStatesSettings(Iterable<CourseAreaDTO> defaultCourseAreas, Iterable<RaceGroupDTO> defaultRaceGroups) {
        this();
        this.setDefaultCourseAreas(defaultCourseAreas);
        this.setDefaultRegattas(defaultRaceGroups);
    }

    public RegattaRaceStatesSettings(Iterable<CourseAreaDTO> defaultCourseAreas, Iterable<UUID> visibleCourseAreas, Iterable<RaceGroupDTO> defaultRaceGroups, Iterable<String> visibleRegattas, boolean showOnlyRacesOfSameDay, boolean showOnlyCurrentlyRunningRaces) {
        this(defaultCourseAreas, defaultRaceGroups);
        this.visibleCourseAreas.setValues(visibleCourseAreas);
        this.visibleRegattas.setValues(visibleRegattas);
        this.showOnlyRacesOfSameDay.setValue((Object)showOnlyRacesOfSameDay);
        this.showOnlyCurrentlyRunningRaces.setValue((Object)showOnlyCurrentlyRunningRaces);
    }

    protected void addChildSettings() {
        this.visibleCourseAreas = new UUIDSetSetting("visibleCourseAreas", (AbstractGenericSerializableSettings)this, true);
        this.visibleRegattas = new StringSetSetting("visibleRegattas", (AbstractGenericSerializableSettings)this, true);
        this.showOnlyRacesOfSameDay = new BooleanSetting("showOnlyRacesOfSameDay", (AbstractGenericSerializableSettings)this, Boolean.valueOf(false));
        this.showOnlyCurrentlyRunningRaces = new BooleanSetting("showOnlyCurrentlyRunningRaces", (AbstractGenericSerializableSettings)this, Boolean.valueOf(true));
    }

    public Iterable<UUID> getVisibleCourseAreas() {
        return this.visibleCourseAreas.getValues();
    }

    public void setVisibleCourseAreas(Iterable<UUID> visibleCourseAreas) {
        this.visibleCourseAreas.setValues(visibleCourseAreas);
    }

    public UUIDSetSetting getVisibleCourseAreaSettings() {
        return this.visibleCourseAreas;
    }

    public Iterable<String> getVisibleRegattas() {
        return this.visibleRegattas.getValues();
    }

    public void setVisibleRegattas(Iterable<String> visibleRegattas) {
        this.visibleRegattas.setValues(visibleRegattas);
    }

    public StringSetSetting getVisibleRegattaSettings() {
        return this.visibleRegattas;
    }

    public boolean isShowOnlyRacesOfSameDay() {
        return (Boolean)this.showOnlyRacesOfSameDay.getValue();
    }

    public void setShowOnlyRaceOfSameDay(boolean newValue) {
        this.showOnlyRacesOfSameDay.setValue((Object)newValue);
    }

    public boolean isShowOnlyCurrentlyRunningRaces() {
        return (Boolean)this.showOnlyCurrentlyRunningRaces.getValue();
    }

    public void setShowOnlyCurrentlyRunningRaces(boolean newValue) {
        this.showOnlyCurrentlyRunningRaces.setValue((Object)newValue);
    }

    public void setDefaultCourseAreas(Iterable<CourseAreaDTO> defaultCourseAreas) {
        if (defaultCourseAreas == null) {
            defaultCourseAreas = Collections.emptySet();
        }
        HashSet<UUID> courseAreaIds = new HashSet<UUID>();
        for (CourseAreaDTO courseArea : defaultCourseAreas) {
            courseAreaIds.add(courseArea.getId());
        }
        this.visibleCourseAreas.setDefaultValues(courseAreaIds);
    }

    public void setDefaultRegattas(Iterable<RaceGroupDTO> defaultRaceGroups) {
        if (defaultRaceGroups == null) {
            defaultRaceGroups = Collections.emptySet();
        }
        HashSet<String> regattaIds = new HashSet<String>();
        for (RaceGroupDTO raceGroup : defaultRaceGroups) {
            regattaIds.add(raceGroup.getName());
        }
        this.visibleRegattas.setDefaultValues(regattaIds);
    }

    public RegattaRaceStatesSettings createInstanceWithSettings(Iterable<UUID> visibleCourseAreas, Iterable<String> visibleRegattas, boolean showOnlyRacesOfSameDay, boolean showOnlyCurrentlyRunningRaces) {
        RegattaRaceStatesSettings newSettings = new RegattaRaceStatesSettings(null, visibleCourseAreas, null, visibleRegattas, showOnlyRacesOfSameDay, showOnlyCurrentlyRunningRaces);
        newSettings.visibleCourseAreas.setDefaultValues(this.visibleCourseAreas.getDefaultValues());
        newSettings.visibleRegattas.setDefaultValues(this.visibleRegattas.getDefaultValues());
        return newSettings;
    }
}

