/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.places.fakeseries;

import com.google.gwt.core.client.GWT;
import com.sap.sailing.gwt.home.desktop.places.fakeseries.EventSeriesAnalyticsDataManager;
import com.sap.sailing.gwt.home.shared.places.ShareablePlaceContext;
import java.util.UUID;

public class SeriesContext
implements ShareablePlaceContext {
    private final UUID seriesId;
    private UUID leaderboardGroupId;
    private EventSeriesAnalyticsDataManager analyticsManager;

    public static final SeriesContext createWithSeriesId(UUID seriesId) {
        return new SeriesContext(seriesId, null);
    }

    public static final SeriesContext createWithLeaderboardGroupId(UUID leaderboardGroupId) {
        return new SeriesContext(null, leaderboardGroupId);
    }

    public static final SeriesContext createErrorContext() {
        return new SeriesContext(null, null);
    }

    private SeriesContext(UUID seriesId, UUID leaderboardGroupId) {
        this.seriesId = seriesId;
        this.leaderboardGroupId = leaderboardGroupId;
    }

    public SeriesContext(SeriesContext ctx) {
        this.seriesId = ctx.seriesId;
        this.leaderboardGroupId = ctx.leaderboardGroupId;
        this.withAnalyticsManager(ctx.analyticsManager);
    }

    public UUID getLeaderboardGroupId() {
        return this.leaderboardGroupId;
    }

    public UUID getSeriesId() {
        if (this.leaderboardGroupId != null) {
            GWT.log((String)("Access to seriesid! Use leaderboardgroupid instead seriesId:" + this.seriesId + "; lid: " + this.leaderboardGroupId));
        }
        return this.seriesId;
    }

    public EventSeriesAnalyticsDataManager getAnalyticsManager() {
        return this.analyticsManager;
    }

    public SeriesContext withAnalyticsManager(EventSeriesAnalyticsDataManager regattaAnalyticsManager) {
        this.analyticsManager = regattaAnalyticsManager;
        return this;
    }

    public void updateLeaderboardGroupId(UUID leaderboardGroupUUID) {
        this.leaderboardGroupId = leaderboardGroupUUID;
    }

    public String getContextAsPathParameters() {
        if (this.leaderboardGroupId != null) {
            return "/series/" + this.leaderboardGroupId;
        }
        return null;
    }
}

