/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.partials.updatesBox;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.event.news.NewsEntryDTO;
import com.sap.sailing.gwt.home.mobile.partials.section.MobileSection;
import com.sap.sailing.gwt.home.mobile.partials.sectionHeader.SectionHeaderContent;
import com.sap.sailing.gwt.home.mobile.partials.updatesBox.NewsItemLinkProvider;
import com.sap.sailing.gwt.home.mobile.partials.updatesBox.UpdatesBox;
import com.sap.sailing.gwt.home.mobile.partials.updatesBox.UpdatesBoxItem;
import com.sap.sailing.gwt.home.mobile.partials.updatesBox.UpdatesBoxResources;
import com.sap.sailing.gwt.home.shared.refresh.RefreshManager;
import com.sap.sailing.gwt.home.shared.refresh.RefreshableWidget;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.dispatch.shared.commands.ListResult;
import java.util.List;

public class UpdatesBox
extends Composite
implements RefreshableWidget<ListResult<NewsEntryDTO>> {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    MobileSection itemContainerUi;
    @UiField
    SectionHeaderContent headerUi;
    private boolean dontDrillDown = false;
    private boolean dontHide = false;
    private NewsItemLinkProvider presenter;
    private final RefreshManager refreshManager;

    public UpdatesBox(NewsItemLinkProvider presenter, RefreshManager refreshManager) {
        this.presenter = presenter;
        this.refreshManager = refreshManager;
        UpdatesBoxResources.INSTANCE.css().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        if (!this.dontHide) {
            this.getElement().getStyle().setDisplay(Style.Display.NONE);
        }
    }

    public void setData(ListResult<NewsEntryDTO> data) {
        this.setData(data == null ? null : data.getValues());
    }

    public void setData(List<NewsEntryDTO> data) {
        int nrOfNews = data == null ? 0 : data.size();
        GWT.log((String)("Nr of news items: " + nrOfNews));
        this.itemContainerUi.clearContent();
        if (nrOfNews == 0) {
            if (!this.dontHide) {
                this.getElement().getStyle().setDisplay(Style.Display.NONE);
            } else {
                this.itemContainerUi.addContent(this.getNoNewsInfoWidget());
            }
        } else {
            this.getElement().getStyle().clearDisplay();
            for (NewsEntryDTO newsEntryDTO : data) {
                this.itemContainerUi.addContent((Widget)new UpdatesBoxItem(newsEntryDTO, this.refreshManager.getDispatchSystem().getCurrentServerTime(), this.presenter));
            }
            if (!this.dontDrillDown) {
                this.headerUi.setClickAction(this.presenter.getNewsPlaceNavigation(data));
            }
        }
    }

    private Widget getNoNewsInfoWidget() {
        Label label = new Label(StringMessages.INSTANCE.noNews());
        label.getElement().getStyle().setPadding(1.0, Style.Unit.EM);
        label.getElement().getStyle().setFontWeight(Style.FontWeight.BOLD);
        label.getElement().getStyle().setFontStyle(Style.FontStyle.ITALIC);
        return label;
    }

    public void setDontDrillDown(boolean dontDrillDown) {
        this.dontDrillDown = dontDrillDown;
    }

    public void setDontHide(boolean dontHide) {
        this.dontHide = dontHide;
        this.getElement().getStyle().clearDisplay();
    }
}

