/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.event;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.base.LeaderboardGroupBase;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.gwt.common.client.EventWindFinderUtil;
import com.sap.sailing.gwt.home.communication.SailingAction;
import com.sap.sailing.gwt.home.communication.SailingDispatchContext;
import com.sap.sailing.gwt.home.communication.event.EventMetadataDTO;
import com.sap.sailing.gwt.home.communication.eventview.EventViewDTO;
import com.sap.sailing.gwt.home.communication.eventview.SeriesReferenceWithEventsDTO;
import com.sap.sailing.gwt.home.server.EventActionUtil;
import com.sap.sailing.gwt.server.HomeServiceUtil;
import com.sap.sailing.gwt.ui.shared.TrackingConnectorInfoDTO;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.media.MediaTagConstants;
import com.sap.sse.gwt.dispatch.shared.caching.IsClientCacheable;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.server.SecurityDTOUtil;
import com.sap.sse.shared.media.ImageDescriptor;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class GetEventViewAction
implements SailingAction<EventViewDTO>,
IsClientCacheable {
    private static final Logger logger = Logger.getLogger(GetEventViewAction.class.getName());
    private UUID eventId;

    private GetEventViewAction() {
    }

    public GetEventViewAction(UUID eventId) {
        this.eventId = eventId;
    }

    @GwtIncompatible
    public EventViewDTO execute(SailingDispatchContext context) {
        LeaderboardGroup singleLeaderboardGroup;
        Event event = context.getRacingEventService().getEvent((Serializable)this.eventId);
        if (event == null) {
            throw new RuntimeException("Event not found");
        }
        context.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)event);
        EventViewDTO dto = new EventViewDTO();
        HomeServiceUtil.mapToMetadataDTO((EventBase)event, (EventMetadataDTO)dto);
        ImageDescriptor logoImage = event.findImageWithTag(MediaTagConstants.LOGO.getName());
        dto.setLogoImage(logoImage != null ? HomeServiceUtil.convertToImageDTO((ImageDescriptor)logoImage) : null);
        dto.setOfficialWebsiteURL(event.getOfficialWebsiteURL() == null ? null : event.getOfficialWebsiteURL().toString());
        URL sailorsInfoWebsiteURL = event.getSailorsInfoWebsiteURLOrFallback(context.getClientLocale());
        dto.setSailorsInfoWebsiteURL(sailorsInfoWebsiteURL == null ? null : sailorsInfoWebsiteURL.toString());
        if (context.getWindFinderTrackerFactory() != null) {
            dto.setAllWindFinderSpotsUsedByEvent(new EventWindFinderUtil().getWindFinderSpotsToConsider(event, context.getWindFinderTrackerFactory(), true));
        }
        dto.setHasMedia(HomeServiceUtil.hasMedia((Event)event));
        dto.setState(HomeServiceUtil.calculateEventState((EventBase)event));
        dto.setName(event.getName());
        dto.setHasAnalytics(true);
        String description = event.getDescription();
        if (description == null || description.trim().isEmpty() || event.getName().equalsIgnoreCase(description)) {
            description = null;
        }
        dto.setDescription(description);
        HashSet regattasOfEvent = new HashSet();
        HashSet relevantLeaderboardGroupsOfEvent = new HashSet();
        EventActionUtil.forLeaderboardsOfEventWithReadPermissions((SailingDispatchContext)context, (Event)event, (EventActionUtil.LeaderboardCallback)new /* Unavailable Anonymous Inner Class!! */);
        dto.setMultiRegatta(regattasOfEvent.size() != 1);
        if (relevantLeaderboardGroupsOfEvent.size() == 1 && (singleLeaderboardGroup = (LeaderboardGroup)relevantLeaderboardGroupsOfEvent.iterator().next()).hasOverallLeaderboard()) {
            List eventAndLeaderboardReferencesForSeriesOrdered = HomeServiceUtil.getEventAndLeaderboardReferencesForSeriesOrdered((LeaderboardGroup)singleLeaderboardGroup, (RacingEventService)context.getRacingEventService());
            Collections.reverse(eventAndLeaderboardReferencesForSeriesOrdered);
            dto.setSeriesData(new SeriesReferenceWithEventsDTO(HomeServiceUtil.getLeaderboardDisplayName((LeaderboardGroupBase)singleLeaderboardGroup), singleLeaderboardGroup.getId(), (Collection)eventAndLeaderboardReferencesForSeriesOrdered));
        }
        Set trackingConnectorInfos = event.getTrackingConnectorInfos().stream().map(TrackingConnectorInfoDTO::new).collect(Collectors.toSet());
        dto.setTrackingConnectorInfos(trackingConnectorInfos);
        SecurityDTOUtil.addSecurityInformation((SecurityService)context.getSecurityService(), (SecuredDTO)dto);
        return dto;
    }

    public void cacheInstanceKey(StringBuilder key) {
        key.append(this.eventId);
    }

    static /* synthetic */ Logger access$2() {
        return logger;
    }
}

