/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.common.client;

import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceTokenizer;
import com.sap.sse.common.Util;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public abstract class AbstractMapTokenizer<P extends Place>
implements PlaceTokenizer<P> {
    private static final Logger logger = Logger.getLogger(AbstractMapTokenizer.class.getName());

    public P getPlace(String token) {
        return (P)this.getPlaceFromParameters(this.toParameterMap(token));
    }

    protected abstract P getPlaceFromParameters(Map<String, Set<String>> var1);

    protected abstract Map<String, Set<String>> getParameters(P var1);

    public String getToken(P place) {
        return this.toToken(this.getParameters(place));
    }

    private String toToken(Map<String, Set<String>> parameters) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Set<String>> entry : parameters.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            for (String val : entry.getValue()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("&");
                }
                stringBuilder.append(String.valueOf(entry.getKey()) + "=" + val);
            }
        }
        return stringBuilder.toString();
    }

    private Map<String, Set<String>> toParameterMap(String placeParametersAsToken) {
        Map<String, Set<String>> result;
        List<String> list = Arrays.asList(placeParametersAsToken.split("&"));
        if (list == null || list.size() < 1) {
            logger.warning("Token empty, no-op");
            result = Collections.emptyMap();
        } else {
            result = new HashMap();
            for (String listItem : list) {
                String value;
                String key;
                int indexOfEquals = listItem.indexOf(61);
                if (indexOfEquals < 0) {
                    key = listItem;
                    value = null;
                } else {
                    key = listItem.substring(0, indexOfEquals);
                    value = listItem.substring(indexOfEquals + 1);
                }
                Util.addToValueSet(result, (Object)key, value);
            }
        }
        return result;
    }
}

