/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.app;

import com.google.gwt.core.client.GWT;
import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceController;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.web.bindery.event.shared.EventBus;
import com.sap.sailing.gwt.autoplay.client.app.ApplicationTopLevelView;
import com.sap.sailing.gwt.autoplay.client.app.AutoPlayClientFactory;
import com.sap.sailing.gwt.autoplay.client.app.AutoPlayPlaceNavigator;
import com.sap.sailing.gwt.autoplay.client.places.autoplaystart.AutoPlayStartPlace;
import com.sap.sailing.gwt.common.communication.routing.ProvidesLeaderboardRouting;
import com.sap.sailing.gwt.ui.client.MediaService;
import com.sap.sailing.gwt.ui.client.MediaServiceAsync;
import com.sap.sailing.gwt.ui.client.MediaServiceWrite;
import com.sap.sailing.gwt.ui.client.MediaServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceHelper;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sse.common.HttpRequestHeaderConstants;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.EntryPointHelper;
import com.sap.sse.gwt.client.ServiceRoutingProvider;
import com.sap.sse.gwt.client.mvp.TopLevelView;
import com.sap.sse.security.ui.client.SecureClientFactoryImpl;
import java.util.HashMap;
import java.util.Map;

public abstract class AutoPlayClientFactoryBase
extends SecureClientFactoryImpl<ApplicationTopLevelView>
implements AutoPlayClientFactory {
    private final SailingServiceAsync sailingService;
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final MediaServiceAsync mediaService;
    private final MediaServiceWriteAsync mediaServiceWrite;
    private final AutoPlayPlaceNavigator navigator;
    private final Map<String, SailingServiceAsync> services = new HashMap();

    public AutoPlayClientFactoryBase(ApplicationTopLevelView root, EventBus eventBus, PlaceController placeController, AutoPlayPlaceNavigator navigator) {
        super((TopLevelView)root, eventBus, placeController);
        this.navigator = navigator;
        this.sailingService = SailingServiceHelper.createSailingServiceInstance();
        this.sailingServiceWrite = SailingServiceHelper.createSailingServiceWriteInstance();
        this.mediaService = (MediaServiceAsync)GWT.create(MediaService.class);
        this.mediaServiceWrite = (MediaServiceWriteAsync)GWT.create(MediaServiceWrite.class);
        EntryPointHelper.registerASyncService((ServiceDefTarget)((ServiceDefTarget)this.sailingService), (String)"service/sailing");
        EntryPointHelper.registerASyncService((ServiceDefTarget)((ServiceDefTarget)this.mediaService), (String)"service/media", (Util.Pair[])new Util.Pair[]{HttpRequestHeaderConstants.HEADER_FORWARD_TO_REPLICA});
        EntryPointHelper.registerASyncService((ServiceDefTarget)((ServiceDefTarget)this.mediaServiceWrite), (String)"service/media", (Util.Pair[])new Util.Pair[]{HttpRequestHeaderConstants.HEADER_FORWARD_TO_MASTER});
    }

    public Place getDefaultPlace() {
        return new AutoPlayStartPlace();
    }

    public SailingServiceAsync getSailingService() {
        if (this.isConfigured()) {
            return this.getSailingService(() -> this.getAutoPlayCtxSignalError().getContextDefinition().getLeaderboardName());
        }
        return this.sailingService;
    }

    public SailingServiceAsync getSailingService(ProvidesLeaderboardRouting routingProvider) {
        if (routingProvider == null) {
            return this.sailingService;
        }
        SailingServiceAsync sailingServiceAsync = (SailingServiceAsync)this.services.get(routingProvider.routingSuffixPath());
        if (sailingServiceAsync == null) {
            sailingServiceAsync = SailingServiceHelper.createSailingServiceInstance((ServiceRoutingProvider)routingProvider);
            this.services.put(routingProvider.routingSuffixPath(), sailingServiceAsync);
        }
        return sailingServiceAsync;
    }

    public SailingServiceWriteAsync getSailingServiceWrite() {
        return this.sailingServiceWrite;
    }

    public MediaServiceAsync getMediaService() {
        return this.mediaService;
    }

    public MediaServiceWriteAsync getMediaServiceWrite() {
        return this.mediaServiceWrite;
    }

    public AutoPlayPlaceNavigator getPlaceNavigator() {
        return this.navigator;
    }
}

