/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components.management;

import com.sap.sse.datamining.Query;
import com.sap.sse.datamining.components.management.DataMiningQueryManager;
import com.sap.sse.datamining.data.QueryResult;
import com.sap.sse.datamining.shared.DataMiningSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class StrategyPerQueryTypeManager
implements DataMiningQueryManager {
    private final Map<Query.QueryType, DataMiningQueryManager> managersMappedByQueryType = new HashMap<Query.QueryType, DataMiningQueryManager>();
    private final AtomicInteger runningQueryCounter;

    public StrategyPerQueryTypeManager() {
        this.managersMappedByQueryType.put(Query.QueryType.OTHER, NULL);
        this.managersMappedByQueryType.put(Query.QueryType.STATISTIC, NULL);
        this.managersMappedByQueryType.put(Query.QueryType.DIMENSION_VALUES, NULL);
        this.runningQueryCounter = new AtomicInteger();
    }

    @Override
    public <ResultType> QueryResult<ResultType> runNewAndAbortPrevious(DataMiningSession session, Query<ResultType> query) {
        this.runningQueryCounter.incrementAndGet();
        QueryResult<ResultType> result = this.managersMappedByQueryType.get((Object)query.getAdditionalData().getType()).runNewAndAbortPrevious(session, query);
        this.runningQueryCounter.decrementAndGet();
        return result;
    }

    @Override
    public void abortRandomQuery() {
        Random generator = new Random();
        ArrayList queryTypes = new ArrayList(Query.QueryType.values().length);
        Collections.addAll(queryTypes, Query.QueryType.values());
        boolean abortedQuery = false;
        while (!abortedQuery) {
            Query.QueryType randomQueryType = (Query.QueryType)((Object)queryTypes.remove(generator.nextInt(queryTypes.size())));
            if (this.getNumberOfRunningQueriesOfType(randomQueryType) <= 0) continue;
            this.abortRandomQueryOfType(randomQueryType);
            abortedQuery = true;
        }
    }

    public void abortRandomQueryOfType(Query.QueryType queryType) {
        this.managersMappedByQueryType.get((Object)queryType).abortRandomQuery();
    }

    @Override
    public void abortAllQueries() {
        for (DataMiningQueryManager manager : this.managersMappedByQueryType.values()) {
            manager.abortAllQueries();
        }
    }

    @Override
    public int getNumberOfRunningQueries() {
        return this.runningQueryCounter.get();
    }

    public int getNumberOfRunningQueriesOfType(Query.QueryType queryType) {
        return this.managersMappedByQueryType.get((Object)queryType).getNumberOfRunningQueries();
    }
}

