/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.common.BoatClassMasterdata;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.RadianBearingImpl;
import com.sap.sailing.simulator.BoatDirection;
import com.sap.sailing.simulator.PointOfSail;
import com.sap.sailing.simulator.PolarDiagram;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class PolarDiagramBase
implements PolarDiagram,
Serializable {
    private static final long serialVersionUID = 7465253094290674423L;
    protected BoatClass boatClass;
    protected SpeedWithBearing windprev = new KnotSpeedWithBearingImpl(6.0, (Bearing)new DegreeBearingImpl(180.0));
    protected SpeedWithBearing wind = new KnotSpeedWithBearingImpl(6.0, (Bearing)new DegreeBearingImpl(180.0));
    protected SpeedWithBearing trueWind = new KnotSpeedWithBearingImpl(6.0, (Bearing)new DegreeBearingImpl(180.0));
    protected SpeedWithBearing current = null;
    protected Bearing targetDirection = new DegreeBearingImpl(0.0);
    protected NavigableMap<Speed, NavigableMap<Bearing, Speed>> speedTable;
    protected NavigableMap<Double, Object> extTable = null;
    protected NavigableMap<Speed, Bearing> beatAngles;
    protected NavigableMap<Speed, Bearing> jibeAngles;
    protected NavigableMap<Speed, Speed> beatSOG;
    protected NavigableMap<Speed, Speed> jibeSOG;
    protected double scaleBearing = 1.0;
    protected double scaleSpeed = 1.0;
    public static Comparator<Bearing> bearingComparator = new Comparator<Bearing>(){

        @Override
        public int compare(Bearing o1, Bearing o2) {
            double d2;
            double d1 = o1.getDegrees();
            if (d1 < 0.0) {
                d1 += 360.0;
            }
            if ((d2 = o2.getDegrees()) < 0.0) {
                d2 += 360.0;
            }
            return d1 < d2 ? -1 : (d1 == d2 ? 0 : 1);
        }
    };

    @Override
    public void setSpeedScale(double scaleSpeed) {
        this.scaleSpeed = scaleSpeed;
    }

    @Override
    public double getSpeedScale() {
        return this.scaleSpeed;
    }

    @Override
    public void setBearingScale(double scaleBearing) {
        this.scaleBearing = scaleBearing;
    }

    @Override
    public double getBearingScale() {
        return this.scaleBearing;
    }

    @Override
    public NavigableMap<Speed, NavigableMap<Bearing, Speed>> getSpeedTable() {
        return this.speedTable;
    }

    @Override
    public NavigableMap<Speed, Bearing> getBeatAngles() {
        return this.beatAngles;
    }

    @Override
    public NavigableMap<Speed, Bearing> getJibeAngles() {
        return this.jibeAngles;
    }

    @Override
    public NavigableMap<Speed, Speed> getBeatSOG() {
        return this.beatSOG;
    }

    @Override
    public NavigableMap<Speed, Speed> getJibeSOG() {
        return this.jibeSOG;
    }

    public PolarDiagramBase() {
    }

    public PolarDiagramBase(PolarDiagramBase pd) {
        this.boatClass = pd.boatClass;
        this.speedTable = pd.speedTable;
        this.beatAngles = pd.beatAngles;
        this.beatSOG = pd.beatSOG;
        this.jibeAngles = pd.jibeAngles;
        this.jibeSOG = pd.jibeSOG;
        this.current = pd.current;
        this.extTable = pd.extTable;
    }

    public PolarDiagramBase(NavigableMap<Speed, NavigableMap<Bearing, Speed>> speeds, NavigableMap<Speed, Bearing> beats, NavigableMap<Speed, Bearing> jibes, NavigableMap<Speed, Speed> beatSOGs, NavigableMap<Speed, Speed> jibeSOGs) {
        this.wind = new KnotSpeedWithBearingImpl(0.0, (Bearing)new DegreeBearingImpl(180.0));
        this.boatClass = null;
        this.speedTable = speeds;
        this.beatAngles = beats;
        this.jibeAngles = jibes;
        this.beatSOG = beatSOGs;
        this.jibeSOG = jibeSOGs;
        for (Speed s : this.speedTable.keySet()) {
            if (this.beatAngles.containsKey(s) && !((NavigableMap)this.speedTable.get(s)).containsKey(this.beatAngles.get(s))) {
                ((NavigableMap)this.speedTable.get(s)).put((Bearing)this.beatAngles.get(s), (Speed)this.beatSOG.get(s));
            }
            if (!this.jibeAngles.containsKey(s) || ((NavigableMap)this.speedTable.get(s)).containsKey(this.jibeAngles.get(s))) continue;
            ((NavigableMap)this.speedTable.get(s)).put((Bearing)this.jibeAngles.get(s), (Speed)this.jibeSOG.get(s));
        }
    }

    @Override
    public SpeedWithBearing getWind() {
        return this.wind;
    }

    @Override
    public void setWind(SpeedWithBearing newWind) {
        if (this.windprev.getKnots() != newWind.getKnots() || this.windprev.getBearing().getDegrees() != newWind.getBearing().getDegrees()) {
            this.windprev = newWind;
            if (this.current == null || this.current.getKnots() == 0.0) {
                this.wind = newWind;
                this.trueWind = newWind;
            } else {
                this.wind = this.getApparentWindFromCurrent(newWind);
                this.trueWind = newWind;
            }
        }
    }

    public NavigableMap<Double, Object> extendSpeedMap() {
        TreeMap<Double, Object> extMap = new TreeMap<Double, Object>();
        for (Map.Entry windSpeedEntry : this.speedTable.entrySet()) {
            double windSpeed = ((Speed)windSpeedEntry.getKey()).getKnots();
            if (windSpeed == 0.0) continue;
            TreeMap wcurSpeedMap = new TreeMap();
            double wcurSpeed = 0.0;
            while (wcurSpeed <= 2.2) {
                TreeMap wcurBearMap = new TreeMap();
                double wcurBear = 0.0;
                while (wcurBear < 360.0) {
                    double tmpBear;
                    KnotSpeedWithBearingImpl trueWind = new KnotSpeedWithBearingImpl(windSpeed, (Bearing)new DegreeBearingImpl(180.0));
                    this.setCurrent((SpeedWithBearing)new KnotSpeedWithBearingImpl(wcurSpeed, (Bearing)new DegreeBearingImpl(wcurBear)));
                    this.wind = this.getApparentWindFromCurrent((SpeedWithBearing)trueWind);
                    TreeMap<Double, Double> boatBearMap = new TreeMap<Double, Double>();
                    Bearing[] optBear = this.optimalDirectionsUpwind();
                    boolean stepSize = true;
                    double minBear = optBear[1].getDegrees() - optBear[1].getDegrees() % (double)stepSize;
                    double maxBear = optBear[0].getDegrees() + ((double)stepSize - optBear[0].getDegrees() % (double)stepSize);
                    Double minBearSOG = null;
                    Double maxBearSOG = null;
                    double boatBearSMF = minBear;
                    while (boatBearSMF <= maxBear) {
                        KnotSpeedWithBearingImpl rotSpeed = new KnotSpeedWithBearingImpl(this.getSpeedAtBearingRaw((Bearing)new DegreeBearingImpl(boatBearSMF)).getKnots(), (Bearing)new DegreeBearingImpl(boatBearSMF));
                        SpeedWithBearing transSpeed = this.getSOGfromSMF((SpeedWithBearing)rotSpeed);
                        double boatBearSOG = transSpeed.getBearing().getDegrees();
                        double boatSpeedSOG = transSpeed.getKnots();
                        boatBearMap.put(boatBearSOG, boatSpeedSOG);
                        if (boatBearSMF == minBear) {
                            minBearSOG = boatBearSOG;
                        }
                        if (boatBearSMF == maxBear) {
                            maxBearSOG = boatBearSOG;
                        }
                        boatBearSMF += (double)stepSize;
                    }
                    if (minBearSOG != null) {
                        tmpBear = Math.floor(minBearSOG) - 1.0;
                        while (tmpBear >= 0.0) {
                            boatBearMap.put(tmpBear, 0.0);
                            tmpBear -= 1.0;
                        }
                    }
                    if (maxBearSOG != null) {
                        tmpBear = Math.ceil(maxBearSOG) + 1.0;
                        while (tmpBear <= 360.0) {
                            boatBearMap.put(tmpBear, 0.0);
                            tmpBear += 1.0;
                        }
                    }
                    wcurBearMap.put(wcurBear, boatBearMap);
                    wcurBear += 10.0;
                }
                wcurSpeedMap.put(wcurSpeed, wcurBearMap);
                wcurSpeed += 0.2;
            }
            extMap.put(windSpeed, wcurSpeedMap);
        }
        return extMap;
    }

    public double interpolate(double[] values, int level, NavigableMap<Double, Object> map) {
        NavigableMap tmp;
        double crValue = values[level];
        Double hiDouble = map.ceilingKey(crValue);
        if ((level == 2 || level == 3) && hiDouble == null) {
            hiDouble = map.ceilingKey(crValue - 360.0);
        }
        double hiValue = hiDouble == null ? 0.0 : hiDouble;
        double hiResult = 0.0;
        if (level < values.length - 1) {
            tmp = (NavigableMap)map.get(hiValue);
            hiResult = this.interpolate(values, level + 1, tmp);
        } else {
            hiResult = (Double)map.get(hiValue);
        }
        Double loDouble = map.floorKey(crValue);
        if (level == 3 && loDouble == null) {
            loDouble = map.floorKey(crValue + 360.0);
        }
        double loValue = loDouble;
        double loResult = 0.0;
        if (level < values.length - 1) {
            tmp = (NavigableMap)map.get(loValue);
            loResult = this.interpolate(values, level + 1, tmp);
        } else {
            loResult = (Double)map.get(loValue);
        }
        double interpolatedValue = hiValue == loValue ? loResult : loResult + (hiResult - loResult) * (crValue - loValue) / (hiValue - loValue);
        return interpolatedValue;
    }

    @Override
    public void initializeSOGwithCurrent() {
        this.setCurrent(null);
    }

    @Override
    public void setCurrent(SpeedWithBearing newCurrent) {
        if (newCurrent == null && this.extTable == null) {
            this.extTable = this.extendSpeedMap();
        }
        this.current = newCurrent;
    }

    @Override
    public SpeedWithBearing getCurrent() {
        return this.current;
    }

    @Override
    public boolean hasCurrent() {
        if (this.current == null) {
            return false;
        }
        return this.current.getKnots() > 0.0;
    }

    public SpeedWithBearing addVectorSpeeds(SpeedWithBearing a, SpeedWithBearing b) {
        double yB;
        double yC;
        if (a.getKnots() == 0.0) {
            return b;
        }
        if (b.getKnots() == 0.0) {
            return a;
        }
        double xA = a.getKnots() * Math.sin(a.getBearing().getRadians());
        double yA = a.getKnots() * Math.cos(a.getBearing().getRadians());
        double xB = b.getKnots() * Math.sin(b.getBearing().getRadians());
        double xC = xA + xB;
        double bearC = Math.atan2(xC, yC = yA + (yB = b.getKnots() * Math.cos(b.getBearing().getRadians())));
        if (bearC < 0.0) {
            bearC += Math.PI * 2;
        }
        double lengthC = Math.sqrt(xC * xC + yC * yC);
        return new KnotSpeedWithBearingImpl(lengthC, (Bearing)new RadianBearingImpl(bearC));
    }

    public SpeedWithBearing getApparentWindFromCurrent(SpeedWithBearing newWind) {
        if (this.current == null) {
            return newWind;
        }
        if (this.current.getKnots() == 0.0) {
            return newWind;
        }
        return this.addVectorSpeeds(newWind, (SpeedWithBearing)new KnotSpeedWithBearingImpl(this.current.getKnots(), this.current.getBearing().reverse()));
    }

    public SpeedWithBearing getSOGfromSMF(SpeedWithBearing smf) {
        if (this.current == null) {
            return smf;
        }
        return this.addVectorSpeeds(smf, this.current);
    }

    @Override
    public SpeedWithBearing getSpeedAtBearingOverGround(Bearing bearing) {
        if (this.current == null || this.current.getKnots() == 0.0) {
            return this.getSpeedAtBearingRaw(bearing);
        }
        double[] values = new double[4];
        values[0] = this.trueWind.getKnots();
        values[1] = this.current.getKnots();
        values[2] = this.trueWind.getBearing().reverse().getDifferenceTo(this.current.getBearing()).getDegrees();
        if (values[2] < 0.0) {
            values[2] = values[2] + 360.0;
        }
        values[3] = this.trueWind.getBearing().reverse().getDifferenceTo(bearing).getDegrees();
        if (values[3] < 0.0) {
            values[3] = values[3] + 360.0;
        }
        double boatSpeed = this.interpolate(values, 0, this.extTable);
        return new KnotSpeedWithBearingImpl(boatSpeed * this.scaleSpeed, bearing);
    }

    @Override
    public SpeedWithBearing getSpeedAtBearing(Bearing bearing) {
        if (this.current == null) {
            return this.getSpeedAtBearingRaw(bearing);
        }
        KnotSpeedWithBearingImpl rotSpeed = new KnotSpeedWithBearingImpl(this.getSpeedAtBearingRaw(bearing).getKnots(), bearing);
        SpeedWithBearing transSpeed = this.getSOGfromSMF((SpeedWithBearing)rotSpeed);
        return transSpeed;
    }

    public SpeedWithBearing getSpeedAtBearingRaw(Bearing bearing) {
        double ceilingSpeed;
        double floorSpeed;
        Bearing relativeBearing = this.wind.getBearing().reverse().getDifferenceTo(bearing);
        if (relativeBearing.getDegrees() < 0.0) {
            relativeBearing = relativeBearing.getDifferenceTo((Bearing)new DegreeBearingImpl(0.0));
        }
        Speed floorWind = this.speedTable.floorKey((Speed)this.wind);
        Speed ceilingWind = this.speedTable.ceilingKey((Speed)this.wind);
        if (ceilingWind == null) {
            ceilingWind = floorWind;
        }
        if (floorWind == null) {
            floorWind = ceilingWind;
        }
        NavigableMap floorSpeeds = (NavigableMap)this.speedTable.get(floorWind);
        NavigableMap ceilingSpeeds = (NavigableMap)this.speedTable.get(ceilingWind);
        if (floorSpeeds.size() == 0) {
            floorSpeed = 0.0;
        } else {
            Speed floorSpeed1 = null;
            Map.Entry floorEntry = floorSpeeds.floorEntry(relativeBearing);
            if (floorEntry != null) {
                floorSpeed1 = (Speed)floorEntry.getValue();
            }
            Speed floorSpeed2 = null;
            floorEntry = floorSpeeds.ceilingEntry(relativeBearing);
            if (floorEntry != null) {
                floorSpeed2 = (Speed)floorEntry.getValue();
            }
            Bearing floorBearing1 = floorSpeeds.floorKey(relativeBearing);
            Bearing floorBearing2 = floorSpeeds.ceilingKey(relativeBearing);
            floorSpeed = floorBearing1 == null ? floorSpeed2.getKnots() : (floorBearing2 == null ? floorSpeed1.getKnots() : (floorSpeed1.equals(floorSpeed2) ? floorSpeed1.getKnots() : floorSpeed1.getKnots() + (relativeBearing.getRadians() - floorBearing1.getRadians()) * (floorSpeed2.getKnots() - floorSpeed1.getKnots()) / (floorBearing2.getRadians() - floorBearing1.getRadians())));
        }
        if (ceilingSpeeds.size() == 0) {
            ceilingSpeed = 0.0;
        } else {
            Speed ceilingSpeed1 = null;
            Map.Entry entry = ceilingSpeeds.floorEntry(relativeBearing);
            if (entry != null) {
                ceilingSpeed1 = (Speed)entry.getValue();
            }
            Speed ceilingSpeed2 = null;
            entry = ceilingSpeeds.ceilingEntry(relativeBearing);
            if (entry != null) {
                ceilingSpeed2 = (Speed)entry.getValue();
            }
            Bearing ceilingBearing1 = ceilingSpeeds.floorKey(relativeBearing);
            Bearing ceilingBearing2 = ceilingSpeeds.ceilingKey(relativeBearing);
            ceilingSpeed = ceilingBearing1 == null ? ceilingSpeed2.getKnots() : (ceilingBearing2 == null ? ceilingSpeed1.getKnots() : (ceilingSpeed1.equals(ceilingSpeed2) ? ceilingSpeed1.getKnots() : ceilingSpeed1.getKnots() + (relativeBearing.getRadians() - ceilingBearing1.getRadians()) * (ceilingSpeed2.getKnots() - ceilingSpeed1.getKnots()) / (ceilingBearing2.getRadians() - ceilingBearing1.getRadians())));
        }
        if (floorSpeeds.size() == 0) {
            floorSpeed = ceilingSpeed * floorWind.getKnots() / ceilingWind.getKnots();
        }
        if (ceilingSpeeds.size() == 0) {
            ceilingSpeed = floorSpeed * ceilingWind.getKnots() / floorWind.getKnots();
        }
        double speed = floorWind.equals(ceilingWind) ? floorSpeed : floorSpeed + (this.wind.getKnots() - floorWind.getKnots()) * (ceilingSpeed - floorSpeed) / (ceilingWind.getKnots() - floorWind.getKnots());
        return new KnotSpeedWithBearingImpl(speed * this.scaleSpeed, bearing);
    }

    @Override
    public Bearing[] optimalDirectionsUpwind() {
        Bearing windBearing = this.wind.getBearing().reverse();
        Bearing estBeatAngleRight = null;
        Bearing estBeatAngleLeft = null;
        if (this.targetDirection.equals(new DegreeBearingImpl(0.0))) {
            Speed floorSpeed;
            Bearing floorBeatAngle = this.beatAngles.floorEntry((Speed)this.wind) == null ? (this.beatAngles.ceilingEntry((Speed)this.wind) == null ? null : this.beatAngles.ceilingEntry((Speed)this.wind).getValue()) : this.beatAngles.floorEntry((Speed)this.wind).getValue();
            Bearing ceilingBeatAngle = this.beatAngles.ceilingEntry((Speed)this.wind) == null ? (this.beatAngles.floorEntry((Speed)this.wind) == null ? null : this.beatAngles.floorEntry((Speed)this.wind).getValue()) : this.beatAngles.ceilingEntry((Speed)this.wind).getValue();
            if (floorBeatAngle == null) {
                floorBeatAngle = new DegreeBearingImpl(0.0);
            }
            if (ceilingBeatAngle == null) {
                ceilingBeatAngle = new DegreeBearingImpl(0.0);
            }
            if ((floorSpeed = this.beatAngles.floorKey((Speed)this.wind)) == null) {
                floorSpeed = this.beatAngles.ceilingKey((Speed)this.wind);
            }
            Speed ceilingSpeed = this.beatAngles.ceilingKey((Speed)this.wind);
            if (this.beatAngles.ceilingKey((Speed)this.wind) == null) {
                ceilingSpeed = this.beatAngles.floorKey((Speed)this.wind);
            }
            double beatAngle = floorSpeed.equals(ceilingSpeed) ? floorBeatAngle.getRadians() : floorBeatAngle.getRadians() + (this.wind.getKnots() - floorSpeed.getKnots()) * (ceilingBeatAngle.getRadians() - floorBeatAngle.getRadians()) / (ceilingSpeed.getKnots() - floorSpeed.getKnots());
            double scaledBeatAngle = beatAngle * this.scaleBearing;
            estBeatAngleLeft = windBearing.add((Bearing)new RadianBearingImpl(-scaledBeatAngle));
            estBeatAngleRight = windBearing.add((Bearing)new RadianBearingImpl(scaledBeatAngle));
            return new Bearing[]{estBeatAngleLeft, estBeatAngleRight};
        }
        TreeSet<Bearing> allKeys = new TreeSet<Bearing>(bearingComparator);
        Double b = 0.0;
        while (b < 360.0) {
            allKeys.add((Bearing)new DegreeBearingImpl(b.doubleValue()));
            b = b + 5.0;
        }
        Bearing _targetDirection = this.targetDirection;
        this.setTargetDirection((Bearing)new DegreeBearingImpl(0.0));
        allKeys.addAll(Arrays.asList(this.optimalDirectionsUpwind()));
        allKeys.addAll(Arrays.asList(this.optimalDirectionsDownwind()));
        this.setTargetDirection(_targetDirection);
        Double maxSpeedRight = 0.0;
        Double maxSpeedLeft = 0.0;
        for (Bearing b2 : allKeys) {
            if (b2.getDifferenceTo(this.getWind().getBearing()).getDegrees() > 0.0) {
                double currentSpeedRight = this.getSpeedAtBearing(b2).getKnots() * Math.cos(b2.getDifferenceTo(this.getTargetDirection()).getRadians());
                if (!(currentSpeedRight > maxSpeedRight)) continue;
                maxSpeedRight = currentSpeedRight;
                estBeatAngleRight = b2;
                continue;
            }
            double currentSpeedLeft = this.getSpeedAtBearing(b2).getKnots() * Math.cos(b2.getDifferenceTo(this.getTargetDirection()).getRadians());
            if (!(currentSpeedLeft > maxSpeedLeft)) continue;
            maxSpeedLeft = currentSpeedLeft;
            estBeatAngleLeft = b2;
        }
        return new Bearing[]{estBeatAngleLeft, estBeatAngleRight};
    }

    @Override
    public SpeedWithBearing[] optimalVMGUpwind() {
        Bearing windBearing = this.wind.getBearing().reverse();
        RadianBearingImpl estBeatAngleRight = null;
        RadianBearingImpl estBeatAngleLeft = null;
        Bearing diffWindTarget = windBearing.getDifferenceTo(this.targetDirection);
        if (diffWindTarget.equals(new DegreeBearingImpl(0.0))) {
            Speed floorSpeed;
            Bearing floorBeatAngle = this.beatAngles.floorEntry((Speed)this.wind) == null ? this.beatAngles.ceilingEntry((Speed)this.wind).getValue() : this.beatAngles.floorEntry((Speed)this.wind).getValue();
            Bearing ceilingBeatAngle = this.beatAngles.ceilingEntry((Speed)this.wind) == null ? this.beatAngles.floorEntry((Speed)this.wind).getValue() : this.beatAngles.ceilingEntry((Speed)this.wind).getValue();
            if (floorBeatAngle == null) {
                floorBeatAngle = new DegreeBearingImpl(0.0);
            }
            if (ceilingBeatAngle == null) {
                ceilingBeatAngle = new DegreeBearingImpl(0.0);
            }
            if ((floorSpeed = this.beatAngles.floorKey((Speed)this.wind)) == null) {
                floorSpeed = this.beatAngles.ceilingKey((Speed)this.wind);
            }
            Speed ceilingSpeed = this.beatAngles.ceilingKey((Speed)this.wind);
            if (this.beatAngles.ceilingKey((Speed)this.wind) == null) {
                ceilingSpeed = this.beatAngles.floorKey((Speed)this.wind);
            }
            double beatAngle = floorSpeed.equals(ceilingSpeed) ? floorBeatAngle.getRadians() : floorBeatAngle.getRadians() + (this.wind.getKnots() - floorSpeed.getKnots()) * (ceilingBeatAngle.getRadians() - floorBeatAngle.getRadians()) / (ceilingSpeed.getKnots() - floorSpeed.getKnots());
            estBeatAngleRight = new RadianBearingImpl(beatAngle);
            estBeatAngleLeft = new RadianBearingImpl(-beatAngle);
            double speedLeft = this.getSpeedAtBearing((Bearing)estBeatAngleLeft).getKnots() * Math.cos(estBeatAngleLeft.getRadians());
            double speedRight = this.getSpeedAtBearing((Bearing)estBeatAngleRight).getKnots() * Math.cos(estBeatAngleRight.getRadians());
            KnotSpeedWithBearingImpl optVMGLeft = new KnotSpeedWithBearingImpl(speedLeft, windBearing.add((Bearing)estBeatAngleLeft));
            KnotSpeedWithBearingImpl optVMGRight = new KnotSpeedWithBearingImpl(speedRight, windBearing.add((Bearing)estBeatAngleRight));
            return new SpeedWithBearing[]{optVMGLeft, optVMGRight};
        }
        TreeSet<Bearing> allKeys = new TreeSet<Bearing>(bearingComparator);
        Bearing _targetDirection = this.targetDirection;
        this.setTargetDirection((Bearing)new DegreeBearingImpl(0.0));
        Bearing[] optDirectionsUpwind = this.optimalDirectionsUpwind();
        allKeys.addAll(Arrays.asList(optDirectionsUpwind));
        int idx = 0;
        while (idx < optDirectionsUpwind.length) {
            int offset = 1;
            while (offset <= 5) {
                allKeys.add((Bearing)new DegreeBearingImpl(optDirectionsUpwind[idx].getDegrees() + (double)offset));
                allKeys.add((Bearing)new DegreeBearingImpl(optDirectionsUpwind[idx].getDegrees() - (double)offset));
                ++offset;
            }
            ++idx;
        }
        allKeys.addAll(Arrays.asList(optDirectionsUpwind));
        allKeys.addAll(Arrays.asList(this.optimalDirectionsDownwind()));
        this.setTargetDirection(_targetDirection);
        Double maxSpeedRight = 0.0;
        Double maxSpeedLeft = 0.0;
        for (Bearing b : allKeys) {
            if (b.getDifferenceTo(this.getWind().getBearing()).getDegrees() > 0.0) {
                double currentSpeedRight = this.getSpeedAtBearing(b).getKnots() * Math.cos(b.getDifferenceTo(this.getTargetDirection()).getRadians());
                if (!(currentSpeedRight > maxSpeedRight)) continue;
                maxSpeedRight = currentSpeedRight;
                estBeatAngleRight = b;
                continue;
            }
            double currentSpeedLeft = this.getSpeedAtBearing(b).getKnots() * Math.cos(b.getDifferenceTo(this.getTargetDirection()).getRadians());
            if (!(currentSpeedLeft > maxSpeedLeft)) continue;
            maxSpeedLeft = currentSpeedLeft;
            estBeatAngleLeft = b;
        }
        KnotSpeedWithBearingImpl optVMGLeft = new KnotSpeedWithBearingImpl(maxSpeedLeft.doubleValue(), estBeatAngleLeft);
        KnotSpeedWithBearingImpl optVMGRight = new KnotSpeedWithBearingImpl(maxSpeedRight.doubleValue(), (Bearing)estBeatAngleRight);
        return new SpeedWithBearing[]{optVMGLeft, optVMGRight};
    }

    @Override
    public Bearing[] optimalDirectionsDownwind() {
        Bearing windBearing = this.wind.getBearing().reverse();
        Bearing estJibeAngleRight = null;
        Bearing estJibeAngleLeft = null;
        if (this.getTargetDirection().equals(new DegreeBearingImpl(0.0))) {
            windBearing = this.wind.getBearing().reverse();
            estJibeAngleRight = null;
            estJibeAngleLeft = null;
            Map.Entry<Speed, Bearing> floorEntry = this.jibeAngles.floorEntry((Speed)this.wind);
            Bearing floorJibeAngle = null;
            if (floorEntry != null) {
                floorJibeAngle = floorEntry.getValue();
            }
            Map.Entry<Speed, Bearing> ceilingEntry = this.jibeAngles.ceilingEntry((Speed)this.wind);
            Bearing ceilingJibeAngle = null;
            if (ceilingEntry != null) {
                ceilingJibeAngle = ceilingEntry.getValue();
            }
            if (floorJibeAngle == null) {
                floorJibeAngle = ceilingJibeAngle;
            }
            if (ceilingJibeAngle == null) {
                ceilingJibeAngle = floorJibeAngle;
            }
            Speed floorSpeed = this.jibeAngles.floorKey((Speed)this.wind);
            Speed ceilingSpeed = this.jibeAngles.ceilingKey((Speed)this.wind);
            if (floorSpeed == null) {
                floorSpeed = ceilingSpeed;
            }
            if (ceilingSpeed == null) {
                ceilingSpeed = floorSpeed;
            }
            double jibeAngle = floorSpeed.equals(ceilingSpeed) ? floorJibeAngle.getRadians() : floorJibeAngle.getRadians() + (this.wind.getKnots() - floorSpeed.getKnots()) * (ceilingJibeAngle.getRadians() - floorJibeAngle.getRadians()) / (ceilingSpeed.getKnots() - floorSpeed.getKnots());
            double scaledJibeAngle = Math.PI - (Math.PI - jibeAngle) * this.scaleBearing;
            estJibeAngleRight = windBearing.add((Bearing)new RadianBearingImpl(scaledJibeAngle));
            estJibeAngleLeft = windBearing.add((Bearing)new RadianBearingImpl(-scaledJibeAngle));
            return new Bearing[]{estJibeAngleRight, estJibeAngleLeft};
        }
        TreeSet<Bearing> allKeys = new TreeSet<Bearing>(bearingComparator);
        Double b = 0.0;
        while (b < 360.0) {
            allKeys.add((Bearing)new DegreeBearingImpl(b.doubleValue()));
            b = b + 5.0;
        }
        Bearing _targetDirection = this.targetDirection;
        this.setTargetDirection((Bearing)new DegreeBearingImpl(0.0));
        allKeys.addAll(Arrays.asList(this.optimalDirectionsUpwind()));
        allKeys.addAll(Arrays.asList(this.optimalDirectionsDownwind()));
        this.setTargetDirection(_targetDirection);
        Double maxSpeedRight = 0.0;
        Double maxSpeedLeft = 0.0;
        for (Bearing b2 : allKeys) {
            if (b2.getDifferenceTo(this.getWind().getBearing()).getDegrees() > 0.0) {
                if (!(this.getSpeedAtBearing(b2).getKnots() * Math.cos(b2.getDifferenceTo(this.getTargetDirection().reverse()).getRadians()) > maxSpeedRight)) continue;
                maxSpeedRight = this.getSpeedAtBearing(b2).getKnots() * Math.cos(b2.getDifferenceTo(this.getTargetDirection().reverse()).getRadians());
                estJibeAngleRight = b2;
                continue;
            }
            if (!(this.getSpeedAtBearing(b2).getKnots() * Math.cos(b2.getDifferenceTo(this.getTargetDirection().reverse()).getRadians()) > maxSpeedLeft)) continue;
            maxSpeedLeft = this.getSpeedAtBearing(b2).getKnots() * Math.cos(b2.getDifferenceTo(this.getTargetDirection().reverse()).getRadians());
            estJibeAngleLeft = b2;
        }
        return new Bearing[]{estJibeAngleLeft, estJibeAngleRight};
    }

    @Override
    public long getTurnLoss() {
        int turnLoss = this.boatClass.getName() != null && this.boatClass.getName().equals(BoatClassMasterdata.EXTREME_40.getDisplayName()) ? 2000 : (this.boatClass.getName() != null && this.boatClass.getName().equals(BoatClassMasterdata.GC_32.getDisplayName()) ? 2000 : (this.boatClass.getName() != null && this.boatClass.getName().equals(BoatClassMasterdata._5O5.getDisplayName()) ? 5000 : 4000));
        return turnLoss;
    }

    @Override
    public PolarDiagram.WindSide getWindSide(Bearing bearing) {
        PolarDiagram.WindSide windSide = null;
        if (bearingComparator.compare(bearing, this.wind.getBearing().reverse()) > 0) {
            windSide = PolarDiagram.WindSide.LEFT;
        }
        if (bearingComparator.compare(bearing, this.wind.getBearing().reverse()) < 0) {
            windSide = PolarDiagram.WindSide.RIGHT;
        }
        if (bearing.equals(this.wind.getBearing())) {
            windSide = PolarDiagram.WindSide.DOWNWIND;
        }
        if (bearing.equals(this.wind.getBearing().reverse())) {
            windSide = PolarDiagram.WindSide.UPWIND;
        }
        return windSide;
    }

    @Override
    public NavigableMap<Speed, NavigableMap<Bearing, Speed>> polarDiagramPlot(Double bearingStep, Set<Speed> extraSpeeds) {
        TreeMap<Speed, NavigableMap<Bearing, Speed>> table = new TreeMap<Speed, NavigableMap<Bearing, Speed>>();
        TreeSet<Object> speedSet = new TreeSet<Object>();
        speedSet.addAll(this.speedTable.keySet());
        if (extraSpeeds != null) {
            speedSet.addAll(extraSpeeds);
        }
        for (Speed speed : speedSet) {
            this.setWind((SpeedWithBearing)new KnotSpeedWithBearingImpl(speed.getKnots(), (Bearing)new DegreeBearingImpl(180.0)));
            TreeMap<Bearing, SpeedWithBearing> currentTable = new TreeMap<Bearing, SpeedWithBearing>(bearingComparator);
            table.put(speed, currentTable);
            Double b = 0.0;
            while (b < 360.0) {
                DegreeBearingImpl bearing = new DegreeBearingImpl(b.doubleValue());
                currentTable.put((Bearing)bearing, this.getSpeedAtBearing((Bearing)bearing));
                b = b + bearingStep;
            }
        }
        return table;
    }

    @Override
    public NavigableMap<Speed, NavigableMap<Bearing, Speed>> polarDiagramPlot(Double bearingStep) {
        TreeMap<Speed, NavigableMap<Bearing, Speed>> table = new TreeMap<Speed, NavigableMap<Bearing, Speed>>();
        HashSet<Bearing> extraBearings = new HashSet<Bearing>();
        for (Speed s : this.speedTable.keySet()) {
            this.setWind((SpeedWithBearing)new KnotSpeedWithBearingImpl(s.getKnots(), (Bearing)new DegreeBearingImpl(180.0)));
            extraBearings.addAll(Arrays.asList(this.optimalDirectionsUpwind()));
            extraBearings.addAll(Arrays.asList(this.optimalDirectionsDownwind()));
        }
        for (Speed s : this.speedTable.keySet()) {
            this.setWind((SpeedWithBearing)new KnotSpeedWithBearingImpl(s.getKnots(), (Bearing)new DegreeBearingImpl(180.0)));
            TreeMap<Bearing, SpeedWithBearing> currentTable = new TreeMap<Bearing, SpeedWithBearing>(bearingComparator);
            table.put(s, currentTable);
            Double b = 0.0;
            while (b < 360.0) {
                DegreeBearingImpl bearing = new DegreeBearingImpl(b.doubleValue());
                currentTable.put((Bearing)bearing, this.getSpeedAtBearing((Bearing)bearing));
                b = b + bearingStep;
            }
        }
        return table;
    }

    @Override
    public Bearing getTargetDirection() {
        return this.targetDirection;
    }

    @Override
    public void setTargetDirection(Bearing newTargetDirection) {
        this.targetDirection = newTargetDirection;
    }

    @Override
    public Util.Pair<PointOfSail, BoatDirection> getPointOfSail(Bearing bearTarget) {
        double offSet = 1.0;
        Bearing[] bearOptimalUpwind = this.optimalDirectionsUpwind();
        Bearing[] bearOptimalDownwind = this.optimalDirectionsDownwind();
        Bearing upwindLeftRight = bearOptimalUpwind[0].getDifferenceTo(bearOptimalUpwind[1]);
        Bearing upwindLeftTarget = bearOptimalUpwind[0].getDifferenceTo(bearTarget);
        PointOfSail pointOfSail = PointOfSail.REACHING;
        BoatDirection reachingSide = BoatDirection.NONE;
        if (upwindLeftTarget.getDegrees() >= -offSet && upwindLeftTarget.getDegrees() <= upwindLeftRight.getDegrees() + offSet) {
            pointOfSail = PointOfSail.TACKING;
        } else {
            Bearing downwindLeftRight = bearOptimalDownwind[0].getDifferenceTo(bearOptimalDownwind[1]);
            Bearing downwindLeftTarget = bearOptimalDownwind[0].getDifferenceTo(bearTarget);
            if (downwindLeftTarget.getDegrees() >= -offSet && downwindLeftTarget.getDegrees() <= downwindLeftRight.getDegrees() + offSet) {
                pointOfSail = PointOfSail.JIBING;
            } else {
                Bearing windBoat = this.wind.getBearing().getDifferenceTo(bearTarget);
                reachingSide = windBoat.getDegrees() > 0.0 ? BoatDirection.REACH_LEFT : BoatDirection.REACH_RIGHT;
            }
        }
        return new Util.Pair((Object)pointOfSail, (Object)reachingSide);
    }
}

