/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.simulator.Path;
import com.sap.sailing.simulator.PolarDiagram;
import com.sap.sailing.simulator.SimulationParameters;
import com.sap.sailing.simulator.TimedPositionWithSpeed;
import com.sap.sailing.simulator.impl.PathGeneratorBase;
import com.sap.sailing.simulator.impl.PathImpl;
import com.sap.sailing.simulator.impl.RectangularGrid;
import com.sap.sailing.simulator.impl.TimedPositionImpl;
import com.sap.sailing.simulator.impl.TimedPositionWithSpeedImpl;
import com.sap.sailing.simulator.windfield.WindFieldGenerator;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class PathGeneratorDijkstra
extends PathGeneratorBase {
    public PathGeneratorDijkstra(SimulationParameters params) {
        this.parameters = params;
    }

    @Override
    public Path getPath() {
        int n;
        this.algorithmStartTime = MillisecondsTimePoint.now();
        RectangularGrid boundary = new RectangularGrid(this.parameters.getCourse().get(0), this.parameters.getCourse().get(1));
        WindFieldGenerator windField = this.parameters.getWindField();
        PolarDiagram polarDiagram = this.parameters.getBoatPolarDiagram();
        Position start = this.parameters.getCourse().get(0);
        Position end = this.parameters.getCourse().get(1);
        TimePoint startTime = windField.getStartTime();
        LinkedList<TimedPositionWithSpeed> lst = new LinkedList<TimedPositionWithSpeed>();
        int gridv = 10;
        int gridh = 100;
        Position[][] sailGrid = boundary.generatePositions(gridh, gridv, 0, 0);
        HashMap<Position, List<Position>> graph = new HashMap<Position, List<Position>>();
        graph.put(start, Arrays.asList(sailGrid[1]));
        int i = 1;
        while (i < gridv - 2) {
            Position[] positionArray = sailGrid[i];
            int n2 = positionArray.length;
            n = 0;
            while (n < n2) {
                Position p = positionArray[n];
                graph.put(p, Arrays.asList(sailGrid[i + 1]));
                ++n;
            }
            ++i;
        }
        Position[] positionArray = sailGrid[gridv - 2];
        n = positionArray.length;
        int p = 0;
        while (p < n) {
            Position p2 = positionArray[p];
            graph.put(p2, Arrays.asList(end));
            ++p;
        }
        HashMap<Position, Util.Pair> tentativeDistances = new HashMap<Position, Util.Pair>();
        for (Position p3 : graph.keySet()) {
            tentativeDistances.put(p3, new Util.Pair((Object)Long.MAX_VALUE, null));
        }
        tentativeDistances.put(start, new Util.Pair((Object)startTime.asMillis(), null));
        tentativeDistances.put(end, new Util.Pair((Object)Long.MAX_VALUE, null));
        ArrayList unvisited = new ArrayList(graph.keySet());
        unvisited.add(end);
        Position currentPosition = start;
        TimePoint currentTime = startTime;
        while (currentPosition != end && !this.isTimedOut()) {
            TimedPositionImpl currentTimedPosition = new TimedPositionImpl(currentTime, currentPosition);
            Wind currentWind = windField.getWind(currentTimedPosition);
            polarDiagram.setWind((SpeedWithBearing)currentWind);
            LinkedList unvisitedNeighbours = new LinkedList((Collection)graph.get(currentPosition));
            unvisitedNeighbours.retainAll(unvisited);
            for (Position p4 : unvisitedNeighbours) {
                Bearing bearingToP = currentPosition.getBearingGreatCircle(p4);
                Distance distanceToP = currentPosition.getDistance(p4);
                SpeedWithBearing speedToP = polarDiagram.getSpeedAtBearing(bearingToP);
                Long timeToP = (long)(1000.0 * (distanceToP.getMeters() / speedToP.getMetersPerSecond()));
                Long tentativeDistanceToP = currentTime.asMillis() + timeToP;
                if (tentativeDistanceToP >= (Long)((Util.Pair)tentativeDistances.get(p4)).getA()) continue;
                tentativeDistances.put(p4, new Util.Pair((Object)tentativeDistanceToP, (Object)currentPosition));
            }
            unvisited.remove(currentPosition);
            Long minTentativeDistance = Long.MAX_VALUE;
            for (Position p5 : unvisited) {
                if ((Long)((Util.Pair)tentativeDistances.get(p5)).getA() >= minTentativeDistance) continue;
                currentPosition = p5;
                minTentativeDistance = (Long)((Util.Pair)tentativeDistances.get(p5)).getA();
                currentTime = new MillisecondsTimePoint(minTentativeDistance.longValue());
            }
        }
        while (currentPosition != null && !this.isTimedOut()) {
            currentTime = new MillisecondsTimePoint(((Long)((Util.Pair)tentativeDistances.get(currentPosition)).getA()).longValue());
            Wind windAtPoint = windField.getWind(new TimedPositionImpl(currentTime, currentPosition));
            TimedPositionWithSpeedImpl current = new TimedPositionWithSpeedImpl(currentTime, currentPosition, (SpeedWithBearing)windAtPoint);
            lst.addFirst(current);
            currentPosition = (Position)((Util.Pair)tentativeDistances.get(currentPosition)).getB();
        }
        return new PathImpl(lst, windField, this.algorithmTimedOut);
    }
}

