/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.expeditionconnector;

import com.sap.sailing.declination.DeclinationService;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.racelog.tracking.SensorFixStore;
import com.sap.sailing.domain.racelog.tracking.SensorFixStoreSupplier;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.WindTracker;
import com.sap.sailing.domain.tracking.WindTrackerFactory;
import com.sap.sailing.expeditionconnector.DeviceRegistry;
import com.sap.sailing.expeditionconnector.ExpeditionDeviceConfiguration;
import com.sap.sailing.expeditionconnector.ExpeditionSensorDeviceIdentifier;
import com.sap.sailing.expeditionconnector.ExpeditionWindTracker;
import com.sap.sailing.expeditionconnector.UDPExpeditionReceiver;
import com.sap.sailing.expeditionconnector.impl.Activator;
import com.sap.sailing.expeditionconnector.persistence.DomainObjectFactory;
import com.sap.sailing.expeditionconnector.persistence.ExpeditionGpsDeviceIdentifier;
import com.sap.sailing.expeditionconnector.persistence.ExpeditionGpsDeviceIdentifierImpl;
import com.sap.sailing.expeditionconnector.persistence.ExpeditionSensorDeviceIdentifierImpl;
import com.sap.sailing.expeditionconnector.persistence.MongoObjectFactory;
import com.sap.sailing.expeditionconnector.persistence.PersistenceFactory;
import com.sap.sse.security.SecurityService;
import com.sap.sse.util.ClearStateTestSupport;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ExpeditionTrackerFactory
implements WindTrackerFactory,
DeviceRegistry,
ClearStateTestSupport {
    private static Logger logger = Logger.getLogger(ExpeditionTrackerFactory.class.getName());
    private static ExpeditionTrackerFactory defaultInstance;
    private final Map<RaceDefinition, WindTracker> windTrackers = new HashMap<RaceDefinition, WindTracker>();
    private final Map<Integer, UDPExpeditionReceiver> windReceivers;
    private final ConcurrentHashMap<UUID, ExpeditionDeviceConfiguration> deviceConfigurations;
    private final ConcurrentHashMap<Integer, ExpeditionDeviceConfiguration> devicesPerBoatId;
    private final int defaultPort;
    private SensorFixStore sensorFixStore;
    private ServiceTracker<SensorFixStoreSupplier, SensorFixStoreSupplier> sensorFixServiceTracker;
    private final MongoObjectFactory mongoObjectFactory;

    public ExpeditionTrackerFactory(SensorFixStore sensorFixStore, DomainObjectFactory domainObjectFactory, MongoObjectFactory mongoObjectFactory) {
        this.sensorFixStore = sensorFixStore;
        this.windReceivers = new HashMap<Integer, UDPExpeditionReceiver>();
        Activator activator = Activator.getInstance();
        this.defaultPort = activator.getExpeditionUDPPort();
        this.deviceConfigurations = new ConcurrentHashMap();
        this.devicesPerBoatId = new ConcurrentHashMap();
        BundleContext context = activator.getContext();
        this.mongoObjectFactory = mongoObjectFactory;
        for (ExpeditionDeviceConfiguration expeditionDeviceConfigurationLoadedFromDB : domainObjectFactory.getExpeditionDeviceConfigurations()) {
            this.addOrReplaceDeviceConfigurationNoPersistence(expeditionDeviceConfigurationLoadedFromDB);
        }
        this.sensorFixServiceTracker = context != null ? this.startListeningForSensorFixStoreSuppliers(context) : null;
        logger.info("Created " + this.getClass().getName() + " with default UDP port " + this.defaultPort);
    }

    private ServiceTracker<SensorFixStoreSupplier, SensorFixStoreSupplier> startListeningForSensorFixStoreSuppliers(BundleContext context) {
        ServiceTracker result = new ServiceTracker(context, SensorFixStoreSupplier.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<SensorFixStoreSupplier, SensorFixStoreSupplier>(){

            public SensorFixStoreSupplier addingService(ServiceReference<SensorFixStoreSupplier> reference) {
                SensorFixStoreSupplier service = (SensorFixStoreSupplier)Activator.getInstance().getContext().getService(reference);
                ExpeditionTrackerFactory.this.sensorFixStore = service.getSensorFixStore();
                return service;
            }

            public void modifiedService(ServiceReference<SensorFixStoreSupplier> reference, SensorFixStoreSupplier service) {
            }

            public void removedService(ServiceReference<SensorFixStoreSupplier> reference, SensorFixStoreSupplier service) {
                SensorFixStoreSupplier nextService = (SensorFixStoreSupplier)ExpeditionTrackerFactory.this.sensorFixServiceTracker.getService();
                if (nextService != null) {
                    ExpeditionTrackerFactory.this.sensorFixStore = nextService.getSensorFixStore();
                }
            }
        });
        result.open();
        return result;
    }

    public static synchronized ExpeditionTrackerFactory getInstance() {
        return ExpeditionTrackerFactory.getInstance(null, PersistenceFactory.INSTANCE.getDefaultDomainObjectFactory(), PersistenceFactory.INSTANCE.getDefaultMongoObjectFactory());
    }

    public static ExpeditionTrackerFactory getInstance(SensorFixStore sensorFixStore, DomainObjectFactory domainObjectFactory, MongoObjectFactory mongoObjectFactory) {
        if (defaultInstance == null) {
            defaultInstance = new ExpeditionTrackerFactory(sensorFixStore, domainObjectFactory, mongoObjectFactory);
        }
        return defaultInstance;
    }

    public WindTracker createWindTracker(DynamicTrackedRegatta trackedRegatta, RaceDefinition race, boolean correctByDeclination, SecurityService optionalSecurityService) throws SocketException {
        WindTracker result = this.getExistingWindTracker(race);
        if (result == null) {
            DynamicTrackedRace trackedRace = trackedRegatta.getTrackedRace(race);
            UDPExpeditionReceiver receiver = this.getOrCreateWindReceiverOnDefaultPort();
            result = new ExpeditionWindTracker(trackedRace, (DeclinationService)(correctByDeclination ? DeclinationService.INSTANCE : null), receiver, this);
            this.windTrackers.put(race, result);
        }
        return result;
    }

    public WindTracker getExistingWindTracker(RaceDefinition race) {
        return this.windTrackers.get(race);
    }

    public UDPExpeditionReceiver getOrCreateWindReceiverOnDefaultPort() throws SocketException {
        return this.getOrCreateWindReceiverForPort(this.defaultPort);
    }

    private synchronized UDPExpeditionReceiver getOrCreateWindReceiverForPort(int port) throws SocketException {
        UDPExpeditionReceiver receiver = this.windReceivers.get(port);
        if (receiver == null) {
            receiver = new UDPExpeditionReceiver(port, this);
            this.windReceivers.put(port, receiver);
            Thread t = new Thread((Runnable)((Object)receiver), "Expedition Wind Receiver on port " + port);
            t.setDaemon(true);
            t.start();
        }
        return receiver;
    }

    synchronized void trackerStopped(RaceDefinition race, ExpeditionWindTracker windTracker) {
        if (this.windTrackers.get(race) != windTracker) {
            throw new IllegalArgumentException("Intenral error: expected to remove wind tracker " + windTracker + ", but another wind tracker " + this.windTrackers.get(race) + " was registered.");
        }
        this.windTrackers.remove(race);
        if (windTracker.getReceiver().isStopped()) {
            UDPExpeditionReceiver receiver = this.windReceivers.get(windTracker.getReceiver().getPort());
            if (receiver != windTracker.getReceiver()) {
                throw new IllegalArgumentException("Internal error: expected to remove wind receiver " + (Object)((Object)windTracker.getReceiver()) + " but found receiver " + (Object)((Object)receiver));
            }
            this.windReceivers.remove(windTracker.getReceiver().getPort());
        }
    }

    public String toString() {
        return "ExpeditionWindTrackerFactory [defaultPort=" + this.defaultPort + "]";
    }

    public Iterable<? extends ExpeditionDeviceConfiguration> getDeviceConfigurations() {
        return Collections.unmodifiableCollection(this.deviceConfigurations.values());
    }

    public void addOrReplaceDeviceConfiguration(ExpeditionDeviceConfiguration deviceConfiguration) {
        this.addOrReplaceDeviceConfigurationNoPersistence(deviceConfiguration);
        this.mongoObjectFactory.storeExpeditionDeviceConfiguration(deviceConfiguration);
    }

    private void addOrReplaceDeviceConfigurationNoPersistence(ExpeditionDeviceConfiguration deviceConfiguration) {
        if (deviceConfiguration.getExpeditionBoatId() != null && this.devicesPerBoatId.containsKey(deviceConfiguration.getExpeditionBoatId()) && !this.devicesPerBoatId.get(deviceConfiguration.getExpeditionBoatId()).getDeviceUuid().equals(deviceConfiguration.getDeviceUuid())) {
            throw new IllegalStateException("Trying to create an ambiguous Expedition Boat ID mapping: established is " + this.devicesPerBoatId.get(deviceConfiguration.getExpeditionBoatId()) + " and boat ID #" + deviceConfiguration.getExpeditionBoatId() + " therefore cannot be mapped to " + deviceConfiguration + " at the same time.");
        }
        ExpeditionDeviceConfiguration old = this.deviceConfigurations.put(deviceConfiguration.getDeviceUuid(), deviceConfiguration);
        if (old != null && old.getExpeditionBoatId() != null) {
            this.devicesPerBoatId.remove(old.getExpeditionBoatId());
        }
        if (deviceConfiguration.getExpeditionBoatId() != null) {
            this.devicesPerBoatId.put(deviceConfiguration.getExpeditionBoatId(), deviceConfiguration);
        }
    }

    public void removeDeviceConfiguration(UUID deviceConfigurationId) {
        ExpeditionDeviceConfiguration deviceConfiguration = this.deviceConfigurations.remove(deviceConfigurationId);
        if (deviceConfiguration != null && deviceConfiguration.getExpeditionBoatId() != null) {
            this.devicesPerBoatId.remove(deviceConfiguration.getExpeditionBoatId());
        }
        this.mongoObjectFactory.removeExpeditionDeviceConfiguration(deviceConfigurationId);
    }

    @Override
    public ExpeditionGpsDeviceIdentifier getGpsDeviceIdentifier(int boatId) {
        ExpeditionDeviceConfiguration deviceConfig = this.devicesPerBoatId.get(boatId);
        ExpeditionGpsDeviceIdentifierImpl result = deviceConfig == null ? null : new ExpeditionGpsDeviceIdentifierImpl(deviceConfig.getDeviceUuid());
        return result;
    }

    @Override
    public ExpeditionSensorDeviceIdentifier getSensorDeviceIdentifier(int boatId) {
        ExpeditionDeviceConfiguration deviceConfig = this.devicesPerBoatId.get(boatId);
        ExpeditionSensorDeviceIdentifierImpl result = deviceConfig == null ? null : new ExpeditionSensorDeviceIdentifierImpl(deviceConfig.getDeviceUuid());
        return result;
    }

    @Override
    public SensorFixStore getSensorFixStore() {
        return this.sensorFixStore;
    }

    public void clearState() throws Exception {
        for (UUID devicesPerBoatId : new ArrayList(this.deviceConfigurations.keySet())) {
            this.removeDeviceConfiguration(devicesPerBoatId);
        }
    }
}

