/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingadapter;

import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;

public interface SwissTimingConfiguration
extends WithQualifiedObjectIdentifier {
    public String getCreatorName();

    public String getName();

    public String getJsonURL();

    public String getHostname();

    public Integer getPort();

    public String getUpdateURL();

    public String getApiToken();

    default public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    default public HasPermissions getPermissionType() {
        return SecuredDomainType.SWISS_TIMING_ACCOUNT;
    }

    default public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return SwissTimingConfiguration.getTypeRelativeObjectIdentifier(this.getJsonURL(), this.getCreatorName());
    }

    public static TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier(String jsonUrl, String username) {
        return username == null ? new TypeRelativeObjectIdentifier(new String[]{jsonUrl}) : new TypeRelativeObjectIdentifier(new String[]{jsonUrl, username});
    }
}

