/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSamlProviderRequest extends IamRequest implements
        ToCopyableBuilder<UpdateSamlProviderRequest.Builder, UpdateSamlProviderRequest> {
    private static final SdkField<String> SAML_METADATA_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SAMLMetadataDocument").getter(getter(UpdateSamlProviderRequest::samlMetadataDocument))
            .setter(setter(Builder::samlMetadataDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLMetadataDocument").build())
            .build();

    private static final SdkField<String> SAML_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SAMLProviderArn").getter(getter(UpdateSamlProviderRequest::samlProviderArn))
            .setter(setter(Builder::samlProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLProviderArn").build()).build();

    private static final SdkField<String> ASSERTION_ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssertionEncryptionMode").getter(getter(UpdateSamlProviderRequest::assertionEncryptionModeAsString))
            .setter(setter(Builder::assertionEncryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssertionEncryptionMode").build())
            .build();

    private static final SdkField<String> ADD_PRIVATE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddPrivateKey").getter(getter(UpdateSamlProviderRequest::addPrivateKey))
            .setter(setter(Builder::addPrivateKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddPrivateKey").build()).build();

    private static final SdkField<String> REMOVE_PRIVATE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RemovePrivateKey").getter(getter(UpdateSamlProviderRequest::removePrivateKey))
            .setter(setter(Builder::removePrivateKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemovePrivateKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAML_METADATA_DOCUMENT_FIELD,
            SAML_PROVIDER_ARN_FIELD, ASSERTION_ENCRYPTION_MODE_FIELD, ADD_PRIVATE_KEY_FIELD, REMOVE_PRIVATE_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String samlMetadataDocument;

    private final String samlProviderArn;

    private final String assertionEncryptionMode;

    private final String addPrivateKey;

    private final String removePrivateKey;

    private UpdateSamlProviderRequest(BuilderImpl builder) {
        super(builder);
        this.samlMetadataDocument = builder.samlMetadataDocument;
        this.samlProviderArn = builder.samlProviderArn;
        this.assertionEncryptionMode = builder.assertionEncryptionMode;
        this.addPrivateKey = builder.addPrivateKey;
        this.removePrivateKey = builder.removePrivateKey;
    }

    /**
     * <p>
     * An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the
     * issuer's name, expiration information, and keys that can be used to validate the SAML authentication response
     * (assertions) that are received from the IdP. You must generate the metadata document using the identity
     * management software that is used as your IdP.
     * </p>
     * 
     * @return An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the
     *         issuer's name, expiration information, and keys that can be used to validate the SAML authentication
     *         response (assertions) that are received from the IdP. You must generate the metadata document using the
     *         identity management software that is used as your IdP.
     */
    public final String samlMetadataDocument() {
        return samlMetadataDocument;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SAML provider to update.
     * </p>
     * <p>
     * For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SAML provider to update.</p>
     *         <p>
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final String samlProviderArn() {
        return samlProviderArn;
    }

    /**
     * <p>
     * Specifies the encryption setting for the SAML provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #assertionEncryptionMode} will return {@link AssertionEncryptionModeType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #assertionEncryptionModeAsString}.
     * </p>
     * 
     * @return Specifies the encryption setting for the SAML provider.
     * @see AssertionEncryptionModeType
     */
    public final AssertionEncryptionModeType assertionEncryptionMode() {
        return AssertionEncryptionModeType.fromValue(assertionEncryptionMode);
    }

    /**
     * <p>
     * Specifies the encryption setting for the SAML provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #assertionEncryptionMode} will return {@link AssertionEncryptionModeType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #assertionEncryptionModeAsString}.
     * </p>
     * 
     * @return Specifies the encryption setting for the SAML provider.
     * @see AssertionEncryptionModeType
     */
    public final String assertionEncryptionModeAsString() {
        return assertionEncryptionMode;
    }

    /**
     * <p>
     * Specifies the new private key from your external identity provider. The private key must be a .pem file that uses
     * AES-GCM or AES-CBC encryption algorithm to decrypt SAML assertions.
     * </p>
     * 
     * @return Specifies the new private key from your external identity provider. The private key must be a .pem file
     *         that uses AES-GCM or AES-CBC encryption algorithm to decrypt SAML assertions.
     */
    public final String addPrivateKey() {
        return addPrivateKey;
    }

    /**
     * <p>
     * The Key ID of the private key to remove.
     * </p>
     * 
     * @return The Key ID of the private key to remove.
     */
    public final String removePrivateKey() {
        return removePrivateKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(samlMetadataDocument());
        hashCode = 31 * hashCode + Objects.hashCode(samlProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(assertionEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(addPrivateKey());
        hashCode = 31 * hashCode + Objects.hashCode(removePrivateKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSamlProviderRequest)) {
            return false;
        }
        UpdateSamlProviderRequest other = (UpdateSamlProviderRequest) obj;
        return Objects.equals(samlMetadataDocument(), other.samlMetadataDocument())
                && Objects.equals(samlProviderArn(), other.samlProviderArn())
                && Objects.equals(assertionEncryptionModeAsString(), other.assertionEncryptionModeAsString())
                && Objects.equals(addPrivateKey(), other.addPrivateKey())
                && Objects.equals(removePrivateKey(), other.removePrivateKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSamlProviderRequest").add("SAMLMetadataDocument", samlMetadataDocument())
                .add("SAMLProviderArn", samlProviderArn()).add("AssertionEncryptionMode", assertionEncryptionModeAsString())
                .add("AddPrivateKey", addPrivateKey() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RemovePrivateKey", removePrivateKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SAMLMetadataDocument":
            return Optional.ofNullable(clazz.cast(samlMetadataDocument()));
        case "SAMLProviderArn":
            return Optional.ofNullable(clazz.cast(samlProviderArn()));
        case "AssertionEncryptionMode":
            return Optional.ofNullable(clazz.cast(assertionEncryptionModeAsString()));
        case "AddPrivateKey":
            return Optional.ofNullable(clazz.cast(addPrivateKey()));
        case "RemovePrivateKey":
            return Optional.ofNullable(clazz.cast(removePrivateKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SAMLMetadataDocument", SAML_METADATA_DOCUMENT_FIELD);
        map.put("SAMLProviderArn", SAML_PROVIDER_ARN_FIELD);
        map.put("AssertionEncryptionMode", ASSERTION_ENCRYPTION_MODE_FIELD);
        map.put("AddPrivateKey", ADD_PRIVATE_KEY_FIELD);
        map.put("RemovePrivateKey", REMOVE_PRIVATE_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSamlProviderRequest, T> g) {
        return obj -> g.apply((UpdateSamlProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSamlProviderRequest> {
        /**
         * <p>
         * An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the
         * issuer's name, expiration information, and keys that can be used to validate the SAML authentication response
         * (assertions) that are received from the IdP. You must generate the metadata document using the identity
         * management software that is used as your IdP.
         * </p>
         * 
         * @param samlMetadataDocument
         *        An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes
         *        the issuer's name, expiration information, and keys that can be used to validate the SAML
         *        authentication response (assertions) that are received from the IdP. You must generate the metadata
         *        document using the identity management software that is used as your IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlMetadataDocument(String samlMetadataDocument);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SAML provider to update.
         * </p>
         * <p>
         * For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param samlProviderArn
         *        The Amazon Resource Name (ARN) of the SAML provider to update.</p>
         *        <p>
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlProviderArn(String samlProviderArn);

        /**
         * <p>
         * Specifies the encryption setting for the SAML provider.
         * </p>
         * 
         * @param assertionEncryptionMode
         *        Specifies the encryption setting for the SAML provider.
         * @see AssertionEncryptionModeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssertionEncryptionModeType
         */
        Builder assertionEncryptionMode(String assertionEncryptionMode);

        /**
         * <p>
         * Specifies the encryption setting for the SAML provider.
         * </p>
         * 
         * @param assertionEncryptionMode
         *        Specifies the encryption setting for the SAML provider.
         * @see AssertionEncryptionModeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssertionEncryptionModeType
         */
        Builder assertionEncryptionMode(AssertionEncryptionModeType assertionEncryptionMode);

        /**
         * <p>
         * Specifies the new private key from your external identity provider. The private key must be a .pem file that
         * uses AES-GCM or AES-CBC encryption algorithm to decrypt SAML assertions.
         * </p>
         * 
         * @param addPrivateKey
         *        Specifies the new private key from your external identity provider. The private key must be a .pem
         *        file that uses AES-GCM or AES-CBC encryption algorithm to decrypt SAML assertions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addPrivateKey(String addPrivateKey);

        /**
         * <p>
         * The Key ID of the private key to remove.
         * </p>
         * 
         * @param removePrivateKey
         *        The Key ID of the private key to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removePrivateKey(String removePrivateKey);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String samlMetadataDocument;

        private String samlProviderArn;

        private String assertionEncryptionMode;

        private String addPrivateKey;

        private String removePrivateKey;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSamlProviderRequest model) {
            super(model);
            samlMetadataDocument(model.samlMetadataDocument);
            samlProviderArn(model.samlProviderArn);
            assertionEncryptionMode(model.assertionEncryptionMode);
            addPrivateKey(model.addPrivateKey);
            removePrivateKey(model.removePrivateKey);
        }

        public final String getSamlMetadataDocument() {
            return samlMetadataDocument;
        }

        public final void setSamlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
        }

        @Override
        public final Builder samlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
            return this;
        }

        public final String getSamlProviderArn() {
            return samlProviderArn;
        }

        public final void setSamlProviderArn(String samlProviderArn) {
            this.samlProviderArn = samlProviderArn;
        }

        @Override
        public final Builder samlProviderArn(String samlProviderArn) {
            this.samlProviderArn = samlProviderArn;
            return this;
        }

        public final String getAssertionEncryptionMode() {
            return assertionEncryptionMode;
        }

        public final void setAssertionEncryptionMode(String assertionEncryptionMode) {
            this.assertionEncryptionMode = assertionEncryptionMode;
        }

        @Override
        public final Builder assertionEncryptionMode(String assertionEncryptionMode) {
            this.assertionEncryptionMode = assertionEncryptionMode;
            return this;
        }

        @Override
        public final Builder assertionEncryptionMode(AssertionEncryptionModeType assertionEncryptionMode) {
            this.assertionEncryptionMode(assertionEncryptionMode == null ? null : assertionEncryptionMode.toString());
            return this;
        }

        public final String getAddPrivateKey() {
            return addPrivateKey;
        }

        public final void setAddPrivateKey(String addPrivateKey) {
            this.addPrivateKey = addPrivateKey;
        }

        @Override
        public final Builder addPrivateKey(String addPrivateKey) {
            this.addPrivateKey = addPrivateKey;
            return this;
        }

        public final String getRemovePrivateKey() {
            return removePrivateKey;
        }

        public final void setRemovePrivateKey(String removePrivateKey) {
            this.removePrivateKey = removePrivateKey;
        }

        @Override
        public final Builder removePrivateKey(String removePrivateKey) {
            this.removePrivateKey = removePrivateKey;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSamlProviderRequest build() {
            return new UpdateSamlProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
