/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Elastic Fabric Adapters for the instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EfaInfo implements SdkPojo, Serializable, ToCopyableBuilder<EfaInfo.Builder, EfaInfo> {
    private static final SdkField<Integer> MAXIMUM_EFA_INTERFACES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumEfaInterfaces")
            .getter(getter(EfaInfo::maximumEfaInterfaces))
            .setter(setter(Builder::maximumEfaInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumEfaInterfaces")
                    .unmarshallLocationName("maximumEfaInterfaces").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_EFA_INTERFACES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maximumEfaInterfaces;

    private EfaInfo(BuilderImpl builder) {
        this.maximumEfaInterfaces = builder.maximumEfaInterfaces;
    }

    /**
     * <p>
     * The maximum number of Elastic Fabric Adapters for the instance type.
     * </p>
     * 
     * @return The maximum number of Elastic Fabric Adapters for the instance type.
     */
    public final Integer maximumEfaInterfaces() {
        return maximumEfaInterfaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumEfaInterfaces());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EfaInfo)) {
            return false;
        }
        EfaInfo other = (EfaInfo) obj;
        return Objects.equals(maximumEfaInterfaces(), other.maximumEfaInterfaces());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EfaInfo").add("MaximumEfaInterfaces", maximumEfaInterfaces()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaximumEfaInterfaces":
            return Optional.ofNullable(clazz.cast(maximumEfaInterfaces()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaximumEfaInterfaces", MAXIMUM_EFA_INTERFACES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EfaInfo, T> g) {
        return obj -> g.apply((EfaInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EfaInfo> {
        /**
         * <p>
         * The maximum number of Elastic Fabric Adapters for the instance type.
         * </p>
         * 
         * @param maximumEfaInterfaces
         *        The maximum number of Elastic Fabric Adapters for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumEfaInterfaces(Integer maximumEfaInterfaces);
    }

    static final class BuilderImpl implements Builder {
        private Integer maximumEfaInterfaces;

        private BuilderImpl() {
        }

        private BuilderImpl(EfaInfo model) {
            maximumEfaInterfaces(model.maximumEfaInterfaces);
        }

        public final Integer getMaximumEfaInterfaces() {
            return maximumEfaInterfaces;
        }

        public final void setMaximumEfaInterfaces(Integer maximumEfaInterfaces) {
            this.maximumEfaInterfaces = maximumEfaInterfaces;
        }

        @Override
        public final Builder maximumEfaInterfaces(Integer maximumEfaInterfaces) {
            this.maximumEfaInterfaces = maximumEfaInterfaces;
            return this;
        }

        @Override
        public EfaInfo build() {
            return new EfaInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
