/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Autonomous System Number (ASN) and BYOIP CIDR association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Byoasn implements SdkPojo, Serializable, ToCopyableBuilder<Byoasn.Builder, Byoasn> {
    private static final SdkField<String> ASN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Asn")
            .getter(getter(Byoasn::asn))
            .setter(setter(Builder::asn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Asn").unmarshallLocationName("asn")
                    .build()).build();

    private static final SdkField<String> IPAM_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamId")
            .getter(getter(Byoasn::ipamId))
            .setter(setter(Builder::ipamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamId")
                    .unmarshallLocationName("ipamId").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage")
            .getter(getter(Byoasn::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage")
                    .unmarshallLocationName("statusMessage").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(Byoasn::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASN_FIELD, IPAM_ID_FIELD,
            STATUS_MESSAGE_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String asn;

    private final String ipamId;

    private final String statusMessage;

    private final String state;

    private Byoasn(BuilderImpl builder) {
        this.asn = builder.asn;
        this.ipamId = builder.ipamId;
        this.statusMessage = builder.statusMessage;
        this.state = builder.state;
    }

    /**
     * <p>
     * A public 2-byte or 4-byte ASN.
     * </p>
     * 
     * @return A public 2-byte or 4-byte ASN.
     */
    public final String asn() {
        return asn;
    }

    /**
     * <p>
     * An IPAM ID.
     * </p>
     * 
     * @return An IPAM ID.
     */
    public final String ipamId() {
        return ipamId;
    }

    /**
     * <p>
     * The status message.
     * </p>
     * 
     * @return The status message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The provisioning state of the BYOASN.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AsnState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The provisioning state of the BYOASN.
     * @see AsnState
     */
    public final AsnState state() {
        return AsnState.fromValue(state);
    }

    /**
     * <p>
     * The provisioning state of the BYOASN.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AsnState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The provisioning state of the BYOASN.
     * @see AsnState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(asn());
        hashCode = 31 * hashCode + Objects.hashCode(ipamId());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Byoasn)) {
            return false;
        }
        Byoasn other = (Byoasn) obj;
        return Objects.equals(asn(), other.asn()) && Objects.equals(ipamId(), other.ipamId())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Byoasn").add("Asn", asn()).add("IpamId", ipamId()).add("StatusMessage", statusMessage())
                .add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Asn":
            return Optional.ofNullable(clazz.cast(asn()));
        case "IpamId":
            return Optional.ofNullable(clazz.cast(ipamId()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Asn", ASN_FIELD);
        map.put("IpamId", IPAM_ID_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Byoasn, T> g) {
        return obj -> g.apply((Byoasn) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Byoasn> {
        /**
         * <p>
         * A public 2-byte or 4-byte ASN.
         * </p>
         * 
         * @param asn
         *        A public 2-byte or 4-byte ASN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asn(String asn);

        /**
         * <p>
         * An IPAM ID.
         * </p>
         * 
         * @param ipamId
         *        An IPAM ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamId(String ipamId);

        /**
         * <p>
         * The status message.
         * </p>
         * 
         * @param statusMessage
         *        The status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The provisioning state of the BYOASN.
         * </p>
         * 
         * @param state
         *        The provisioning state of the BYOASN.
         * @see AsnState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AsnState
         */
        Builder state(String state);

        /**
         * <p>
         * The provisioning state of the BYOASN.
         * </p>
         * 
         * @param state
         *        The provisioning state of the BYOASN.
         * @see AsnState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AsnState
         */
        Builder state(AsnState state);
    }

    static final class BuilderImpl implements Builder {
        private String asn;

        private String ipamId;

        private String statusMessage;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(Byoasn model) {
            asn(model.asn);
            ipamId(model.ipamId);
            statusMessage(model.statusMessage);
            state(model.state);
        }

        public final String getAsn() {
            return asn;
        }

        public final void setAsn(String asn) {
            this.asn = asn;
        }

        @Override
        public final Builder asn(String asn) {
            this.asn = asn;
            return this;
        }

        public final String getIpamId() {
            return ipamId;
        }

        public final void setIpamId(String ipamId) {
            this.ipamId = ipamId;
        }

        @Override
        public final Builder ipamId(String ipamId) {
            this.ipamId = ipamId;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AsnState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public Byoasn build() {
            return new Byoasn(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
