/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.EnumFilter;
import com.chargebee.filters.StringFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CouponCode
extends Resource<CouponCode> {
    public CouponCode(String jsonStr) {
        super(jsonStr);
    }

    public CouponCode(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String code() {
        return this.reqString("code");
    }

    public Status status() {
        return this.reqEnum("status", Status.class);
    }

    public String couponId() {
        return this.reqString("coupon_id");
    }

    public String couponSetId() {
        return this.reqString("coupon_set_id");
    }

    public String couponSetName() {
        return this.reqString("coupon_set_name");
    }

    @Deprecated
    public static CreateRequest create() {
        String uri = CouponCode.uri("coupon_codes");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) {
        String uri = CouponCode.uri("coupon_codes", CouponCode.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static CouponCodeListRequest list() {
        String uri = CouponCode.uri("coupon_codes");
        return new CouponCodeListRequest(uri);
    }

    public static Request archive(String id) {
        String uri = CouponCode.uri("coupon_codes", CouponCode.nullCheck(id), "archive");
        return new Request(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CouponCodeListRequest
    extends ListRequest<CouponCodeListRequest> {
        private CouponCodeListRequest(String uri) {
            super(uri);
        }

        public StringFilter<CouponCodeListRequest> code() {
            return new StringFilter<CouponCodeListRequest>("code", this).supportsMultiOperators(true);
        }

        public StringFilter<CouponCodeListRequest> couponId() {
            return new StringFilter<CouponCodeListRequest>("coupon_id", this).supportsMultiOperators(true);
        }

        public StringFilter<CouponCodeListRequest> couponSetName() {
            return new StringFilter<CouponCodeListRequest>("coupon_set_name", this);
        }

        public EnumFilter<Status, CouponCodeListRequest> status() {
            return new EnumFilter<Status, CouponCodeListRequest>("status", this);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest couponId(String couponId) {
            this.params.add("coupon_id", couponId);
            return this;
        }

        public CreateRequest couponSetName(String couponSetName) {
            this.params.add("coupon_set_name", couponSetName);
            return this;
        }

        public CreateRequest code(String code) {
            this.params.add("code", code);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NOT_REDEEMED,
        REDEEMED,
        ARCHIVED,
        _UNKNOWN;

    }
}

