/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.TimestampFilter;
import com.chargebee.filters.enums.SortOrder;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.EntityType;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Comment
extends Resource<Comment> {
    public Comment(String jsonStr) {
        super(jsonStr);
    }

    public Comment(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.reqString("id");
    }

    public EntityType entityType() {
        return this.reqEnum("entity_type", EntityType.class);
    }

    public String addedBy() {
        return this.optString("added_by");
    }

    public String notes() {
        return this.reqString("notes");
    }

    public Timestamp createdAt() {
        return this.reqTimestamp("created_at");
    }

    public Type type() {
        return this.reqEnum("type", Type.class);
    }

    public String entityId() {
        return this.reqString("entity_id");
    }

    public static CreateRequest create() {
        String uri = Comment.uri("comments");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static Request retrieve(String id) {
        String uri = Comment.uri("comments", Comment.nullCheck(id));
        return new Request(HttpUtil.Method.GET, uri);
    }

    public static CommentListRequest list() {
        String uri = Comment.uri("comments");
        return new CommentListRequest(uri);
    }

    public static Request delete(String id) {
        String uri = Comment.uri("comments", Comment.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CommentListRequest
    extends ListRequest<CommentListRequest> {
        private CommentListRequest(String uri) {
            super(uri);
        }

        public CommentListRequest entityType(EntityType entityType) {
            this.params.addOpt("entity_type", (Object)entityType);
            return this;
        }

        public CommentListRequest entityId(String entityId) {
            this.params.addOpt("entity_id", entityId);
            return this;
        }

        public TimestampFilter<CommentListRequest> createdAt() {
            return new TimestampFilter<CommentListRequest>("created_at", this);
        }

        public CommentListRequest sortByCreatedAt(SortOrder order) {
            this.params.addOpt("sort_by[" + order.name().toLowerCase() + "]", "created_at");
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest entityType(EntityType entityType) {
            this.params.add("entity_type", (Object)entityType);
            return this;
        }

        public CreateRequest entityId(String entityId) {
            this.params.add("entity_id", entityId);
            return this;
        }

        public CreateRequest notes(String notes) {
            this.params.add("notes", notes);
            return this;
        }

        public CreateRequest addedBy(String addedBy) {
            this.params.addOpt("added_by", addedBy);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        USER,
        SYSTEM,
        _UNKNOWN;

    }
}

