/*
 * Decompiled with CFR 0.152.
 */
package difflib;

import difflib.Chunk;
import difflib.Delta;
import difflib.PatchFailedException;
import java.util.List;

public class DeleteDelta<T>
extends Delta<T> {
    public DeleteDelta(Chunk<T> original, Chunk<T> revised) {
        super(original, revised);
    }

    @Override
    public void applyTo(List<T> target) throws PatchFailedException {
        this.verify(target);
        int position = this.getOriginal().getPosition();
        int size = this.getOriginal().size();
        int i = 0;
        while (i < size) {
            target.remove(position);
            ++i;
        }
    }

    @Override
    public void restore(List<T> target) {
        int position = this.getRevised().getPosition();
        List lines = this.getOriginal().getLines();
        int i = 0;
        while (i < lines.size()) {
            target.add(position + i, lines.get(i));
            ++i;
        }
    }

    @Override
    public Delta.TYPE getType() {
        return Delta.TYPE.DELETE;
    }

    @Override
    public void verify(List<T> target) throws PatchFailedException {
        this.getOriginal().verify(target);
    }

    public String toString() {
        return "[DeleteDelta, position: " + this.getOriginal().getPosition() + ", lines: " + this.getOriginal().getLines() + "]";
    }
}

