/*
 * Decompiled with CFR 0.152.
 */
package difflib;

import difflib.Chunk;
import difflib.Delta;
import difflib.PatchFailedException;
import java.util.List;

public class ChangeDelta<T>
extends Delta<T> {
    public ChangeDelta(Chunk<T> original, Chunk<T> revised) {
        super(original, revised);
    }

    @Override
    public void applyTo(List<T> target) throws PatchFailedException {
        this.verify(target);
        int position = this.getOriginal().getPosition();
        int size = this.getOriginal().size();
        int i = 0;
        while (i < size) {
            target.remove(position);
            ++i;
        }
        i = 0;
        for (Object line : this.getRevised().getLines()) {
            target.add(position + i, line);
            ++i;
        }
    }

    @Override
    public void restore(List<T> target) {
        int position = this.getRevised().getPosition();
        int size = this.getRevised().size();
        int i = 0;
        while (i < size) {
            target.remove(position);
            ++i;
        }
        i = 0;
        for (Object line : this.getOriginal().getLines()) {
            target.add(position + i, line);
            ++i;
        }
    }

    @Override
    public void verify(List<T> target) throws PatchFailedException {
        this.getOriginal().verify(target);
        if (this.getOriginal().getPosition() > target.size()) {
            throw new PatchFailedException("Incorrect patch for delta: delta original position > target size");
        }
    }

    public String toString() {
        return "[ChangeDelta, position: " + this.getOriginal().getPosition() + ", lines: " + this.getOriginal().getLines() + " to " + this.getRevised().getLines() + "]";
    }

    @Override
    public Delta.TYPE getType() {
        return Delta.TYPE.CHANGE;
    }
}

