/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.shared.analyzing;

import com.sap.sailing.domain.abstractlog.AbstractLog;
import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.BaseLogAnalyzer;
import com.sap.sailing.domain.abstractlog.shared.events.RegisterCompetitorEvent;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.abstractlog.NotRevokableException;
import com.sap.sse.common.Util;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CompetitorDeregistrator<LogT extends AbstractLog<EventT, VisitorT>, EventT extends AbstractLogEvent<VisitorT>, VisitorT>
extends BaseLogAnalyzer<LogT, EventT, VisitorT, Set<EventT>> {
    private static final Logger logger = Logger.getLogger(CompetitorDeregistrator.class.getName());
    protected final Iterable<Competitor> competitorsToDeregister;
    private AbstractLogEventAuthor eventAuthor;

    public CompetitorDeregistrator(LogT log, Iterable<Competitor> competitorsToDeregister, AbstractLogEventAuthor eventAuthor) {
        super(log);
        this.competitorsToDeregister = competitorsToDeregister;
        this.eventAuthor = eventAuthor;
    }

    @Override
    protected Set<EventT> performAnalysis() {
        HashSet<AbstractLogEvent> result = new HashSet<AbstractLogEvent>();
        HashSet competitorSet = new HashSet();
        Util.addAll(this.competitorsToDeregister, competitorSet);
        for (AbstractLogEvent event : this.log.getUnrevokedEventsDescending()) {
            RegisterCompetitorEvent registerEvent;
            if (!(event instanceof RegisterCompetitorEvent) || !competitorSet.contains((registerEvent = (RegisterCompetitorEvent)event).getCompetitor())) continue;
            result.add(event);
        }
        return result;
    }

    public void deregister(Set<EventT> competitorRegistrationEvents) {
        for (AbstractLogEvent event : competitorRegistrationEvents) {
            try {
                this.log.revokeEvent(this.eventAuthor, event, "unregistering competitor because no longer selected for registration");
            }
            catch (NotRevokableException e) {
                logger.log(Level.WARNING, "could not unregister competitor by adding RevokeEvent", e);
            }
        }
    }
}

