/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.tracking.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.race.RaceLogEventData;
import com.sap.sailing.domain.abstractlog.race.RaceLogEventVisitor;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogEventDataImpl;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogRegisterCompetitorEvent;
import com.sap.sailing.domain.abstractlog.shared.events.impl.BaseRegisterCompetitorEventImpl;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sse.common.TimePoint;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class RaceLogRegisterCompetitorEventImpl
extends BaseRegisterCompetitorEventImpl<RaceLogEventVisitor>
implements RaceLogRegisterCompetitorEvent {
    private static final long serialVersionUID = -5114645637316367845L;
    private final RaceLogEventData raceLogEventData;
    private final Boat boat;

    public RaceLogRegisterCompetitorEventImpl(TimePoint createdAt, TimePoint logicalTimePoint, AbstractLogEventAuthor author, Serializable id, int passId, CompetitorWithBoat competitor) throws IllegalArgumentException {
        super(createdAt, logicalTimePoint, author, id, competitor);
        this.raceLogEventData = new RaceLogEventDataImpl(null, passId);
        RaceLogRegisterCompetitorEventImpl.checkBoat(competitor.getBoat());
        this.boat = competitor.getBoat();
    }

    public RaceLogRegisterCompetitorEventImpl(TimePoint createdAt, TimePoint logicalTimePoint, AbstractLogEventAuthor author, Serializable id, int passId, Competitor competitor, Boat boat) throws IllegalArgumentException {
        super(createdAt, logicalTimePoint, author, id, competitor);
        this.raceLogEventData = new RaceLogEventDataImpl(null, passId);
        RaceLogRegisterCompetitorEventImpl.checkBoat(boat);
        this.boat = boat;
    }

    public RaceLogRegisterCompetitorEventImpl(TimePoint logicalTimePoint, AbstractLogEventAuthor author, int passId, CompetitorWithBoat competitor) throws IllegalArgumentException {
        this(RaceLogRegisterCompetitorEventImpl.now(), logicalTimePoint, author, RaceLogRegisterCompetitorEventImpl.randId(), passId, competitor);
    }

    public RaceLogRegisterCompetitorEventImpl(TimePoint logicalTimePoint, AbstractLogEventAuthor author, int passId, Competitor competitor, Boat boat) throws IllegalArgumentException {
        this(RaceLogRegisterCompetitorEventImpl.now(), logicalTimePoint, author, RaceLogRegisterCompetitorEventImpl.randId(), passId, competitor, boat);
    }

    @Override
    public int getPassId() {
        return this.raceLogEventData.getPassId();
    }

    public List<Competitor> getInvolvedCompetitors() {
        return Collections.singletonList(this.getCompetitor());
    }

    @Override
    public String toString() {
        return this.raceLogEventData.toString();
    }

    @Override
    public void accept(RaceLogEventVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Boat getBoat() {
        return this.boat;
    }

    private static void checkBoat(Boat boat) throws IllegalArgumentException {
        if (boat == null) {
            throw new IllegalArgumentException("Boat must not be null");
        }
    }

    @Override
    public String getShortInfo() {
        return "competitor: " + this.getCompetitor().toString() + " with boat " + this.getBoat().toString();
    }
}

