/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.analyzing.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogDependentStartTimeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogStartTimeEvent;
import com.sap.sailing.domain.abstractlog.race.SimpleRaceLogIdentifier;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.DependentStartTimeResolver;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogAnalyzer;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.StartTimeFinderResult;
import com.sap.sse.common.TimePoint;
import java.util.ArrayList;

public class StartTimeFinder
extends RaceLogAnalyzer<StartTimeFinderResult> {
    private final RaceLogResolver resolver;

    public StartTimeFinder(RaceLogResolver resolver, RaceLog raceLog) {
        super(raceLog);
        this.resolver = resolver;
    }

    @Override
    protected StartTimeFinderResult performAnalysis() {
        return this.analyze(new ArrayList<SimpleRaceLogIdentifier>());
    }

    public StartTimeFinderResult analyze(Iterable<SimpleRaceLogIdentifier> dependingOnRaces) {
        ((RaceLog)this.log).lockForRead();
        try {
            for (RaceLogEvent event : this.getPassEventsDescending()) {
                if (event instanceof RaceLogStartTimeEvent) {
                    RaceLogStartTimeEvent startTimeEvent = (RaceLogStartTimeEvent)event;
                    TimePoint startTime = startTimeEvent.getStartTime();
                    StartTimeFinderResult startTimeFinderResult = new StartTimeFinderResult(dependingOnRaces, startTime, null, startTimeEvent.getCourseAreaId());
                    return startTimeFinderResult;
                }
                if (!(event instanceof RaceLogDependentStartTimeEvent)) continue;
                DependentStartTimeResolver dependentStartTimeResolver = new DependentStartTimeResolver(this.resolver);
                StartTimeFinderResult startTimeFinderResult = dependentStartTimeResolver.internalResolve((RaceLogDependentStartTimeEvent)event, dependingOnRaces);
                return startTimeFinderResult;
            }
            StartTimeFinderResult startTimeFinderResult = new StartTimeFinderResult(dependingOnRaces, null, null, StartTimeFinderResult.ResolutionFailed.NO_START_TIME_SET, null);
            return startTimeFinderResult;
        }
        finally {
            ((RaceLog)this.log).unlockAfterRead();
        }
    }
}

