/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.orc;

import com.sap.sailing.domain.abstractlog.orc.RaceLogORCLegDataEvent;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCLegDataEventFinder;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogAnalyzer;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveLeg;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveLegTypes;
import com.sap.sailing.domain.common.orc.impl.ORCPerformanceCurveLegImpl;
import com.sap.sse.common.Distance;
import java.util.HashMap;
import java.util.Map;

public class RaceLogORCLegDataAnalyzer
extends RaceLogAnalyzer<Map<Integer, ORCPerformanceCurveLeg>> {
    public RaceLogORCLegDataAnalyzer(RaceLog raceLog) {
        super(raceLog);
    }

    @Override
    protected Map<Integer, ORCPerformanceCurveLeg> performAnalysis() {
        HashMap<Integer, ORCPerformanceCurveLeg> result = new HashMap<Integer, ORCPerformanceCurveLeg>();
        for (Map.Entry entry : ((Map)new RaceLogORCLegDataEventFinder((RaceLog)this.getLog()).analyze()).entrySet()) {
            assert (((Integer)entry.getKey()).intValue() == ((RaceLogORCLegDataEvent)entry.getValue()).getOneBasedLegNumber());
            RaceLogORCLegDataEvent legDataEvent = (RaceLogORCLegDataEvent)entry.getValue();
            ORCPerformanceCurveLeg leg = RaceLogORCLegDataAnalyzer.createORCPerformanceCurveLeg(legDataEvent);
            result.put(legDataEvent.getOneBasedLegNumber(), leg);
        }
        return result;
    }

    public static ORCPerformanceCurveLeg createORCPerformanceCurveLeg(RaceLogORCLegDataEvent legDataEvent) {
        Distance length = legDataEvent.getLength();
        ORCPerformanceCurveLegTypes type = legDataEvent.getType();
        ORCPerformanceCurveLegImpl leg = type == ORCPerformanceCurveLegTypes.TWA ? new ORCPerformanceCurveLegImpl(length, legDataEvent.getTwa()) : new ORCPerformanceCurveLegImpl(length, legDataEvent.getType());
        return leg;
    }
}

