/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.spectator;

import com.google.gwt.dom.client.Style;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.common.authentication.FixedSailingAuthentication;
import com.sap.sailing.gwt.common.authentication.SAPSailingHeaderWithAuthentication;
import com.sap.sailing.gwt.settings.client.spectator.SpectatorContextDefinition;
import com.sap.sailing.gwt.settings.client.spectator.SpectatorSettings;
import com.sap.sailing.gwt.ui.client.AbstractSailingReadEntryPoint;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.panels.SimpleWelcomeWidget;
import com.sap.sailing.gwt.ui.client.shared.panels.WelcomeWidget;
import com.sap.sailing.gwt.ui.spectator.LeaderboardGroupOverviewPanel;
import com.sap.sailing.gwt.ui.spectator.LeaderboardGroupPanel;
import com.sap.sse.common.settings.generic.GenericSerializableSettings;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.settings.SettingsToUrlSerializer;
import com.sap.sse.gwt.shared.ClientConfiguration;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import com.sap.sse.security.ui.client.premium.PaywallResolverImpl;

public class SpectatorEntryPoint
extends AbstractSailingReadEntryPoint {
    protected void doOnModuleLoad() {
        super.doOnModuleLoad();
        SpectatorContextDefinition contextDefinition = (SpectatorContextDefinition)new SettingsToUrlSerializer().deserializeFromCurrentLocation((GenericSerializableSettings)new SpectatorContextDefinition());
        String groupNameParam = contextDefinition.getLeaderboardGroupName();
        String groupIdParam = contextDefinition.getLeaderboardGroupId();
        SpectatorSettings settings = (SpectatorSettings)new SettingsToUrlSerializer().deserializeFromCurrentLocation((GenericSerializableSettings)new SpectatorSettings());
        RootPanel rootPanel = RootPanel.get();
        FlowPanel groupAndFeedbackPanel = new FlowPanel();
        boolean embedded = settings.isEmbedded();
        if (groupIdParam == null && groupNameParam == null) {
            FlowPanel groupOverviewPanel = new FlowPanel();
            groupOverviewPanel.addStyleName("contentOuterPanel");
            LeaderboardGroupOverviewPanel leaderboardGroupOverviewPanel = new LeaderboardGroupOverviewPanel(this.getSailingService(), (ErrorReporter)this, (StringMessages)this.getStringMessages(), settings.isShowRaceDetails());
            groupOverviewPanel.add((Widget)leaderboardGroupOverviewPanel);
            this.setHeader(null, embedded);
            rootPanel.add((Widget)groupOverviewPanel);
        } else {
            LeaderboardGroupPanel groupPanel = new LeaderboardGroupPanel(this.getSailingService(), (StringMessages)this.getStringMessages(), (ErrorReporter)this, groupIdParam, groupNameParam, leaderboardGroupName -> this.setHeader(leaderboardGroupName, embedded), settings.getViewMode(), embedded, settings.isShowRaceDetails(), settings.isCanReplayDuringLiveRaces(), settings.isShowMapControls());
            groupAndFeedbackPanel.add((Widget)groupPanel);
            if (!embedded) {
                groupPanel.setWelcomeWidget((WelcomeWidget)new SimpleWelcomeWidget(((StringMessages)this.getStringMessages()).welcomeToSailingAnalytics(), ((StringMessages)this.getStringMessages()).welcomeToSailingAnalyticsBody()));
                if (ClientConfiguration.getInstance().isBrandingActive()) {
                    SimplePanel feedbackPanel = new SimplePanel();
                    feedbackPanel.getElement().getStyle().setProperty("clear", "right");
                    feedbackPanel.addStyleName("feedbackPanel");
                    Anchor feedbackLink = new Anchor(new SafeHtmlBuilder().appendHtmlConstant("<img src=\"/gwt/images/feedbackPanel-bg.png\"/>").toSafeHtml());
                    feedbackLink.setHref("mailto:support%40sapsailing.com?subject=[SAP Sailing] Feedback");
                    feedbackPanel.add((Widget)feedbackLink);
                    groupAndFeedbackPanel.add((Widget)feedbackPanel);
                }
            }
            rootPanel.add((Widget)groupAndFeedbackPanel);
        }
    }

    private void setHeader(String groupNameParam, boolean embedded) {
        if (!embedded) {
            String title = groupNameParam != null ? groupNameParam : ((StringMessages)this.getStringMessages()).overview();
            Window.setTitle((String)title);
            SAPSailingHeaderWithAuthentication header = this.getHeader(title);
            RootPanel.get().add((Widget)header);
        } else {
            RootPanel.getBodyElement().getStyle().setPadding(0.0, Style.Unit.PX);
            RootPanel.getBodyElement().getStyle().setPaddingTop(20.0, Style.Unit.PX);
        }
    }

    private SAPSailingHeaderWithAuthentication getHeader(String title) {
        SAPSailingHeaderWithAuthentication header = new SAPSailingHeaderWithAuthentication(title);
        PaywallResolverImpl paywallResolver = new PaywallResolverImpl(this.getUserService(), this.getSubscriptionServiceFactory());
        new FixedSailingAuthentication(this.getUserService(), (PaywallResolver)paywallResolver, header.getAuthenticationMenuView());
        header.getElement().getStyle().setPosition(Style.Position.FIXED);
        header.getElement().getStyle().setTop(0.0, Style.Unit.PX);
        header.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
        return header;
    }
}

