/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.Point;
import com.google.gwt.maps.client.events.click.ClickMapHandler;
import com.google.gwt.maps.client.events.dblclick.DblClickMapHandler;
import com.google.gwt.maps.client.geometrylib.SphericalUtils;
import com.google.gwt.maps.client.overlays.Marker;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.simulator.racemap.FullCanvasOverlay;
import java.util.logging.Logger;

public class RaceCourseCanvasOverlay
extends FullCanvasOverlay {
    private String racecourseColor = "White";
    private double racecourseBuoySize = 5.0;
    private char mode;
    public char raceCourseDirection;
    private LatLng startPoint;
    private LatLng endPoint;
    private Marker startMarker;
    private Marker endMarker;
    private HandlerRegistration registeredRaceCourseMouseMoveHandler;
    private static Logger logger = Logger.getLogger(RaceCourseCanvasOverlay.class.getName());

    public RaceCourseCanvasOverlay(MapWidget map, int zIndex, char mode, CoordinateSystem coordinateSystem) {
        super(map, zIndex, coordinateSystem);
        this.mode = mode;
        this.startPoint = null;
        this.endPoint = null;
        this.startMarker = null;
        this.endMarker = null;
        this.getCanvas().getElement().setClassName("raceCourse");
        if (this.mode == 'f') {
            map.addClickHandler((ClickMapHandler)new /* Unavailable Anonymous Inner Class!! */);
            map.addDblClickHandler((DblClickMapHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void reset() {
        this.startPoint = null;
        this.endPoint = null;
        if (this.startMarker != null) {
            this.startMarker.setMap(null);
            this.startMarker = null;
        }
        if (this.endMarker != null) {
            this.endMarker.setMap(null);
            this.endMarker = null;
        }
        this.setCanvasSettings();
    }

    public boolean isCourseSet() {
        return this.startPoint != null && this.endPoint != null;
    }

    public void setStartEndPoint(LatLng startPoint, LatLng endPoint) {
        double zoomLevel = this.map.getZoom();
        this.racecourseBuoySize = 1.0 + 4.0 * (zoomLevel - 10.0) / 4.0;
        this.setStartPoint(startPoint);
        this.setEndPoint(endPoint);
    }

    private void setStartPoint(LatLng startPoint) {
        this.startPoint = startPoint;
    }

    private void setEndPoint(LatLng endPoint) {
        this.endPoint = endPoint;
    }

    protected void draw() {
        if (this.getMapProjection() != null && this.startPoint != null && this.endPoint != null) {
            Point point;
            this.setCanvasSettings();
            this.setStartEndPoint(this.startPoint, this.endPoint);
            if (this.startPoint != null) {
                point = this.getMapProjection().fromLatLngToDivPixel(this.startPoint);
                if (this.racecourseBuoySize > 0.0) {
                    this.drawCircleWithText(point.getX() - this.getWidgetPosLeft(), point.getY() - this.getWidgetPosTop(), this.racecourseBuoySize, this.racecourseColor, "Start");
                }
                if (this.startMarker != null) {
                    this.startMarker.setPosition(this.startPoint);
                }
            }
            if (this.endPoint != null) {
                point = this.getMapProjection().fromLatLngToDivPixel(this.endPoint);
                if (this.racecourseBuoySize > 0.0) {
                    this.drawCircleWithText(point.getX() - this.getWidgetPosLeft(), point.getY() - this.getWidgetPosTop(), this.racecourseBuoySize, this.racecourseColor, "End");
                }
                if (this.endMarker != null) {
                    this.endMarker.setPosition(this.endPoint);
                }
            }
            this.drawLine(this.endPoint, this.racecourseColor);
        }
    }

    private void refreshLine(LatLng currentPoint, String color) {
        this.setCanvasSettings();
        this.drawLine(currentPoint, color);
    }

    private void drawLine(LatLng currentPoint, String color) {
        if (this.startPoint != null) {
            Point s = this.getMapProjection().fromLatLngToDivPixel(this.startPoint);
            Point e = this.getMapProjection().fromLatLngToDivPixel(currentPoint);
            Context2d context2d = this.canvas.getContext2d();
            context2d.setGlobalAlpha((double)0.4f);
            this.drawLine(s.getX() - this.getWidgetPosLeft(), s.getY() - this.getWidgetPosTop(), e.getX() - this.getWidgetPosLeft(), e.getY() - this.getWidgetPosTop(), 2.0, color);
            context2d.setGlobalAlpha(1.0);
            double distanceInNmi = SphericalUtils.computeDistanceBetween((LatLng)this.startPoint, (LatLng)currentPoint) / 1852.0;
            this.canvas.setTitle("Distance (nmi)  " + NumberFormat.getFormat((String)"0.00").format(distanceInNmi));
        }
    }

    private void center() {
        double cLat = (this.startPoint.getLatitude() + (this.endPoint.getLatitude() - this.startPoint.getLatitude()) % 180.0 / 2.0 + 90.0) % 180.0 - 90.0;
        double cLon = (this.startPoint.getLongitude() + (this.endPoint.getLongitude() - this.startPoint.getLongitude()) % 360.0 / 2.0 + 180.0) % 360.0 - 180.0;
        LatLng centerPoint = LatLng.newInstance((double)cLat, (double)cLon);
        this.getMap().panTo(centerPoint);
    }

    public LatLng getStartPoint() {
        return this.startPoint;
    }

    public LatLng getEndPoint() {
        return this.endPoint;
    }

    static /* synthetic */ LatLng access$0(RaceCourseCanvasOverlay raceCourseCanvasOverlay) {
        return raceCourseCanvasOverlay.startPoint;
    }

    static /* synthetic */ void access$1(RaceCourseCanvasOverlay raceCourseCanvasOverlay, double d, double d2, String string) {
        raceCourseCanvasOverlay.drawPointWithText(d, d2, string);
    }

    static /* synthetic */ void access$2(RaceCourseCanvasOverlay raceCourseCanvasOverlay, LatLng latLng, String string) {
        raceCourseCanvasOverlay.refreshLine(latLng, string);
    }

    static /* synthetic */ void access$3(RaceCourseCanvasOverlay raceCourseCanvasOverlay, LatLng latLng) {
        raceCourseCanvasOverlay.startPoint = latLng;
    }

    static /* synthetic */ Logger access$4() {
        return logger;
    }

    static /* synthetic */ void access$5(RaceCourseCanvasOverlay raceCourseCanvasOverlay, LatLng latLng) {
        raceCourseCanvasOverlay.setStartPoint(latLng);
    }

    static /* synthetic */ void access$6(RaceCourseCanvasOverlay raceCourseCanvasOverlay, HandlerRegistration handlerRegistration) {
        raceCourseCanvasOverlay.registeredRaceCourseMouseMoveHandler = handlerRegistration;
    }

    static /* synthetic */ boolean access$7(RaceCourseCanvasOverlay raceCourseCanvasOverlay) {
        return raceCourseCanvasOverlay.isSelected;
    }

    static /* synthetic */ void access$8(RaceCourseCanvasOverlay raceCourseCanvasOverlay, LatLng latLng) {
        raceCourseCanvasOverlay.endPoint = latLng;
    }

    static /* synthetic */ LatLng access$9(RaceCourseCanvasOverlay raceCourseCanvasOverlay) {
        return raceCourseCanvasOverlay.endPoint;
    }

    static /* synthetic */ void access$10(RaceCourseCanvasOverlay raceCourseCanvasOverlay, LatLng latLng) {
        raceCourseCanvasOverlay.setEndPoint(latLng);
    }

    static /* synthetic */ void access$11(RaceCourseCanvasOverlay raceCourseCanvasOverlay) {
        raceCourseCanvasOverlay.center();
    }

    static /* synthetic */ HandlerRegistration access$12(RaceCourseCanvasOverlay raceCourseCanvasOverlay) {
        return raceCourseCanvasOverlay.registeredRaceCourseMouseMoveHandler;
    }
}

