/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared;

import com.sap.sailing.gwt.ui.shared.EventBaseDTO;
import com.sap.sse.security.shared.dto.NamedDTO;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class RemoteSailingServerReferenceDTO
extends NamedDTO {
    private static final long serialVersionUID = -4209262742778693873L;
    private String url;
    private Iterable<EventBaseDTO> events;
    private boolean include;
    private List<UUID> selectedEvents;
    private String lastErrorMessage;

    @Deprecated
    RemoteSailingServerReferenceDTO() {
    }

    public RemoteSailingServerReferenceDTO(String name, String url) {
        this(name, url, true, Collections.emptyList(), Collections.emptyList());
    }

    public RemoteSailingServerReferenceDTO(String name, String url, boolean include, List<UUID> selectedEventIds, Iterable<EventBaseDTO> events) {
        this(name, url, include, selectedEventIds, events, null);
        assert (events != null);
    }

    public RemoteSailingServerReferenceDTO(String name, String url, boolean include, List<UUID> selectedEventIds, Iterable<EventBaseDTO> events, String lastErrorMessage) {
        super(name);
        assert (selectedEventIds != null);
        this.url = url;
        this.events = events;
        this.include = include;
        this.selectedEvents = selectedEventIds;
        this.lastErrorMessage = lastErrorMessage;
    }

    public RemoteSailingServerReferenceDTO(String name, String url, boolean include, String lastErrorMessage) {
        this(name, url, include, Collections.emptyList(), Collections.emptySet(), lastErrorMessage);
    }

    public String getUrl() {
        return this.url;
    }

    public Iterable<EventBaseDTO> getEvents() {
        return this.events;
    }

    public Iterable<EventBaseDTO> getInclusiveEvents() {
        return StreamSupport.stream(this.events.spliterator(), false).filter(element -> this.include ? this.selectedEvents.contains(element.getId()) : !this.selectedEvents.contains(element.getId())).collect(Collectors.toList());
    }

    public boolean isInclude() {
        return this.include;
    }

    public void setInclude(boolean include) {
        this.include = include;
    }

    public List<UUID> getSelectedEvents() {
        return this.selectedEvents;
    }

    public void updateSelectedEvents(List<UUID> selectedEvents) {
        this.selectedEvents.clear();
        this.selectedEvents.addAll(selectedEvents);
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public void setLastErrorMessage(String lastErrorMessage) {
        this.lastErrorMessage = lastErrorMessage;
    }
}

