/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.common.authentication.FixedSailingAuthentication;
import com.sap.sailing.gwt.common.authentication.SAPSailingHeaderWithAuthentication;
import com.sap.sailing.gwt.common.communication.routing.ProvidesLeaderboardRouting;
import com.sap.sailing.gwt.settings.client.embeddedmapandwindchart.EmbeddedMapAndWindChartContextDefinition;
import com.sap.sailing.gwt.settings.client.embeddedmapandwindchart.EmbeddedMapAndWindChartSettings;
import com.sap.sailing.gwt.settings.client.raceboard.RaceBoardPerspectiveOwnSettings;
import com.sap.sailing.gwt.ui.client.AbstractSailingReadEntryPoint;
import com.sap.sailing.gwt.ui.client.CompetitorColorProvider;
import com.sap.sailing.gwt.ui.client.CompetitorColorProviderImpl;
import com.sap.sailing.gwt.ui.client.RaceCompetitorSelectionModel;
import com.sap.sailing.gwt.ui.client.RaceCompetitorSelectionProvider;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProvider;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProviderListener;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.TimePanelSettings;
import com.sap.sailing.gwt.ui.client.shared.charts.WindChart;
import com.sap.sailing.gwt.ui.client.shared.charts.WindChartLifecycle;
import com.sap.sailing.gwt.ui.client.shared.charts.WindChartSettings;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMap;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapHelpLinesSettings;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapResources;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapSettings;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapZoomSettings;
import com.sap.sailing.gwt.ui.raceboard.EmbeddedMapAndWindChartEntryPoint;
import com.sap.sailing.gwt.ui.raceboard.TouchSplitLayoutPanel;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.common.filter.Filter;
import com.sap.sse.common.filter.FilterSet;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.settings.generic.GenericSerializableSettings;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.player.TimeRangeChangeListener;
import com.sap.sse.gwt.client.player.TimeRangeWithZoomModel;
import com.sap.sse.gwt.client.player.TimeRangeWithZoomProvider;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.settings.SettingsToUrlSerializer;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import com.sap.sse.security.ui.client.premium.PaywallResolverImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;

public class EmbeddedMapAndWindChartEntryPoint
extends AbstractSailingReadEntryPoint
implements ProvidesLeaderboardRouting {
    private static final RaceMapResources raceMapResources = (RaceMapResources)GWT.create(RaceMapResources.class);
    private static final int DEFAULT_WIND_CHART_HEIGHT = 200;
    private static final SettingsToUrlSerializer SERIALIZER = new SettingsToUrlSerializer();
    private EmbeddedMapAndWindChartContextDefinition contextDefinition;
    private EmbeddedMapAndWindChartSettings settings;

    protected void doOnModuleLoad() {
        PaywallResolverImpl paywallResolver = new PaywallResolverImpl(this.getUserService(), this.getSubscriptionServiceFactory());
        super.doOnModuleLoad();
        this.contextDefinition = (EmbeddedMapAndWindChartContextDefinition)SERIALIZER.deserializeFromCurrentLocation((GenericSerializableSettings)new EmbeddedMapAndWindChartContextDefinition());
        if (!this.contextDefinition.isValidContext()) {
            this.createErrorPage(((StringMessages)this.getStringMessages()).requiresValidRegatta(), (PaywallResolver)paywallResolver);
            return;
        }
        RaceBoardPerspectiveOwnSettings raceboardPerspectiveSettings = RaceBoardPerspectiveOwnSettings.readSettingsFromURL((boolean)true, (boolean)true, (boolean)false, null, (boolean)false, (boolean)false, (boolean)false, null, null, null, (boolean)false);
        RaceMapSettings defaultRaceMapSettings = RaceMapSettings.readSettingsFromURL((boolean)true, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (Long)1L, (PaywallResolver)paywallResolver, null);
        this.settings = (EmbeddedMapAndWindChartSettings)SERIALIZER.deserializeFromCurrentLocation((GenericSerializableSettings)new EmbeddedMapAndWindChartSettings());
        RaceMapZoomSettings raceMapZoomSettings = new RaceMapZoomSettings(Arrays.asList(RaceMapZoomSettings.ZoomTypes.BUOYS), false);
        HashSet<RaceMapHelpLinesSettings.HelpLineTypes> helpLineTypes = new HashSet<RaceMapHelpLinesSettings.HelpLineTypes>();
        Util.addAll((Iterable)defaultRaceMapSettings.getHelpLinesSettings().getVisibleHelpLineTypes(), helpLineTypes);
        if (this.settings.isShowCourseGeometry()) {
            helpLineTypes.add(RaceMapHelpLinesSettings.HelpLineTypes.COURSEGEOMETRY);
        }
        String regattaLikeName = this.contextDefinition.getRegattaLikeName();
        String raceColumnName = this.contextDefinition.getRaceColumnName();
        String fleetName = this.contextDefinition.getFleetName();
        this.getSailingService().getRaceIdentifierAndTrackedRaceSecuredDTO(regattaLikeName, raceColumnName, fleetName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createErrorPage(String message, PaywallResolver paywallResolver) {
        DockLayoutPanel vp = new DockLayoutPanel(Style.Unit.PX);
        SAPSailingHeaderWithAuthentication header = new SAPSailingHeaderWithAuthentication();
        new FixedSailingAuthentication(this.getUserService(), paywallResolver, header.getAuthenticationMenuView());
        RootLayoutPanel.get().add((Widget)vp);
        vp.addNorth((Widget)header, 100.0);
        Label infoText = new Label(message);
        infoText.getElement().getStyle().setMargin(1.0, Style.Unit.EM);
        vp.add((Widget)infoText);
    }

    private void createEmbeddedMap(RegattaAndRaceIdentifier selectedRaceIdentifier, Map<CompetitorDTO, BoatDTO> competitorsAndBoats, RaceBoardPerspectiveOwnSettings raceboardPerspectiveSettings, RaceMapSettings raceMapSettings, SecuredDTO raceDTOProxy) {
        StringBuilder title = new StringBuilder(this.contextDefinition.getRegattaLikeName());
        title.append('/');
        title.append(this.contextDefinition.getRaceColumnName());
        String fleetName = this.contextDefinition.getFleetName();
        if (!fleetName.equals("Default")) {
            title.append('/');
            title.append(fleetName);
        }
        Window.setTitle((String)title.toString());
        long refreshInterval = Duration.ONE_SECOND.times(3L).asMillis();
        Timer timer = new Timer(this.settings.isPlay() ? Timer.PlayModes.Live : Timer.PlayModes.Replay);
        AsyncActionsExecutor asyncActionsExecutor = new AsyncActionsExecutor();
        TimeRangeWithZoomModel timeRangeWithZoomProvider = new TimeRangeWithZoomModel();
        2 timePanel = new /* Unavailable Anonymous Inner Class!! */;
        RaceTimesInfoProvider raceTimesInfoProvider = new RaceTimesInfoProvider(this.getSailingService(), asyncActionsExecutor, (ErrorReporter)this, Collections.singleton(selectedRaceIdentifier), 30000L);
        raceTimesInfoProvider.addRaceTimesInfoProviderListener((RaceTimesInfoProviderListener)new /* Unavailable Anonymous Inner Class!! */);
        Button backToLivePlayButton = timePanel.getBackToLiveButton();
        timePanel.updateSettings(new TimePanelSettings(refreshInterval));
        raceMapResources.raceMapStyle().ensureInjected();
        CompetitorColorProviderImpl colorProvider = new CompetitorColorProviderImpl(selectedRaceIdentifier, competitorsAndBoats);
        Object competitorSelection = this.settings.isShowCompetitors() ? new RaceCompetitorSelectionModel(true, (CompetitorColorProvider)colorProvider, competitorsAndBoats) : this.createEmptyFilterCompetitorModel((CompetitorColorProvider)colorProvider, competitorsAndBoats);
        PaywallResolverImpl paywallResolver = new PaywallResolverImpl(this.getUserService(), this.getSubscriptionServiceFactory());
        4 raceMap = new /* Unavailable Anonymous Inner Class!! */;
        WindChart windChart = raceboardPerspectiveSettings.isShowWindChart() ? new WindChart(null, null, new WindChartLifecycle((StringMessages)this.getStringMessages()), this.getSailingService(), selectedRaceIdentifier, timer, (TimeRangeWithZoomProvider)timeRangeWithZoomProvider, new WindChartSettings(), (StringMessages)this.getStringMessages(), asyncActionsExecutor, (ErrorReporter)this, true) : null;
        this.createRaceBoardInOneScreenMode((RaceMap)raceMap, windChart, (PaywallResolver)paywallResolver, raceDTOProxy);
        timeRangeWithZoomProvider.setTimeRange(new MillisecondsTimePoint(timer.getTime()).minus(Duration.ONE_MINUTE.times(15L)).asDate(), new MillisecondsTimePoint(timer.getTime()).plus(Duration.ONE_MINUTE.times(3L)).asDate(), new TimeRangeChangeListener[0]);
        timer.setTime(timer.getTime().getTime() - 1000L);
    }

    private RaceCompetitorSelectionProvider createEmptyFilterCompetitorModel(CompetitorColorProvider colorProvider, Map<CompetitorDTO, BoatDTO> competitorsAndBoats) {
        RaceCompetitorSelectionModel result = new RaceCompetitorSelectionModel(true, colorProvider, competitorsAndBoats);
        FilterSet filterSet = result.getOrCreateCompetitorsFilterSet("Empty");
        filterSet.addFilter((Filter)new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    private void createRaceBoardInOneScreenMode(RaceMap raceMap, WindChart windChart, PaywallResolver paywallResolver, SecuredDTO dtoContext) {
        TouchSplitLayoutPanel panel = new TouchSplitLayoutPanel(3, 25, paywallResolver, dtoContext);
        if (windChart != null) {
            panel.insert(windChart.getEntryWidget(), (Component)windChart, DockLayoutPanel.Direction.SOUTH, 200.0);
        }
        Consumer<Boolean> forceLayoutCallback = hidden -> panel.setWidgetVisibility(windChart.getEntryWidget(), (Component)windChart, hidden.booleanValue(), 200);
        panel.insert(raceMap.getEntryWidget(), (Component)raceMap, DockLayoutPanel.Direction.CENTER, 400.0);
        panel.lastComponentHasBeenAdded(forceLayoutCallback, new AbsolutePanel(), Collections.emptyList());
        if (windChart != null) {
            forceLayoutCallback.accept(false);
        }
        panel.addStyleName("dockLayoutPanel");
        RootLayoutPanel.get().add((Widget)panel);
    }

    public String getLeaderboardName() {
        return this.contextDefinition.getRegattaLikeName();
    }

    static /* synthetic */ EmbeddedMapAndWindChartSettings access$0(EmbeddedMapAndWindChartEntryPoint embeddedMapAndWindChartEntryPoint) {
        return embeddedMapAndWindChartEntryPoint.settings;
    }

    static /* synthetic */ com.sap.sse.gwt.client.StringMessages access$1(EmbeddedMapAndWindChartEntryPoint embeddedMapAndWindChartEntryPoint) {
        return embeddedMapAndWindChartEntryPoint.getStringMessages();
    }

    static /* synthetic */ void access$2(EmbeddedMapAndWindChartEntryPoint embeddedMapAndWindChartEntryPoint, String string, PaywallResolver paywallResolver) {
        embeddedMapAndWindChartEntryPoint.createErrorPage(string, paywallResolver);
    }

    static /* synthetic */ SailingServiceAsync access$3(EmbeddedMapAndWindChartEntryPoint embeddedMapAndWindChartEntryPoint) {
        return embeddedMapAndWindChartEntryPoint.getSailingService();
    }

    static /* synthetic */ void access$4(EmbeddedMapAndWindChartEntryPoint embeddedMapAndWindChartEntryPoint, RegattaAndRaceIdentifier regattaAndRaceIdentifier, Map map, RaceBoardPerspectiveOwnSettings raceBoardPerspectiveOwnSettings, RaceMapSettings raceMapSettings, SecuredDTO securedDTO) {
        embeddedMapAndWindChartEntryPoint.createEmbeddedMap(regattaAndRaceIdentifier, map, raceBoardPerspectiveOwnSettings, raceMapSettings, securedDTO);
    }
}

