/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.dto.LeaderboardEntryDTO;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.domain.common.dto.LegEntryDTO;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboard.DetailTypeColumn;
import com.sap.sailing.gwt.ui.leaderboard.DisplayedLeaderboardRowsProvider;
import com.sap.sailing.gwt.ui.leaderboard.ExpandableSortableColumn;
import com.sap.sailing.gwt.ui.leaderboard.FormattedDoubleLeaderboardRowDTODetailTypeColumn;
import com.sap.sailing.gwt.ui.leaderboard.HasStringAndDoubleValue;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboard.ManeuverCountRaceColumn;
import com.sap.sailing.gwt.ui.leaderboard.MinMaxRenderer;
import com.sap.sailing.gwt.ui.leaderboard.RaceNameProvider;
import com.sap.sailing.gwt.ui.leaderboard.SortableExpandableColumnHeader;
import com.sap.sse.common.InvertibleComparator;
import com.sap.sse.gwt.client.celltable.AbstractSortableColumnWithMinMax;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ManeuverCountRaceColumn
extends ExpandableSortableColumn<String>
implements HasStringAndDoubleValue<LeaderboardRowDTO> {
    private final StringMessages stringMessages;
    private final RaceNameProvider raceNameProvider;
    private final String headerStyle;
    private final String columnStyle;
    private final MinMaxRenderer<LeaderboardRowDTO> minmaxRenderer;

    public ManeuverCountRaceColumn(LeaderboardPanel<?> leaderboardPanel, RaceNameProvider raceNameProvider, StringMessages stringConstants, List<DetailType> maneuverDetailSelection, String headerStyle, String columnStylee, String detailHeaderStyle, String detailColumnStyle, DisplayedLeaderboardRowsProvider displayedLeaderboardRowsProvider) {
        super(leaderboardPanel, true, (Cell)new TextCell(), DetailType.NUMBER_OF_MANEUVERS.getDefaultSortingOrder(), stringConstants, detailHeaderStyle, detailColumnStyle, maneuverDetailSelection, displayedLeaderboardRowsProvider);
        this.setHorizontalAlignment(ALIGN_CENTER);
        this.stringMessages = stringConstants;
        this.raceNameProvider = raceNameProvider;
        this.headerStyle = headerStyle;
        this.columnStyle = columnStylee;
        this.minmaxRenderer = new MinMaxRenderer((HasStringAndDoubleValue)this, (Comparator)this.getComparator());
    }

    private Double getAverageManeuverLossInMeters(LeaderboardEntryDTO row, ManeuverType ... maneuverTypes) {
        int count = 0;
        double totalLossInMeters = 0.0;
        if (row != null && row.legDetails != null) {
            for (LegEntryDTO legDetail : row.legDetails) {
                if (legDetail == null || legDetail.averageManeuverLossInMeters == null) continue;
                ManeuverType[] maneuverTypeArray = maneuverTypes;
                int n = maneuverTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    Integer maneuverCount;
                    ManeuverType maneuverType = maneuverTypeArray[n2];
                    Integer n3 = maneuverCount = legDetail.numberOfManeuvers == null ? null : (Integer)legDetail.numberOfManeuvers.get(maneuverType);
                    if (maneuverCount != null && maneuverCount != 0) {
                        totalLossInMeters += (Double)legDetail.averageManeuverLossInMeters.get(maneuverType) * (double)maneuverCount.intValue();
                        count += maneuverCount.intValue();
                    }
                    ++n2;
                }
            }
        }
        return count == 0 ? null : Double.valueOf(totalLossInMeters / (double)count);
    }

    private Double getTotalNumberOfManeuvers(LeaderboardEntryDTO row, ManeuverType maneuverType) {
        Double totalNumberOfManeuvers = null;
        if (row != null && row.legDetails != null) {
            for (LegEntryDTO legDetail : row.legDetails) {
                if (legDetail == null || legDetail.numberOfManeuvers == null || legDetail.numberOfManeuvers.get(maneuverType) == null) continue;
                totalNumberOfManeuvers = totalNumberOfManeuvers == null ? Double.valueOf(((Integer)legDetail.numberOfManeuvers.get(maneuverType)).intValue()) : Double.valueOf(totalNumberOfManeuvers + (double)((Integer)legDetail.numberOfManeuvers.get(maneuverType)).intValue());
            }
        }
        return totalNumberOfManeuvers;
    }

    private Map<ManeuverType, Double> getTotalNumberOfTacksJibesAndPenaltyCircles(LeaderboardRowDTO row) {
        LeaderboardEntryDTO fieldsForRace = (LeaderboardEntryDTO)row.fieldsByRaceColumnName.get(this.getRaceName());
        return this.getTotalNumberOfTacksJibesAndPenaltyCircles(fieldsForRace);
    }

    private Map<ManeuverType, Double> getTotalNumberOfTacksJibesAndPenaltyCircles(LeaderboardEntryDTO fieldsForRace) {
        HashMap<ManeuverType, Double> totalNumberOfManeuvers = new HashMap<ManeuverType, Double>();
        ManeuverType[] maneuverTypeArray = new ManeuverType[]{ManeuverType.TACK, ManeuverType.JIBE, ManeuverType.PENALTY_CIRCLE};
        int n = maneuverTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ManeuverType maneuverType = maneuverTypeArray[n2];
            totalNumberOfManeuvers.put(maneuverType, 0.0);
            ++n2;
        }
        if (fieldsForRace != null && fieldsForRace.legDetails != null) {
            for (LegEntryDTO legDetail : fieldsForRace.legDetails) {
                if (legDetail == null) continue;
                ManeuverType[] maneuverTypeArray2 = new ManeuverType[]{ManeuverType.TACK, ManeuverType.JIBE, ManeuverType.PENALTY_CIRCLE};
                int n3 = maneuverTypeArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    ManeuverType maneuverType = maneuverTypeArray2[n4];
                    if (legDetail.numberOfManeuvers != null && legDetail.numberOfManeuvers.get(maneuverType) != null) {
                        totalNumberOfManeuvers.put(maneuverType, (Double)totalNumberOfManeuvers.get(maneuverType) + (double)((Integer)legDetail.numberOfManeuvers.get(maneuverType)).intValue());
                    }
                    ++n4;
                }
            }
        }
        return totalNumberOfManeuvers;
    }

    private String getRaceName() {
        return this.raceNameProvider.getRaceColumnName();
    }

    public SortableExpandableColumnHeader getHeader() {
        SortableExpandableColumnHeader result = new SortableExpandableColumnHeader(this.stringMessages.maneuverTypes(), this.stringMessages.numberOfManeuversInRaceTooltip(), null, this.getLeaderboardPanel(), (ExpandableSortableColumn)this, this.stringMessages);
        return result;
    }

    public InvertibleComparator<LeaderboardRowDTO> getComparator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public String getValue(LeaderboardRowDTO object) {
        Double result = this.getDoubleValue(object);
        if (result == null) {
            return "";
        }
        Integer intResult = (int)result.doubleValue();
        return intResult.toString();
    }

    public void render(Cell.Context context, LeaderboardRowDTO row, SafeHtmlBuilder sb) {
        this.minmaxRenderer.render(context, (Object)row, this.getTitle(row), sb);
    }

    protected String getTitle(LeaderboardRowDTO row) {
        return null;
    }

    public Double getDoubleValue(LeaderboardRowDTO row) {
        Double result = null;
        Map tacksJibesAndPenalties = this.getTotalNumberOfTacksJibesAndPenaltyCircles(row);
        for (Double maneuverCount : tacksJibesAndPenalties.values()) {
            if (maneuverCount == null) continue;
            result = result == null ? maneuverCount : Double.valueOf(result + maneuverCount);
        }
        return result;
    }

    public void updateMinMax() {
        this.minmaxRenderer.updateMinMax(this.getDisplayedLeaderboardRowsProvider().getRowsToDisplay().values());
    }

    protected Map<DetailType, AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>> getDetailColumnMap(LeaderboardPanel<?> leaderboardPanel, StringMessages stringMessages, String detailHeaderStyle, String detailColumnStyle) {
        HashMap result = new HashMap();
        result.put(DetailType.TACK, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.TACK, (DetailTypeColumn.DataExtractor)new NumberOfTacks(this, null), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.JIBE, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.JIBE, (DetailTypeColumn.DataExtractor)new NumberOfJibes(this, null), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.PENALTY_CIRCLE, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.PENALTY_CIRCLE, (DetailTypeColumn.DataExtractor)new NumberOfPenaltyCircles(this, null), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.AVERAGE_TACK_LOSS_IN_METERS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.AVERAGE_TACK_LOSS_IN_METERS, (DetailTypeColumn.DataExtractor)new AverageTackLossInMeters(this, null), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.AVERAGE_JIBE_LOSS_IN_METERS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.AVERAGE_JIBE_LOSS_IN_METERS, (DetailTypeColumn.DataExtractor)new AverageJibeLossInMeters(this, null), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.AVERAGE_MANEUVER_LOSS_IN_METERS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.AVERAGE_MANEUVER_LOSS_IN_METERS, (DetailTypeColumn.DataExtractor)new AverageManeuverLossInMeters(this, null), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        return result;
    }

    public static List<DetailType> getAvailableManeuverDetailColumnTypes() {
        return Arrays.asList(DetailType.TACK, DetailType.AVERAGE_TACK_LOSS_IN_METERS, DetailType.JIBE, DetailType.AVERAGE_JIBE_LOSS_IN_METERS, DetailType.PENALTY_CIRCLE, DetailType.AVERAGE_MANEUVER_LOSS_IN_METERS);
    }

    public String getColumnStyle() {
        return this.columnStyle;
    }

    public String getHeaderStyle() {
        return this.headerStyle;
    }

    public String getStringValueToRender(LeaderboardRowDTO object) {
        String result = this.getValue(object);
        if (!result.equals("")) {
            return this.getValue(object);
        }
        return null;
    }

    static /* synthetic */ String access$5(ManeuverCountRaceColumn maneuverCountRaceColumn) {
        return maneuverCountRaceColumn.getRaceName();
    }

    static /* synthetic */ Double access$6(ManeuverCountRaceColumn maneuverCountRaceColumn, LeaderboardEntryDTO leaderboardEntryDTO, ManeuverType maneuverType) {
        return maneuverCountRaceColumn.getTotalNumberOfManeuvers(leaderboardEntryDTO, maneuverType);
    }

    static /* synthetic */ Double access$7(ManeuverCountRaceColumn maneuverCountRaceColumn, LeaderboardEntryDTO leaderboardEntryDTO, ManeuverType[] maneuverTypeArray) {
        return maneuverCountRaceColumn.getAverageManeuverLossInMeters(leaderboardEntryDTO, maneuverTypeArray);
    }
}

