/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.canvas.client.Canvas;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.client.EntryPointLinkFactory;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.WindSourceTypeFormatter;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.client.shared.racemap.ImageTransformer;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMap;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapImageManager;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapSettings;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapStyle;
import com.sap.sailing.gwt.ui.shared.WindDTO;
import com.sap.sailing.gwt.ui.shared.WindTrackInfoDTO;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.dialog.ConfirmationDialog;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.settings.DummyOnSettingsStoredCallback;
import com.sap.sse.gwt.client.shared.settings.OnSettingsStoredCallback;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserStatusEventHandler;
import com.sap.sse.security.ui.client.premium.PaywallResolver;

public class CombinedWindPanel
extends FlowPanel {
    private final ImageTransformer transformer;
    private final StringMessages stringMessages;
    private final RaceMapImageManager raceMapResources;
    private final Label textLabel;
    private WindTrackInfoDTO windTrackInfoDTO;
    private WindSource windSource;
    private Canvas canvas;
    private RaceMapStyle raceMapStyle;
    private final CoordinateSystem coordinateSystem;

    public CombinedWindPanel(RaceMap map, RaceMapImageManager theRaceMapResources, RaceMapStyle raceMapStyle, StringMessages stringMessages, CoordinateSystem coordinateSystem, PaywallResolver paywallResolver, SecuredDTO raceDTO) {
        this.stringMessages = stringMessages;
        this.coordinateSystem = coordinateSystem;
        this.raceMapResources = theRaceMapResources;
        this.raceMapStyle = raceMapStyle;
        this.addStyleName(raceMapStyle.raceMapIndicatorPanel());
        this.addStyleName(raceMapStyle.combinedWindPanel());
        if (paywallResolver.hasPermission((HasPermissions.Action)SecuredDomainType.TrackedRaceActions.VIEWSTREAMLETS, raceDTO)) {
            this.addStyleName(raceMapStyle.premiumActive());
        } else {
            this.addStyleName(raceMapStyle.premiumReady());
        }
        ConfirmationDialog subscribeDialog = ConfirmationDialog.create((String)stringMessages.subscriptionSuggestionTitle(), (String)stringMessages.pleaseSubscribeToUseSpecific(stringMessages.streamletsOverlayFeature()), (String)stringMessages.takeMeToSubscriptions(), (String)stringMessages.cancel(), () -> paywallResolver.getUnlockingSubscriptionPlans((HasPermissions.Action)SecuredDomainType.TrackedRaceActions.VIEWSTREAMLETS, raceDTO, unlockingPlans -> Window.open((String)EntryPointLinkFactory.createSubscriptionPageLink((Iterable)unlockingPlans), (String)"_blank", (String)"")));
        this.transformer = this.raceMapResources.getCombinedWindIconTransformer();
        this.transformer.scale(0.9);
        this.canvas = this.transformer.getCanvas();
        this.canvas.addStyleName(this.raceMapStyle.raceMapIndicatorPanelCanvas());
        this.add((Widget)this.canvas);
        paywallResolver.registerUserStatusEventHandler((UserStatusEventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.canvas.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.textLabel = new Label("");
        this.textLabel.addStyleName(this.raceMapStyle.raceMapIndicatorPanelTextLabel());
        this.add((Widget)this.textLabel);
    }

    private void updateSettings(RaceMap map, boolean hasPermission, PaywallResolver paywallResolver, SecuredDTO raceDTO) {
        RaceMapSettings oldRaceMapSettings = map.getSettings();
        boolean newShowStreamletsOverlaySetting = (!oldRaceMapSettings.isShowWindStreamletOverlay() || !oldRaceMapSettings.isShowWindStreamletColors()) && hasPermission;
        boolean newShowWindStreamletColors = oldRaceMapSettings.isShowWindStreamletOverlay() && !oldRaceMapSettings.isShowWindStreamletColors() && hasPermission;
        RaceMapSettings newRaceMapSettings = new RaceMapSettings.RaceMapSettingsBuilder(oldRaceMapSettings, raceDTO, paywallResolver).withShowWindStreamletOverlay(Boolean.valueOf(newShowStreamletsOverlaySetting)).withShowWindStreamletColors(Boolean.valueOf(newShowWindStreamletColors)).build();
        if (map.getComponentContext() != null && map.getComponentContext().isStorageSupported((Component)map)) {
            map.getComponentContext().storeSettingsForContext((Component)map, (Settings)newRaceMapSettings, (OnSettingsStoredCallback)new DummyOnSettingsStoredCallback());
        }
        map.updateSettings(newRaceMapSettings);
    }

    protected void redraw() {
        if (this.windTrackInfoDTO != null) {
            if (!this.windTrackInfoDTO.windFixes.isEmpty()) {
                WindDTO windDTO = (WindDTO)this.windTrackInfoDTO.windFixes.get(0);
                double speedInKnots = windDTO.dampenedTrueWindSpeedInKnots;
                double windFromDeg = windDTO.dampenedTrueWindFromDeg;
                NumberFormat numberFormat = NumberFormat.getFormat((String)"0.0");
                double rotationDegOfWindSymbol = windDTO.dampenedTrueWindBearingDeg;
                this.transformer.drawTransformedImage(this.coordinateSystem.mapDegreeBearing(rotationDegOfWindSymbol), 1.0);
                String title = String.valueOf(this.stringMessages.wind()) + ": " + Math.round(windFromDeg) + " " + this.stringMessages.degreesShort() + " (" + WindSourceTypeFormatter.format((WindSource)this.windSource, (StringMessages)this.stringMessages) + ")" + 10 + this.stringMessages.clickToToggleWindStreamlets();
                this.canvas.setTitle(title);
                this.textLabel.setText(String.valueOf(numberFormat.format(speedInKnots)) + " " + this.stringMessages.knotsUnit());
                if (!this.isVisible()) {
                    this.setVisible(true);
                }
            } else {
                this.setVisible(false);
            }
        }
    }

    public void setWindInfo(WindTrackInfoDTO windTrackInfoDTO, WindSource windSource) {
        this.windTrackInfoDTO = windTrackInfoDTO;
        this.windSource = windSource;
    }

    static /* synthetic */ void access$0(CombinedWindPanel combinedWindPanel, RaceMap raceMap, boolean bl, PaywallResolver paywallResolver, SecuredDTO securedDTO) {
        combinedWindPanel.updateSettings(raceMap, bl, paywallResolver, securedDTO);
    }
}

