/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.charts;

import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.OptionElement;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.gwt.ui.client.DetailTypeComparator;
import com.sap.sailing.gwt.ui.client.DetailTypeFormatter;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.charts.AbstractChartSettingsComponent;
import com.sap.sailing.gwt.ui.client.shared.charts.ChartSettings;
import com.sap.sailing.gwt.ui.client.shared.charts.MultiCompetitorRaceChartSettings;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.DOMUtils;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import java.util.ArrayList;
import java.util.Collections;

public class MultiCompetitorRaceChartSettingsComponent
extends AbstractChartSettingsComponent<MultiCompetitorRaceChartSettings>
implements SettingsDialogComponent<MultiCompetitorRaceChartSettings> {
    private ListBox chartFirstTypeSelectionListBox;
    private ListBox chartSecondTypeSelectionListBox;
    private final DetailType initialFirstDetailType;
    private final DetailType initialSecondDetailType;
    private final Iterable<DetailType> availableDetailsTypes;

    public MultiCompetitorRaceChartSettingsComponent(MultiCompetitorRaceChartSettings settings, StringMessages stringMessages, Iterable<DetailType> availableDetailTypes) {
        super((ChartSettings)settings, stringMessages);
        this.initialFirstDetailType = settings.getFirstDetailType();
        this.initialSecondDetailType = settings.getSecondDetailType();
        this.availableDetailsTypes = availableDetailTypes;
    }

    public Widget getAdditionalWidget(DataEntryDialog<?> dialog) {
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setSpacing(5);
        Label chartSelectionLabel = new Label(this.stringMessages.chooseChart());
        mainPanel.add((Widget)chartSelectionLabel);
        this.chartFirstTypeSelectionListBox = dialog.createListBox(false);
        NodeList firstTypeOptions = DOMUtils.getOptions((ListBox)this.chartFirstTypeSelectionListBox);
        this.chartSecondTypeSelectionListBox = dialog.createListBox(false);
        NodeList secondTypeOptions = DOMUtils.getOptions((ListBox)this.chartSecondTypeSelectionListBox);
        this.chartSecondTypeSelectionListBox.addItem("--", "--");
        int i = 0;
        ArrayList sortedAvailableDetailTypes = new ArrayList();
        Util.addAll((Iterable)this.availableDetailsTypes, sortedAvailableDetailTypes);
        Collections.sort(sortedAvailableDetailTypes, new DetailTypeComparator());
        for (DetailType detailType : sortedAvailableDetailTypes) {
            String detailTypeString = DetailTypeFormatter.format((DetailType)detailType);
            String tooltip = DetailTypeFormatter.getTooltip((DetailType)detailType);
            this.chartFirstTypeSelectionListBox.addItem(detailTypeString, detailType.name());
            this.chartSecondTypeSelectionListBox.addItem(detailTypeString, detailType.name());
            if (Util.hasLength((String)tooltip)) {
                ((OptionElement)firstTypeOptions.getItem(firstTypeOptions.getLength() - 1)).setTitle(tooltip);
                ((OptionElement)secondTypeOptions.getItem(secondTypeOptions.getLength() - 1)).setTitle(tooltip);
            }
            if (detailType == this.initialFirstDetailType) {
                this.chartFirstTypeSelectionListBox.setSelectedIndex(i);
            }
            if (detailType == this.initialSecondDetailType) {
                this.chartSecondTypeSelectionListBox.setSelectedIndex(i + 1);
            }
            ++i;
        }
        mainPanel.add((Widget)this.chartFirstTypeSelectionListBox);
        mainPanel.add((Widget)this.chartSecondTypeSelectionListBox);
        mainPanel.add((Widget)new Label(this.stringMessages.stepSizeInSeconds()));
        this.stepSizeBox = dialog.createDoubleBox(Double.valueOf((double)this.getSettings().getStepSizeInMillis() / 1000.0), 5);
        mainPanel.add((Widget)this.stepSizeBox);
        return mainPanel;
    }

    public MultiCompetitorRaceChartSettings getResult() {
        DetailType newSecondDetailType;
        DetailType newFirstDetailType = this.findSelectedTypeFor(this.chartFirstTypeSelectionListBox);
        if (Util.equalsWithNull((Object)newFirstDetailType, (Object)(newSecondDetailType = this.findSelectedTypeFor(this.chartSecondTypeSelectionListBox)))) {
            newSecondDetailType = null;
        }
        return new MultiCompetitorRaceChartSettings(this.getAbstractResult(), newFirstDetailType, newSecondDetailType);
    }

    private DetailType findSelectedTypeFor(ListBox typeSelectionListBox) {
        int itemIndex = typeSelectionListBox.getSelectedIndex();
        String selectedDetailType = typeSelectionListBox.getValue(itemIndex);
        for (DetailType detailType : this.availableDetailsTypes) {
            if (!detailType.name().equals(selectedDetailType)) continue;
            return detailType;
        }
        return null;
    }

    public FocusWidget getFocusWidget() {
        return this.chartFirstTypeSelectionListBox;
    }
}

