/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.LeaderboardConfigPanel;
import com.sap.sailing.gwt.ui.adminconsole.LeaderboardGroupConfigImagesBarCell;
import com.sap.sailing.gwt.ui.adminconsole.LeaderboardGroupConfigPanel;
import com.sap.sailing.gwt.ui.adminconsole.LeaderboardGroupCreateDialog;
import com.sap.sailing.gwt.ui.adminconsole.LeaderboardGroupDialog;
import com.sap.sailing.gwt.ui.adminconsole.LeaderboardGroupEditDialog;
import com.sap.sailing.gwt.ui.adminconsole.MigrateGroupOwnershipDialog;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.AbstractRegattaPanel;
import com.sap.sailing.gwt.ui.client.Displayer;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.LeaderboardGroupDTO;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.Named;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.adminconsole.FilterablePanelProvider;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import com.sap.sse.gwt.client.celltable.AbstractSortableTextColumn;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.Flushable;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.SelectionCheckboxColumn;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.AbstractFilterablePanel;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.NamedDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserManagementServiceAsync;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.SecuredDTOOwnerColumn;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

public class LeaderboardGroupConfigPanel
extends AbstractRegattaPanel
implements FilterablePanelProvider<LeaderboardGroupDTO> {
    static final String LEADERBOARD_GROUP_ID = "LeaderBoardGroupId";
    private final Displayer<StrippedLeaderboardDTO> leaderboardsDisplayer;
    private final Displayer<LeaderboardGroupDTO> leaderboardGroupsDisplayer;
    private static AdminConsoleTableResources tableResources = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);
    private static final AnchorTemplates ANCHORTEMPLATE = (AnchorTemplates)GWT.create(AnchorTemplates.class);
    private final UserService userService;
    private VerticalPanel mainPanel;
    private HorizontalPanel splitPanel;
    private CaptionPanel groupDetailsCaptionPanel;
    private LabeledAbstractFilterablePanel<LeaderboardGroupDTO> groupsFilterablePanel;
    private Button removeButton;
    private FlushableCellTable<LeaderboardGroupDTO> groupsTable;
    private RefreshableMultiSelectionModel<LeaderboardGroupDTO> refreshableGroupsSelectionModel;
    private boolean isSingleGroupSelected;
    private ListDataProvider<LeaderboardGroupDTO> groupsProvider;
    private FlushableCellTable<StrippedLeaderboardDTO> groupDetailsTable;
    private RefreshableMultiSelectionModel<StrippedLeaderboardDTO> refreshableGroupDetailsSelectionModel;
    private ListDataProvider<StrippedLeaderboardDTO> groupDetailsProvider;
    private Button editDescriptionButton;
    private Button abortDescriptionButton;
    private Button saveDescriptionButton;
    private TextArea descriptionTextArea;
    private Button leaderboardUpButton;
    private Button leaderboardDownButton;
    private LabeledAbstractFilterablePanel<StrippedLeaderboardDTO> leaderboardsFilterablePanel;
    private FlushableCellTable<StrippedLeaderboardDTO> leaderboardsTable;
    private RefreshableMultiSelectionModel<StrippedLeaderboardDTO> refreshableLeaderboardsSelectionModel;
    private ListDataProvider<StrippedLeaderboardDTO> leaderboardsProvider;
    private Button moveToLeaderboardsButton;
    private Button moveToGroupButton;
    private final ArrayList<LeaderboardGroupDTO> availableLeaderboardGroups;
    private final ArrayList<StrippedLeaderboardDTO> availableLeaderboards;
    private final AdminConsoleView.Presenter presenter;
    private final Set<Widget> permissionRestrictedComponent = new HashSet();
    private final Label idLabel = new Label();

    public LeaderboardGroupConfigPanel(AdminConsoleView.Presenter presenter, StringMessages stringMessages) {
        super(presenter, stringMessages);
        this.userService = presenter.getUserService();
        this.leaderboardsDisplayer = result -> this.fillLeaderboards(result);
        this.leaderboardGroupsDisplayer = result -> this.fillLeaderboardGroups(result);
        AdminConsoleTableResources tableRes = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);
        this.availableLeaderboardGroups = new ArrayList();
        this.availableLeaderboards = new ArrayList();
        this.presenter = presenter;
        this.mainPanel = new VerticalPanel();
        this.mainPanel.setSpacing(5);
        this.mainPanel.setWidth("95%");
        this.add((Widget)this.mainPanel);
        this.mainPanel.add(this.createLeaderboardGroupsGUI((CellTable.Resources)tableRes));
        this.splitPanel = new HorizontalPanel();
        this.splitPanel.ensureDebugId("LeaderboardGroupDetailsPanel");
        this.splitPanel.setWidth("100%");
        this.splitPanel.setVisible(false);
        this.mainPanel.add((Widget)this.splitPanel);
        this.splitPanel.setVerticalAlignment(HorizontalPanel.ALIGN_TOP);
        this.splitPanel.add(this.createLeaderboardGroupDetailsGUI((CellTable.Resources)tableRes));
        Widget switchLeaderboardsGUI = this.createSwitchLeaderboardsGUI();
        this.permissionRestrictedComponent.add(switchLeaderboardsGUI);
        this.splitPanel.add(switchLeaderboardsGUI);
        Widget createLeaderboardsGUI = this.createLeaderboardsGUI((CellTable.Resources)tableRes);
        this.permissionRestrictedComponent.add(createLeaderboardsGUI);
        this.splitPanel.add(createLeaderboardsGUI);
    }

    private Widget createSwitchLeaderboardsGUI() {
        VerticalPanel switchLeaderboardsPanel = new VerticalPanel();
        switchLeaderboardsPanel.setSpacing(5);
        switchLeaderboardsPanel.getElement().getStyle().setMarginTop(10.0, Style.Unit.PX);
        this.moveToGroupButton = new Button("<-", event -> this.moveToGroup());
        this.moveToGroupButton.ensureDebugId("AddLeaderboardButton");
        this.moveToGroupButton.setEnabled(false);
        switchLeaderboardsPanel.add((Widget)this.moveToGroupButton);
        this.moveToLeaderboardsButton = new Button("->", event -> this.moveToLeaderboards());
        this.moveToLeaderboardsButton.ensureDebugId("RemoveLeaderboardButton");
        this.moveToLeaderboardsButton.setEnabled(false);
        switchLeaderboardsPanel.add((Widget)this.moveToLeaderboardsButton);
        return switchLeaderboardsPanel;
    }

    private Widget createLeaderboardsGUI(CellTable.Resources tableRes) {
        CaptionPanel leaderboardsCaptionPanel = new CaptionPanel(this.stringMessages.leaderboardsExceptFromSelectedGroup());
        VerticalPanel leaderboardsPanel = new VerticalPanel();
        leaderboardsCaptionPanel.add((Widget)leaderboardsPanel);
        HorizontalPanel leaderboardsFunctionPanel = new HorizontalPanel();
        leaderboardsFunctionPanel.setSpacing(5);
        leaderboardsPanel.add((Widget)leaderboardsFunctionPanel);
        Label filterLeaderboardsLabel = new Label(String.valueOf(this.stringMessages.filterLeaderboardsByName()) + ":");
        leaderboardsFunctionPanel.add((Widget)filterLeaderboardsLabel);
        this.leaderboardsProvider = new ListDataProvider();
        ColumnSortEvent.ListHandler leaderboardsListHandler = new ColumnSortEvent.ListHandler(this.leaderboardsProvider.getList());
        this.leaderboardsTable = new FlushableCellTable(10000, tableRes);
        this.leaderboardsTable.ensureDebugId("LeaderboardsCellTable");
        this.leaderboardsFilterablePanel = new /* Unavailable Anonymous Inner Class!! */;
        this.leaderboardsFilterablePanel.setUpdatePermissionFilterForCheckbox(strippedLeaderboardDTO -> this.userService.hasPermission((SecuredDTO)strippedLeaderboardDTO, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
        SelectionCheckboxColumn leaderboardTableSelectionColumn = new SelectionCheckboxColumn(tableResources.cellTableStyle().cellTableCheckboxSelected(), tableResources.cellTableStyle().cellTableCheckboxDeselected(), tableResources.cellTableStyle().cellTableCheckboxColumnCell(), (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */, this.leaderboardsFilterablePanel.getAllListDataProvider(), (Flushable)this.leaderboardsTable);
        this.refreshableLeaderboardsSelectionModel = leaderboardTableSelectionColumn.getSelectionModel();
        this.leaderboardsTable.setSelectionModel((SelectionModel)this.refreshableLeaderboardsSelectionModel, leaderboardTableSelectionColumn.getSelectionManager());
        this.leaderboardsFilterablePanel.getTextBox().ensureDebugId("LeaderboardsFilterTextBox");
        leaderboardsFunctionPanel.add((Widget)this.leaderboardsFilterablePanel);
        Button refreshLeaderboardsButton = new Button(this.stringMessages.refresh());
        refreshLeaderboardsButton.ensureDebugId("RefreshLeaderboardsButton");
        refreshLeaderboardsButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        leaderboardsFunctionPanel.add((Widget)refreshLeaderboardsButton);
        5 leaderboardsNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        leaderboardsNameColumn.setSortable(true);
        leaderboardsListHandler.setComparator((Column)leaderboardsNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        7 leaderboardsRacesColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.leaderboardsTable.setWidth("100%");
        this.leaderboardsTable.addColumnSortHandler((ColumnSortEvent.Handler)leaderboardsListHandler);
        this.leaderboardsTable.addColumn((Column)leaderboardTableSelectionColumn, leaderboardTableSelectionColumn.getHeader());
        this.leaderboardsTable.addColumn((Column)leaderboardsNameColumn, this.stringMessages.leaderboardName());
        this.leaderboardsTable.addColumn((Column)leaderboardsRacesColumn, this.stringMessages.races());
        this.refreshableLeaderboardsSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.leaderboardsProvider.addDataDisplay((HasData)this.leaderboardsTable);
        leaderboardsPanel.add((Widget)this.leaderboardsTable);
        return leaderboardsCaptionPanel;
    }

    private Widget createLeaderboardGroupDetailsGUI(CellTable.Resources tableRes) {
        this.groupDetailsCaptionPanel = new CaptionPanel();
        VerticalPanel groupDetailsPanel = new VerticalPanel();
        groupDetailsPanel.setSpacing(7);
        this.groupDetailsCaptionPanel.add((Widget)groupDetailsPanel);
        Grid leaderboardGroupIdInfo = new Grid(1, 2);
        leaderboardGroupIdInfo.setText(0, 0, String.valueOf(this.stringMessages.id()) + ":");
        leaderboardGroupIdInfo.getCellFormatter().getElement(0, 0).getStyle().setFontWeight(Style.FontWeight.BOLD);
        leaderboardGroupIdInfo.setWidget(0, 1, (Widget)this.idLabel);
        groupDetailsPanel.add((Widget)leaderboardGroupIdInfo);
        CaptionPanel descriptionCaptionPanel = new CaptionPanel(this.stringMessages.description());
        groupDetailsPanel.add((Widget)descriptionCaptionPanel);
        VerticalPanel descriptionPanel = new VerticalPanel();
        descriptionPanel.setWidth("100%");
        descriptionCaptionPanel.add((Widget)descriptionPanel);
        this.descriptionTextArea = new TextArea();
        this.descriptionTextArea.setWidth("100%");
        this.descriptionTextArea.ensureDebugId("DescriptionTextArea");
        this.descriptionTextArea.setCharacterWidth(60);
        this.descriptionTextArea.setVisibleLines(8);
        this.descriptionTextArea.getElement().getStyle().setProperty("resize", "none");
        this.descriptionTextArea.setReadOnly(true);
        descriptionPanel.add((Widget)this.descriptionTextArea);
        HorizontalPanel descriptionFunctionsPanel = new HorizontalPanel();
        descriptionPanel.add((Widget)descriptionFunctionsPanel);
        this.editDescriptionButton = new Button(this.stringMessages.edit());
        this.editDescriptionButton.ensureDebugId("EditDescriptionButton");
        this.editDescriptionButton.addClickHandler(event -> this.setDescriptionEditable(true));
        this.editDescriptionButton.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
        descriptionFunctionsPanel.add((Widget)this.editDescriptionButton);
        this.abortDescriptionButton = new Button(this.stringMessages.abort());
        this.abortDescriptionButton.ensureDebugId("AbortButton");
        this.abortDescriptionButton.addClickHandler(event -> {
            if (this.isSingleGroupSelected) {
                LeaderboardGroupDTO selectedGroup = this.getSelectedGroup();
                this.setDescriptionEditable(false);
                this.descriptionTextArea.setText(selectedGroup.getDescription());
            }
        });
        this.abortDescriptionButton.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
        this.abortDescriptionButton.setVisible(false);
        this.abortDescriptionButton.setEnabled(false);
        descriptionFunctionsPanel.add((Widget)this.abortDescriptionButton);
        this.saveDescriptionButton = new Button(this.stringMessages.save());
        this.saveDescriptionButton.ensureDebugId("SaveButton");
        this.saveDescriptionButton.addClickHandler(event -> this.saveDescriptionChanges());
        this.saveDescriptionButton.setEnabled(false);
        this.saveDescriptionButton.setVisible(false);
        descriptionFunctionsPanel.add((Widget)this.saveDescriptionButton);
        this.permissionRestrictedComponent.add(descriptionFunctionsPanel);
        9 groupDetailsNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        10 groupDetailsRacesColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.groupDetailsTable = new FlushableCellTable(10000, tableRes);
        this.groupDetailsTable.ensureDebugId("LeaderboardGroupsCellTable");
        this.groupDetailsProvider = new ListDataProvider();
        this.groupDetailsProvider.addDataDisplay((HasData)this.groupDetailsTable);
        SelectionCheckboxColumn groupDetailsTableSelectionColumn = new SelectionCheckboxColumn(tableResources.cellTableStyle().cellTableCheckboxSelected(), tableResources.cellTableStyle().cellTableCheckboxDeselected(), tableResources.cellTableStyle().cellTableCheckboxColumnCell(), (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */, this.groupDetailsProvider, (Flushable)this.groupDetailsTable);
        this.groupDetailsTable.setWidth("100%");
        this.groupDetailsTable.addColumn((Column)groupDetailsTableSelectionColumn, groupDetailsTableSelectionColumn.getHeader());
        this.groupDetailsTable.addColumn((Column)groupDetailsNameColumn, this.stringMessages.leaderboardName());
        this.groupDetailsTable.addColumn((Column)groupDetailsRacesColumn, this.stringMessages.races());
        this.refreshableGroupDetailsSelectionModel = groupDetailsTableSelectionColumn.getSelectionModel();
        this.refreshableGroupDetailsSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.groupDetailsTable.setSelectionModel((SelectionModel)this.refreshableGroupDetailsSelectionModel, groupDetailsTableSelectionColumn.getSelectionManager());
        groupDetailsPanel.add((Widget)this.groupDetailsTable);
        HorizontalPanel groupDetailsFunctionPanel = new HorizontalPanel();
        groupDetailsFunctionPanel.setSpacing(5);
        groupDetailsPanel.add((Widget)groupDetailsFunctionPanel);
        this.leaderboardUpButton = new Button(this.stringMessages.columnMoveUp());
        this.leaderboardUpButton.ensureDebugId("MoveLeaderboardGroupUpButton");
        this.leaderboardUpButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.leaderboardUpButton.setEnabled(false);
        groupDetailsFunctionPanel.add((Widget)this.leaderboardUpButton);
        this.leaderboardDownButton = new Button(this.stringMessages.columnMoveDown());
        this.leaderboardDownButton.ensureDebugId("MoveLeaderboardGroupDownButton");
        this.leaderboardDownButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.leaderboardDownButton.setEnabled(false);
        groupDetailsFunctionPanel.add((Widget)this.leaderboardDownButton);
        this.permissionRestrictedComponent.add(groupDetailsFunctionPanel);
        return this.groupDetailsCaptionPanel;
    }

    private Widget createLeaderboardGroupsGUI(CellTable.Resources tableRes) {
        CaptionPanel leaderboardGroupsCaptionPanel = new CaptionPanel(this.stringMessages.leaderboardGroups());
        VerticalPanel leaderboardGroupsContentPanel = new VerticalPanel();
        leaderboardGroupsCaptionPanel.add((Widget)leaderboardGroupsContentPanel);
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(this.userService, SecuredDomainType.LEADERBOARD_GROUP);
        leaderboardGroupsContentPanel.add((Widget)buttonPanel);
        Label filterLeaderboardGroupsLbl = new Label(String.valueOf(this.stringMessages.filterLeaderboardGroupsByName()) + ":");
        this.groupsProvider = new ListDataProvider();
        ColumnSortEvent.ListHandler leaderboardGroupsListHandler = new ColumnSortEvent.ListHandler(this.groupsProvider.getList());
        this.groupsTable = new FlushableCellTable(10000, tableRes);
        this.groupsTable.ensureDebugId("LeaderboardGroupsCellTable");
        this.groupsFilterablePanel = new /* Unavailable Anonymous Inner Class!! */;
        this.groupsFilterablePanel.getTextBox().ensureDebugId("LeaderboardGroupsFilterTextBox");
        leaderboardGroupsContentPanel.add((Widget)this.groupsFilterablePanel);
        this.groupsFilterablePanel.setUpdatePermissionFilterForCheckbox(leaderboardGroup -> this.userService.hasPermission((SecuredDTO)leaderboardGroup, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
        Button createButton = buttonPanel.addCreateAction(this.stringMessages.createNewLeaderboardGroup(), () -> this.addNewGroup());
        createButton.ensureDebugId("CreateLeaderboardGroupButton");
        Button refreshButton = buttonPanel.addUnsecuredAction(this.stringMessages.refresh(), () -> {
            this.presenter.getLeaderboardsRefresher().reloadAndCallFillAll();
            this.presenter.getLeaderboardGroupsRefresher().reloadAndCallFillAll();
        });
        refreshButton.ensureDebugId("RefreshLeaderboardGroupsButton");
        LeaderboardConfigPanel.AnchorCell anchorCell = new LeaderboardConfigPanel.AnchorCell();
        AbstractSortableTextColumn groupUUidColumn = new AbstractSortableTextColumn(group -> group.getId() == null ? "<null>" : group.getId().toString(), leaderboardGroupsListHandler);
        16 groupNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        groupNameColumn.setSortable(true);
        leaderboardGroupsListHandler.setComparator((Column)groupNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        18 groupDescriptionColumn = new /* Unavailable Anonymous Inner Class!! */;
        groupDescriptionColumn.setSortable(true);
        leaderboardGroupsListHandler.setComparator((Column)groupDescriptionColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        20 groupDisplayNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        groupDisplayNameColumn.setSortable(true);
        leaderboardGroupsListHandler.setComparator((Column)groupDisplayNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        22 hasOverallLeaderboardColumn = new /* Unavailable Anonymous Inner Class!! */;
        hasOverallLeaderboardColumn.setSortable(true);
        leaderboardGroupsListHandler.setComparator((Column)hasOverallLeaderboardColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        HasPermissions type = SecuredDomainType.LEADERBOARD_GROUP;
        AccessControlledActionsColumn actionsColumn = AccessControlledActionsColumn.create((ImagesBarCell)new LeaderboardGroupConfigImagesBarCell(this.stringMessages), (UserService)this.userService);
        actionsColumn.addAction(LeaderboardGroupConfigImagesBarCell.ACTION_UPDATE, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.openEditLeaderboardGroupDialog(arg_0));
        actionsColumn.addAction(LeaderboardGroupConfigImagesBarCell.ACTION_DELETE, (HasPermissions.Action)HasPermissions.DefaultActions.DELETE, group -> {
            if (Window.confirm((String)this.stringMessages.doYouReallyWantToRemoveLeaderboardGroup(group.getName()))) {
                this.removeLeaderboardGroup(group);
            }
        });
        EditOwnershipDialog.DialogConfig config = EditOwnershipDialog.create((UserManagementWriteServiceAsync)this.userService.getUserManagementWriteService(), (HasPermissions)type, group -> {}, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        actionsColumn.addAction(LeaderboardGroupConfigImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, e -> config.openOwnershipDialog((SecuredDTO)e));
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)this.userService.getUserManagementWriteService(), (HasPermissions)type, group -> {}, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        actionsColumn.addAction(LeaderboardGroupConfigImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL, e -> configACL.openDialog((SecuredDTO)e));
        MigrateGroupOwnershipDialog.DialogConfig migrateDialogConfig = MigrateGroupOwnershipDialog.create((UserManagementServiceAsync)this.userService.getUserManagementService(), (lg, dto) -> this.sailingServiceWrite.updateGroupOwnerForLeaderboardGroupHierarchy(lg.getId(), dto, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        actionsColumn.addAction("MIGRATE_GROUP_OWNERSHIP_HIERARCHY", (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, e -> migrateDialogConfig.openDialog((Named)e));
        SelectionCheckboxColumn leaderboardTableSelectionColumn = new SelectionCheckboxColumn(tableResources.cellTableStyle().cellTableCheckboxSelected(), tableResources.cellTableStyle().cellTableCheckboxDeselected(), tableResources.cellTableStyle().cellTableCheckboxColumnCell(), (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */, this.groupsFilterablePanel.getAllListDataProvider(), (Flushable)this.groupsTable);
        this.groupsTable.setWidth("100%");
        this.groupsTable.addColumn((Column)leaderboardTableSelectionColumn, leaderboardTableSelectionColumn.getHeader());
        this.groupsTable.addColumn((Column)groupNameColumn, this.stringMessages.name());
        this.groupsTable.addColumn((Column)groupDescriptionColumn, this.stringMessages.description());
        this.groupsTable.addColumn((Column)groupDisplayNameColumn, this.stringMessages.displayName());
        this.groupsTable.addColumn((Column)hasOverallLeaderboardColumn, this.stringMessages.useOverallLeaderboard());
        SecuredDTOOwnerColumn.configureOwnerColumns((AbstractCellTable)this.groupsTable, (ColumnSortEvent.ListHandler)leaderboardGroupsListHandler, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        this.groupsTable.addColumn((Column)groupUUidColumn, this.stringMessages.id());
        this.groupsTable.addColumn((Column)actionsColumn, this.stringMessages.actions());
        this.groupsTable.addColumnSortHandler((ColumnSortEvent.Handler)leaderboardGroupsListHandler);
        this.refreshableGroupsSelectionModel = leaderboardTableSelectionColumn.getSelectionModel();
        this.removeButton = buttonPanel.addRemoveAction(this.stringMessages.remove(), (SetSelectionModel)this.refreshableGroupsSelectionModel, true, () -> this.removeLeaderboardGroups((Collection)this.refreshableGroupsSelectionModel.getSelectedSet()));
        this.removeButton.ensureDebugId("RemoveLeaderboardButton");
        this.refreshableGroupsSelectionModel.addSelectionChangeHandler(event -> this.groupSelectionChanged());
        this.groupsTable.setSelectionModel((SelectionModel)this.refreshableGroupsSelectionModel, leaderboardTableSelectionColumn.getSelectionManager());
        this.groupsProvider.addDataDisplay((HasData)this.groupsTable);
        leaderboardGroupsContentPanel.add((Widget)this.groupsTable);
        return leaderboardGroupsCaptionPanel;
    }

    private void openEditLeaderboardGroupDialog(LeaderboardGroupDTO group) {
        UUID oldGroupId = group.getId();
        String oldGroupName = group.getName();
        ArrayList otherExistingGroups = new ArrayList(this.availableLeaderboardGroups);
        otherExistingGroups.remove(group);
        LeaderboardGroupEditDialog dialog = new LeaderboardGroupEditDialog(group, otherExistingGroups, this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.show();
    }

    public void fillLeaderboardGroups(Iterable<LeaderboardGroupDTO> groups) {
        this.availableLeaderboardGroups.clear();
        if (groups != null) {
            Util.addAll(groups, (Collection)this.availableLeaderboardGroups);
        }
        this.groupsFilterablePanel.updateAll((Iterable)this.availableLeaderboardGroups);
    }

    public void fillLeaderboards(Iterable<StrippedLeaderboardDTO> leaderboards) {
        LeaderboardGroupDTO selectedGroup;
        this.availableLeaderboards.clear();
        this.leaderboardsProvider.getList().clear();
        if (leaderboards != null) {
            Util.addAll(leaderboards, (Collection)this.availableLeaderboards);
        }
        if ((selectedGroup = this.getSelectedGroup()) != null) {
            this.updateLeaderboardFilterToShowAllLeaderboardsExceptThoseOf(selectedGroup);
            this.refreshableLeaderboardsSelectionModel.clear();
        }
    }

    private void refreshLeaderboardsList() {
        if (this.isSingleGroupSelected && this.getSelectedGroup() != null) {
            this.presenter.getLeaderboardsRefresher().reloadAndCallFillAll();
        }
    }

    private void addNewGroup() {
        LeaderboardGroupCreateDialog dialog = new LeaderboardGroupCreateDialog(Collections.unmodifiableCollection(this.availableLeaderboardGroups), this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.ensureDebugId("LeaderboardGroupCreateDialog");
        dialog.show();
    }

    private void createNewGroup(LeaderboardGroupDialog.LeaderboardGroupDescriptor newGroup) {
        this.sailingServiceWrite.createLeaderboardGroup(newGroup.getName(), newGroup.getDescription(), newGroup.getDisplayName(), newGroup.isDisplayLeaderboardsInReverseOrder(), newGroup.getOverallLeaderboardDiscardThresholds(), newGroup.getOverallLeaderboardScoringSchemeType(), (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void updateGroup(UUID oldGroupId, String oldGroupName, LeaderboardGroupDTO groupToUpdate, LeaderboardGroupDialog.LeaderboardGroupDescriptor updateDescriptor) {
        ArrayList<String> leaderboardNames = new ArrayList<String>();
        for (StrippedLeaderboardDTO leaderboardDTO : groupToUpdate.leaderboards) {
            leaderboardNames.add(leaderboardDTO.getName());
        }
        this.sailingServiceWrite.updateLeaderboardGroup(oldGroupId, oldGroupName, updateDescriptor.getName(), updateDescriptor.getDescription(), updateDescriptor.getDisplayName(), leaderboardNames, updateDescriptor.getOverallLeaderboardDiscardThresholds(), updateDescriptor.getOverallLeaderboardScoringSchemeType(), (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void updateGroup(LeaderboardGroupDTO group) {
        ArrayList<String> leaderboardNames = new ArrayList<String>();
        for (StrippedLeaderboardDTO leaderboardDTO : group.leaderboards) {
            leaderboardNames.add(leaderboardDTO.getName());
        }
        this.sailingServiceWrite.updateLeaderboardGroup(group.getId(), group.getName(), group.getName(), group.getDescription(), group.getDisplayName(), leaderboardNames, group.getOverallLeaderboardDiscardThresholds(), group.getOverallLeaderboardScoringSchemeType(), (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void removeLeaderboardGroups(Collection<LeaderboardGroupDTO> groups) {
        if (!groups.isEmpty()) {
            HashSet<UUID> groupIds = new HashSet<UUID>();
            for (LeaderboardGroupDTO group : groups) {
                groupIds.add(group.getId());
            }
            this.sailingServiceWrite.removeLeaderboardGroups(groupIds, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        }
    }

    private void removeLeaderboardGroup(LeaderboardGroupDTO group) {
        HashSet<UUID> groupIds = new HashSet<UUID>();
        groupIds.add(group.getId());
        this.sailingServiceWrite.removeLeaderboardGroups(groupIds, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void removeGroupFromTable(LeaderboardGroupDTO group) {
        this.availableLeaderboardGroups.remove(group);
        this.groupsFilterablePanel.updateAll((Iterable)this.availableLeaderboardGroups);
        this.refreshableGroupsSelectionModel.setSelected((Object)group, false);
    }

    private void groupSelectionChanged() {
        Set selectedLeaderboardGroups = this.refreshableGroupsSelectionModel.getSelectedSet();
        this.isSingleGroupSelected = selectedLeaderboardGroups.size() == 1;
        boolean canDeleteAllSelected = true;
        for (LeaderboardGroupDTO group : selectedLeaderboardGroups) {
            if (this.userService.hasPermission((SecuredDTO)group, (HasPermissions.Action)HasPermissions.DefaultActions.DELETE)) continue;
            canDeleteAllSelected = false;
        }
        this.removeButton.setEnabled(!selectedLeaderboardGroups.isEmpty() && canDeleteAllSelected);
        this.splitPanel.setVisible(this.isSingleGroupSelected);
        if (this.isSingleGroupSelected) {
            LeaderboardGroupDTO selectedGroup = (LeaderboardGroupDTO)selectedLeaderboardGroups.iterator().next();
            this.groupDetailsCaptionPanel.setCaptionText(String.valueOf(this.stringMessages.detailsOfLeaderboardGroup()) + " '" + selectedGroup.getName() + "'");
            this.idLabel.setText(selectedGroup.getId().toString());
            this.descriptionTextArea.setText(selectedGroup.getDescription());
            this.setDescriptionEditable(false);
            this.groupDetailsProvider.getList().clear();
            this.groupDetailsProvider.getList().addAll(selectedGroup.leaderboards);
            this.groupDetailsProvider.refresh();
            boolean userHasUpdateGroupPermission = this.userService.hasPermission((SecuredDTO)selectedGroup, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE);
            this.refreshableLeaderboardsSelectionModel.clear();
            this.leaderboardsProvider.getList().clear();
            this.permissionRestrictedComponent.forEach(component -> component.setVisible(userHasUpdateGroupPermission));
            if (userHasUpdateGroupPermission) {
                this.updateLeaderboardFilterToShowAllLeaderboardsExceptThoseOf(selectedGroup);
                this.leaderboardsProvider.refresh();
            }
        }
    }

    private void updateLeaderboardFilterToShowAllLeaderboardsExceptThoseOf(LeaderboardGroupDTO selectedGroup) {
        Map allExceptOf = this.availableLeaderboards.stream().collect(Collectors.toMap(NamedDTO::getName, Function.identity()));
        selectedGroup.getLeaderboards().stream().map(NamedDTO::getName).forEach(allExceptOf::remove);
        this.leaderboardsFilterablePanel.updateAll(allExceptOf.values());
    }

    private void moveToLeaderboards() {
        LeaderboardGroupDTO selectedGroup = this.getSelectedGroup();
        Set selectedLeaderboards = this.refreshableGroupDetailsSelectionModel.getSelectedSet();
        if (this.isSingleGroupSelected && selectedGroup != null && selectedLeaderboards != null && selectedLeaderboards.size() > 0) {
            for (StrippedLeaderboardDTO leaderboard : selectedLeaderboards) {
                selectedGroup.leaderboards.remove(leaderboard);
                this.groupDetailsProvider.getList().remove(leaderboard);
                this.refreshableGroupDetailsSelectionModel.setSelected((Object)leaderboard, false);
                this.leaderboardsProvider.getList().add(leaderboard);
            }
            this.updateGroup(selectedGroup);
            this.leaderboardsFilterablePanel.updateAll((Iterable)this.leaderboardsProvider.getList());
        }
    }

    private void moveToGroup() {
        LeaderboardGroupDTO selectedGroup = this.getSelectedGroup();
        ArrayList selectedLeaderboards = new ArrayList(this.refreshableLeaderboardsSelectionModel.getSelectedSet());
        if (this.isSingleGroupSelected && selectedGroup != null && selectedLeaderboards != null && !selectedLeaderboards.isEmpty()) {
            Collections.sort(selectedLeaderboards, new /* Unavailable Anonymous Inner Class!! */);
            for (StrippedLeaderboardDTO leaderboard : selectedLeaderboards) {
                if (selectedGroup.leaderboards.contains(leaderboard)) continue;
                selectedGroup.leaderboards.add(leaderboard);
                this.groupDetailsProvider.getList().add(leaderboard);
                this.leaderboardsProvider.getList().remove(leaderboard);
                this.refreshableLeaderboardsSelectionModel.setSelected((Object)leaderboard, false);
            }
            this.updateGroup(selectedGroup);
        }
    }

    private void moveLeaderboardInGroupUp() {
        LeaderboardGroupDTO selectedGroup = this.getSelectedGroup();
        Set selectedLeaderboards = this.refreshableGroupDetailsSelectionModel.getSelectedSet();
        if (this.isSingleGroupSelected && selectedGroup != null && selectedLeaderboards != null && selectedLeaderboards.size() == 1) {
            StrippedLeaderboardDTO selectedLeaderboard = (StrippedLeaderboardDTO)selectedLeaderboards.iterator().next();
            this.moveLeaderboardInGroup(selectedGroup, selectedLeaderboard, -1);
        }
    }

    private void moveLeaderboardInGroupDown() {
        LeaderboardGroupDTO selectedGroup = this.getSelectedGroup();
        Set selectedLeaderboards = this.refreshableGroupDetailsSelectionModel.getSelectedSet();
        if (this.isSingleGroupSelected && selectedGroup != null && selectedLeaderboards != null && selectedLeaderboards.size() == 1) {
            StrippedLeaderboardDTO selectedLeaderboard = (StrippedLeaderboardDTO)selectedLeaderboards.iterator().next();
            this.moveLeaderboardInGroup(selectedGroup, selectedLeaderboard, 1);
        }
    }

    private void moveLeaderboardInGroup(LeaderboardGroupDTO group, StrippedLeaderboardDTO leaderboard, int direction) {
        int index = group.leaderboards.indexOf(leaderboard);
        int destIndex = index + direction;
        if (destIndex >= 0 && destIndex < group.leaderboards.size()) {
            StrippedLeaderboardDTO temp = (StrippedLeaderboardDTO)group.leaderboards.get(destIndex);
            group.leaderboards.set(destIndex, leaderboard);
            group.leaderboards.set(index, temp);
            this.groupDetailsProvider.getList().clear();
            this.groupDetailsProvider.getList().addAll(group.leaderboards);
            this.updateGroup(group);
        }
    }

    public void fillRegattas(Iterable<RegattaDTO> result) {
    }

    private void setDescriptionEditable(boolean isEditable) {
        LeaderboardGroupDTO selectedGroup = this.getSelectedGroup();
        if (this.isSingleGroupSelected && selectedGroup != null) {
            this.editDescriptionButton.setEnabled(!isEditable);
            this.editDescriptionButton.setVisible(!isEditable);
            this.abortDescriptionButton.setEnabled(isEditable);
            this.abortDescriptionButton.setVisible(isEditable);
            this.saveDescriptionButton.setEnabled(isEditable);
            this.saveDescriptionButton.setVisible(isEditable);
            this.descriptionTextArea.setReadOnly(!isEditable);
        }
    }

    private void saveDescriptionChanges() {
        String newDescription = this.descriptionTextArea.getText();
        LeaderboardGroupDTO selectedGroup = this.getSelectedGroup();
        if (this.isSingleGroupSelected && selectedGroup != null) {
            if (newDescription != null && newDescription.length() > 0) {
                selectedGroup.setDescription(newDescription);
                this.setDescriptionEditable(false);
                this.updateGroup(selectedGroup);
            } else {
                Notification.notify((String)(String.valueOf(this.stringMessages.pleaseEnterNonEmptyDescription()) + "."), (Notification.NotificationType)Notification.NotificationType.ERROR);
                this.descriptionTextArea.setText(selectedGroup.getDescription());
            }
        }
    }

    private LeaderboardGroupDTO getSelectedGroup() {
        return this.refreshableGroupsSelectionModel.getSelectedSet().isEmpty() ? null : (LeaderboardGroupDTO)this.refreshableGroupsSelectionModel.getSelectedSet().iterator().next();
    }

    public AbstractFilterablePanel<LeaderboardGroupDTO> getFilterablePanel() {
        return this.groupsFilterablePanel;
    }

    public Displayer<StrippedLeaderboardDTO> getLeaderboardsDisplayer() {
        return this.leaderboardsDisplayer;
    }

    public Displayer<LeaderboardGroupDTO> getLeaderboardGroupsDisplayer() {
        return this.leaderboardGroupsDisplayer;
    }

    static /* synthetic */ ErrorReporter access$0(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel) {
        return leaderboardGroupConfigPanel.errorReporter;
    }

    static /* synthetic */ StringMessages access$1(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel) {
        return leaderboardGroupConfigPanel.stringMessages;
    }

    static /* synthetic */ AdminConsoleView.Presenter access$2(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel) {
        return leaderboardGroupConfigPanel.presenter;
    }

    static /* synthetic */ FlushableCellTable access$3(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel) {
        return leaderboardGroupConfigPanel.leaderboardsTable;
    }

    static /* synthetic */ void access$4(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel) {
        leaderboardGroupConfigPanel.refreshLeaderboardsList();
    }

    static /* synthetic */ RefreshableMultiSelectionModel access$5(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel) {
        return leaderboardGroupConfigPanel.refreshableLeaderboardsSelectionModel;
    }

    static /* synthetic */ Button access$6(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel) {
        return leaderboardGroupConfigPanel.moveToGroupButton;
    }

    static /* synthetic */ RefreshableMultiSelectionModel access$7(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel) {
        return leaderboardGroupConfigPanel.refreshableGroupDetailsSelectionModel;
    }

    static /* synthetic */ Button access$8(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel) {
        return leaderboardGroupConfigPanel.moveToLeaderboardsButton;
    }

    static /* synthetic */ Button access$9(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel) {
        return leaderboardGroupConfigPanel.leaderboardDownButton;
    }

    static /* synthetic */ Button access$10(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel) {
        return leaderboardGroupConfigPanel.leaderboardUpButton;
    }

    static /* synthetic */ void access$11(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel) {
        leaderboardGroupConfigPanel.moveLeaderboardInGroupUp();
    }

    static /* synthetic */ void access$12(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel) {
        leaderboardGroupConfigPanel.moveLeaderboardInGroupDown();
    }

    static /* synthetic */ FlushableCellTable access$13(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel) {
        return leaderboardGroupConfigPanel.groupsTable;
    }

    static /* synthetic */ AnchorTemplates access$14() {
        return ANCHORTEMPLATE;
    }

    static /* synthetic */ void access$15(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel, UUID uUID, String string, LeaderboardGroupDTO leaderboardGroupDTO, LeaderboardGroupDialog.LeaderboardGroupDescriptor leaderboardGroupDescriptor) {
        leaderboardGroupConfigPanel.updateGroup(uUID, string, leaderboardGroupDTO, leaderboardGroupDescriptor);
    }

    static /* synthetic */ void access$16(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel, LeaderboardGroupDialog.LeaderboardGroupDescriptor leaderboardGroupDescriptor) {
        leaderboardGroupConfigPanel.createNewGroup(leaderboardGroupDescriptor);
    }

    static /* synthetic */ ArrayList access$17(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel) {
        return leaderboardGroupConfigPanel.availableLeaderboardGroups;
    }

    static /* synthetic */ LabeledAbstractFilterablePanel access$18(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel) {
        return leaderboardGroupConfigPanel.groupsFilterablePanel;
    }

    static /* synthetic */ RefreshableMultiSelectionModel access$19(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel) {
        return leaderboardGroupConfigPanel.refreshableGroupsSelectionModel;
    }

    static /* synthetic */ LeaderboardGroupDTO access$20(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel) {
        return leaderboardGroupConfigPanel.getSelectedGroup();
    }

    static /* synthetic */ ListDataProvider access$21(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel) {
        return leaderboardGroupConfigPanel.groupsProvider;
    }

    static /* synthetic */ void access$22(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel, LeaderboardGroupDTO leaderboardGroupDTO) {
        leaderboardGroupConfigPanel.removeGroupFromTable(leaderboardGroupDTO);
    }

    static /* synthetic */ ListDataProvider access$23(LeaderboardGroupConfigPanel leaderboardGroupConfigPanel) {
        return leaderboardGroupConfigPanel.leaderboardsProvider;
    }
}

