/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.CourseAreaDTO;
import com.sap.sailing.gwt.ui.adminconsole.AbstractLeaderboardDialog;
import com.sap.sailing.gwt.ui.adminconsole.CourseAreaSelection;
import com.sap.sailing.gwt.ui.adminconsole.FlexibleLeaderboardDialog;
import com.sap.sailing.gwt.ui.adminconsole.LeaderboardDescriptor;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserService;
import java.util.Collection;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class FlexibleLeaderboardDialog
extends AbstractLeaderboardDialog<LeaderboardDescriptor> {
    protected ListBox scoringSchemeListBox;
    protected ListBox sailingEventsListBox;
    protected Collection<EventDTO> existingEvents;
    protected CourseAreaSelection courseAreaSelection;
    private final UserService userService;

    public FlexibleLeaderboardDialog(String title, LeaderboardDescriptor leaderboardDTO, UserService userService, StringMessages stringMessages, Collection<EventDTO> existingEvents, ErrorReporter errorReporter, LeaderboardParameterValidator validator, DataEntryDialog.DialogCallback<LeaderboardDescriptor> callback) {
        super(title, leaderboardDTO, stringMessages, (DataEntryDialog.Validator)validator, callback);
        this.userService = userService;
        this.existingEvents = existingEvents;
        this.courseAreaSelection = new CourseAreaSelection(stringMessages, (DataEntryDialog)this);
        this.courseAreaSelection.setEnabled(false);
    }

    protected LeaderboardDescriptor getResult() {
        LeaderboardDescriptor leaderboard = super.getResult();
        leaderboard.setRegattaName(null);
        leaderboard.setScoringScheme(FlexibleLeaderboardDialog.getSelectedScoringSchemeType((ListBox)this.scoringSchemeListBox, (StringMessages)this.stringMessages));
        this.setCourseAreaInDescriptor(leaderboard);
        return leaderboard;
    }

    private void setCourseAreaInDescriptor(LeaderboardDescriptor leaderboard) {
        leaderboard.setCourseAreaIds((Iterable)Util.mapToArrayList((Iterable)this.getSelectedCourseAreas(), CourseAreaDTO::getId));
    }

    protected Widget getAdditionalWidget() {
        FlowPanel mainPanel = new FlowPanel();
        Grid formGrid = new Grid(5, 3);
        formGrid.setCellSpacing(3);
        formGrid.setWidget(0, 0, (Widget)this.createLabel(this.stringMessages.name()));
        formGrid.setWidget(0, 1, (Widget)this.nameTextBox);
        formGrid.setWidget(1, 0, (Widget)this.createLabel(this.stringMessages.displayName()));
        formGrid.setWidget(1, 1, (Widget)this.displayNameTextBox);
        formGrid.setWidget(2, 0, (Widget)this.createLabel(this.stringMessages.scoringSystem()));
        formGrid.setWidget(2, 1, (Widget)this.scoringSchemeListBox);
        formGrid.setWidget(3, 0, (Widget)new Label(String.valueOf(this.stringMessages.event()) + ":"));
        formGrid.setWidget(3, 1, (Widget)this.sailingEventsListBox);
        formGrid.setWidget(4, 0, (Widget)new Label(String.valueOf(this.stringMessages.courseArea()) + ":"));
        formGrid.setWidget(4, 1, (Widget)this.courseAreaSelection);
        mainPanel.add((Widget)formGrid);
        mainPanel.add(this.discardThresholdBoxes.getWidget());
        return mainPanel;
    }

    protected ListBox createSailingEventListBox() {
        ListBox eventListBox = this.createListBox(false);
        eventListBox.addItem("Please select a sailing event...");
        for (EventDTO event : Util.filter((Iterable)Util.sortNamedCollection((Collection)this.existingEvents), e -> this.userService.hasPermission((SecuredDTO)e, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE))) {
            eventListBox.addItem(event.getName());
        }
        eventListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return eventListBox;
    }

    protected void onEventSelectionChanged() {
        EventDTO selectedEvent = this.getSelectedEvent();
        this.courseAreaSelection.removeAll();
        this.courseAreaSelection.setEnabled(false);
        if (selectedEvent != null) {
            this.fillCourseAreaListBox(selectedEvent);
        }
    }

    private void fillCourseAreaListBox(EventDTO selectedEvent) {
        for (CourseAreaDTO courseArea : selectedEvent.getVenue().getCourseAreas()) {
            this.courseAreaSelection.addCourseArea(courseArea);
        }
        this.courseAreaSelection.setEnabled(true);
    }

    public EventDTO getSelectedEvent() {
        EventDTO result = null;
        int selIndex = this.sailingEventsListBox.getSelectedIndex();
        if (selIndex > 0) {
            String itemText = this.sailingEventsListBox.getItemText(selIndex);
            for (EventDTO eventDTO : this.existingEvents) {
                if (!eventDTO.getName().equals(itemText)) continue;
                result = eventDTO;
                break;
            }
        }
        return result;
    }

    public Iterable<CourseAreaDTO> getSelectedCourseAreas() {
        return this.courseAreaSelection.getSelectedCourseAreas();
    }
}

