/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.partials.statistics;

import com.sap.sailing.gwt.home.communication.eventlist.EventListYearDTO;
import com.sap.sailing.gwt.home.shared.partials.statistics.AbstractStatisticsBoxPresenter;
import com.sap.sailing.gwt.home.shared.partials.statistics.StatisticsBoxResources;
import com.sap.sailing.gwt.home.shared.partials.statistics.StatisticsBoxView;
import com.sap.sailing.gwt.ui.client.StringMessages;

public class YearStatisticsBoxPresenter
extends AbstractStatisticsBoxPresenter {
    private static final StringMessages MSG = StringMessages.INSTANCE;

    public YearStatisticsBoxPresenter(StatisticsBoxView view) {
        super(view);
    }

    public void setData(EventListYearDTO statistics) {
        this.clear();
        this.addItem(StatisticsBoxResources.INSTANCE.regattasFought(), MSG.regattas(), (Object)statistics.getNumberOfRegattas());
        this.addItemIfNotNull(StatisticsBoxResources.INSTANCE.averageSpeed(), MSG.competitors(), (Object)statistics.getNumberOfCompetitors());
        this.addItem(StatisticsBoxResources.INSTANCE.racesCount(), MSG.races(), (Object)statistics.getNumberOfRaces());
        this.addItem(StatisticsBoxResources.INSTANCE.trackedCount(), MSG.trackedRaces(), (Object)statistics.getNumberOfTrackedRaces());
        this.addItemWithCompactFormat(StatisticsBoxResources.INSTANCE.gpsFixes(), MSG.numberOfGPSFixes(), statistics.getNumberOfGPSFixes());
        this.addItemWithCompactFormat(StatisticsBoxResources.INSTANCE.strongestWind(), MSG.numberWindFixes(), statistics.getNumberOfWindFixes());
        this.addItemWithCompactFormat(StatisticsBoxResources.INSTANCE.sumMiles(), MSG.sailedMiles(), Double.valueOf(statistics.getDistanceTraveled().getNauticalMiles()));
        this.addCompetitorItem(StatisticsBoxResources.INSTANCE.fastestSailor(), MSG.fastestSailor(), statistics.getFastestCompetitor());
        this.addKnotsItem(StatisticsBoxResources.INSTANCE.maxSpeed(), MSG.highestSpeed(), statistics.getFastestCompetitorSpeedInKnots());
    }
}

