/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.media;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.event.shared.Event;
import com.google.web.bindery.event.shared.EventBus;
import com.sap.sailing.gwt.common.client.SharedResources;
import com.sap.sailing.gwt.home.communication.eventview.EventViewDTO;
import com.sap.sailing.gwt.home.communication.media.MediaDTO;
import com.sap.sailing.gwt.home.desktop.partials.media.MediaPage;
import com.sap.sailing.gwt.home.desktop.partials.media.MediaPageResources;
import com.sap.sailing.gwt.home.desktop.partials.uploadpopup.DesktopMediaUploadPopup;
import com.sap.sailing.gwt.home.shared.partials.videoplayer.VideoWithLowerThird;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceHelper;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.media.GalleryImageHolder;
import com.sap.sailing.gwt.ui.client.media.VideoThumbnail;
import com.sap.sailing.gwt.ui.shared.ManageMediaModel;
import com.sap.sse.common.media.MimeType;
import com.sap.sse.gwt.client.media.ImageDTO;
import com.sap.sse.gwt.client.media.TakedownNoticeService;
import com.sap.sse.gwt.client.media.VideoDTO;
import com.sap.sse.security.ui.authentication.AuthenticationContextEvent;
import com.sap.sse.security.ui.client.UserService;

public class MediaPage
extends Composite {
    private static MediaPageUiBinder uiBinder = (MediaPageUiBinder)GWT.create(MediaPageUiBinder.class);
    private final ManageMediaModel manageMediaModel;
    @UiField
    SharedResources res;
    @UiField
    MediaPageResources local_res;
    @UiField
    DivElement addButtonArea;
    @UiField
    DivElement noContent;
    @UiField
    DivElement videoSectionUi;
    @UiField
    DivElement videoDisplayOuterBoxUi;
    @UiField
    DivElement videoListOuterBoxUi;
    @UiField
    FlowPanel videosListUi;
    @UiField
    SimplePanel videoDisplayHolderUi;
    @UiField
    DivElement photoSectionUi;
    @UiField
    FlowPanel photoListOuterBoxUi;
    @UiField
    Button videoSettingsButton;
    @UiField
    Button photoSettingsButton;
    @UiField
    Button mediaAddButton;
    private final SimplePanel contentPanel;
    private final FlowPanel popupHolder;
    private final StringMessages stringMessages;
    private boolean manageVideos;
    private boolean managePhotos;
    private VideoWithLowerThird videoDisplayUi;
    private final UserService userService;
    private final SailingServiceWriteAsync sailingServiceWrite;

    @UiHandler(value={"videoSettingsButton"})
    public void handleVideoSettingsButtonClick(ClickEvent e) {
        this.manageVideos = !this.manageVideos;
        this.setVideosManaged(this.manageVideos);
    }

    private void setVideosManaged(boolean managed) {
        if (this.videoSettingsButton != null) {
            if (managed) {
                this.videoSettingsButton.addStyleName(this.local_res.css().active());
            } else {
                this.videoSettingsButton.removeStyleName(this.local_res.css().active());
            }
        }
        if (this.videosListUi != null) {
            int i = 0;
            while (i < this.videosListUi.getWidgetCount()) {
                if (this.videosListUi.getWidget(i) instanceof VideoThumbnail) {
                    VideoThumbnail thumb = (VideoThumbnail)this.videosListUi.getWidget(i);
                    thumb.setManageable(managed);
                }
                ++i;
            }
        }
        this.updateVideoDisplay();
    }

    @UiHandler(value={"photoSettingsButton"})
    public void handlePhotoSettingsButtonClick(ClickEvent e) {
        this.managePhotos = !this.managePhotos;
        this.setPhotosManaged(this.managePhotos);
    }

    private void setPhotosManaged(boolean managed) {
        if (this.photoSettingsButton != null) {
            if (managed) {
                this.photoSettingsButton.addStyleName(this.local_res.css().active());
            } else {
                this.photoSettingsButton.removeStyleName(this.local_res.css().active());
            }
        }
        if (this.photoListOuterBoxUi != null) {
            int i = 0;
            while (i < this.photoListOuterBoxUi.getWidgetCount()) {
                if (this.photoListOuterBoxUi.getWidget(i) instanceof GalleryImageHolder) {
                    GalleryImageHolder gih = (GalleryImageHolder)this.photoListOuterBoxUi.getWidget(i);
                    gih.setManageable(managed);
                }
                ++i;
            }
        }
    }

    @UiHandler(value={"mediaAddButton"})
    public void handleMediaAddButtonClick(ClickEvent e) {
        this.popupHolder.clear();
        DesktopMediaUploadPopup popup = new DesktopMediaUploadPopup((images, videos) -> this.manageMediaModel.addImagesAndVideos(images, videos, eventDto -> this.updateMedia(eventDto.getName())), (SailingServiceAsync)this.sailingServiceWrite);
        this.popupHolder.add((Widget)popup);
        popup.center();
    }

    public MediaPage(IsWidget initialView, EventBus eventBus, UserService userService, EventViewDTO eventViewDto) {
        this.userService = userService;
        MediaPageResources.INSTANCE.css().ensureInjected();
        this.stringMessages = StringMessages.INSTANCE;
        this.sailingServiceWrite = SailingServiceHelper.createSailingServiceWriteInstance();
        this.manageMediaModel = new ManageMediaModel(this.sailingServiceWrite, userService, eventViewDto, this.stringMessages);
        this.contentPanel = new SimplePanel();
        this.contentPanel.setWidget(initialView);
        this.initWidget((Widget)this.contentPanel);
        this.popupHolder = new FlowPanel();
        eventBus.addHandler((Event.Type)AuthenticationContextEvent.TYPE, event -> this.setMediaManaged(this.manageMediaModel.hasPermissions()));
    }

    public void setMedia(MediaDTO media, EventViewDTO eventDTO) {
        this.manageMediaModel.setMedia(media);
        this.updateMedia(eventDTO.getName());
    }

    private void updateMedia(String eventName) {
        this.contentPanel.setWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.setMediaManaged(this.manageMediaModel.hasPermissions());
        int photosCount = this.manageMediaModel.getImages().size();
        this.photoListOuterBoxUi.clear();
        if (photosCount > 0) {
            this.photoSectionUi.getStyle().clearDisplay();
            String photoCss = null;
            switch (photosCount) {
                case 1: {
                    photoCss = this.res.mediaCss().medium12();
                    break;
                }
                case 2: {
                    photoCss = this.res.mediaCss().medium6();
                    break;
                }
                case 3: {
                    photoCss = this.res.mediaCss().medium4();
                    break;
                }
                case 4: {
                    photoCss = this.res.mediaCss().medium6();
                    break;
                }
                case 5: 
                case 6: {
                    photoCss = this.res.mediaCss().medium4();
                    break;
                }
                default: {
                    photoCss = this.res.mediaCss().medium3();
                }
            }
            for (ImageDTO holder : this.manageMediaModel.getImages()) {
                if (holder.getSourceRef() == null) continue;
                GalleryImageHolder gih = new GalleryImageHolder(holder, this.getDeleteImageHandler(holder), (TakedownNoticeService)this.userService, eventName);
                gih.addStyleName(photoCss);
                gih.addStyleName(this.res.mediaCss().columns());
                this.photoListOuterBoxUi.add((Widget)gih);
                gih.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        int videoCount = this.manageMediaModel.getVideos().size();
        this.videosListUi.clear();
        if (videoCount > 0) {
            boolean first = true;
            for (VideoDTO videoCandidateInfo : this.manageMediaModel.getVideos()) {
                if (first) {
                    this.putVideoOnDisplay(videoCandidateInfo, false);
                    first = false;
                }
                if (videoCount <= 0) continue;
                VideoThumbnail thumbnail = new VideoThumbnail(videoCandidateInfo, eventName, this.getDeleteVideoHandler(videoCandidateInfo), null, (TakedownNoticeService)this.userService);
                thumbnail.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                this.videosListUi.add((Widget)thumbnail);
            }
        }
        if (photosCount == 0 && videoCount == 0) {
            this.noContent.getStyle().setDisplay(Style.Display.BLOCK);
        }
        if (photosCount > 0) {
            this.photoSectionUi.getStyle().setDisplay(Style.Display.BLOCK);
        }
        if (videoCount > 0) {
            this.videoSectionUi.getStyle().setDisplay(Style.Display.BLOCK);
        }
    }

    private void updateVideoDisplay() {
        int videoCount = this.manageMediaModel.getVideos().size();
        this.videoListOuterBoxUi.removeClassName(this.res.mediaCss().large3());
        this.videoListOuterBoxUi.getStyle().clearDisplay();
        this.videoDisplayOuterBoxUi.removeClassName(this.res.mediaCss().large9());
        this.videoDisplayOuterBoxUi.removeClassName(this.res.mediaCss().large12());
        if (videoCount == 1 && !this.manageVideos) {
            this.videoDisplayOuterBoxUi.addClassName(this.res.mediaCss().large12());
            this.videoListOuterBoxUi.getStyle().setDisplay(Style.Display.NONE);
        } else if (videoCount > 1 || videoCount == 1 && this.manageVideos) {
            this.videoDisplayOuterBoxUi.addClassName(this.res.mediaCss().large9());
            this.videoListOuterBoxUi.addClassName(this.res.mediaCss().large3());
        }
    }

    private ClickHandler getDeleteVideoHandler(VideoDTO videoCandidateInfo) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private ClickHandler getDeleteImageHandler(ImageDTO imageCandidateInfo) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void putVideoOnDisplay(VideoDTO video, boolean autoplay) {
        this.videoDisplayUi = new VideoWithLowerThird(true, autoplay, (TakedownNoticeService)this.userService, this.manageMediaModel.getEventName());
        this.videoDisplayUi.setVideo(video);
        try {
            this.videoDisplayHolderUi.setWidget((Widget)this.videoDisplayUi);
        }
        catch (Exception e) {
            MimeType mimeType = video != null ? video.getMimeType() : MimeType.unknown;
            GWT.log((String)("Could not setup video player video with mime type: " + mimeType), (Throwable)e);
        }
    }

    private void setMediaManaged(boolean managed) {
        if (this.mediaAddButton != null) {
            this.mediaAddButton.setVisible(managed);
            this.photoSettingsButton.setVisible(managed);
            this.videoSettingsButton.setVisible(managed);
            this.managePhotos = false;
            this.setPhotosManaged(this.managePhotos);
            this.manageVideos = false;
            this.setVideosManaged(this.manageVideos);
        }
        this.updateVideoDisplay();
    }

    static /* synthetic */ boolean access$0(MediaPage mediaPage) {
        return mediaPage.managePhotos;
    }

    static /* synthetic */ ManageMediaModel access$1(MediaPage mediaPage) {
        return mediaPage.manageMediaModel;
    }

    static /* synthetic */ UserService access$2(MediaPage mediaPage) {
        return mediaPage.userService;
    }

    static /* synthetic */ boolean access$3(MediaPage mediaPage) {
        return mediaPage.manageVideos;
    }

    static /* synthetic */ void access$4(MediaPage mediaPage, VideoDTO videoDTO, boolean bl) {
        mediaPage.putVideoOnDisplay(videoDTO, bl);
    }

    static /* synthetic */ StringMessages access$5(MediaPage mediaPage) {
        return mediaPage.stringMessages;
    }

    static /* synthetic */ void access$6(MediaPage mediaPage, String string) {
        mediaPage.updateMedia(string);
    }
}

