/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.user.profile.sailorprofile;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.gwt.home.communication.SailingAction;
import com.sap.sailing.gwt.home.communication.SailingDispatchContext;
import com.sap.sailing.gwt.home.communication.event.SimpleCompetitorWithIdDTO;
import com.sap.sailing.gwt.home.communication.user.profile.domain.SailorProfileNumericStatisticType;
import com.sap.sailing.gwt.home.communication.user.profile.domain.SailorProfileStatisticDTO;
import com.sap.sailing.gwt.home.communication.user.profile.sailorprofile.DataMiningQueryCreatorForSailorProfiles;
import com.sap.sailing.gwt.home.communication.user.profile.sailorprofile.GetNumericStatisticForSailorProfileAction;
import com.sap.sailing.gwt.home.communication.user.profile.sailorprofile.SailorProfileConverter;
import com.sap.sailing.server.preferences.SailorProfilePreference;
import com.sap.sailing.server.preferences.SailorProfilePreferences;
import com.sap.sse.common.Named;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.settings.GwtIncompatible;
import com.sap.sse.gwt.dispatch.shared.exceptions.DispatchException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class GetNumericStatisticForSailorProfileAction
implements SailingAction<SailorProfileStatisticDTO>,
SailorProfileConverter {
    private SailorProfileNumericStatisticType type;
    private UUID uuid;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$sap$sailing$gwt$home$communication$user$profile$domain$SailorProfileNumericStatisticType;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$sap$sailing$gwt$home$communication$user$profile$domain$SailorProfileNumericStatisticType$StatisticType;

    public GetNumericStatisticForSailorProfileAction(UUID uuid, SailorProfileNumericStatisticType type) {
        this.uuid = uuid;
        this.type = type;
    }

    private GetNumericStatisticForSailorProfileAction() {
    }

    @GwtIncompatible
    public SailorProfileStatisticDTO execute(SailingDispatchContext ctx) throws DispatchException {
        HashMap<SimpleCompetitorWithIdDTO, ArrayList> result = new HashMap<SimpleCompetitorWithIdDTO, ArrayList>();
        CompetitorAndBoatStore store = ctx.getRacingEventService().getCompetitorAndBoatStore();
        SailorProfilePreferences prefs = (SailorProfilePreferences)ctx.getPreferenceForCurrentUser("user.profile.sailorProfiles");
        SailorProfilePreference pref = this.findSailorProfile(store, prefs);
        for (Competitor competitor : pref.getCompetitors()) {
            Aggregator aggregator = this.determineAggregator();
            if (aggregator == null) continue;
            for (Event event : ctx.getRacingEventService().getAllEvents()) {
                TimePoint end = event.getEndDate();
                if (end == null) {
                    end = MillisecondsTimePoint.now();
                }
                for (LeaderboardGroup leaderboardGroup : event.getLeaderboardGroups()) {
                    for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
                        if (!Util.contains((Iterable)leaderboard.getCompetitors(), (Object)competitor)) continue;
                        String regattaName = leaderboard.getName();
                        Regatta regatta = ctx.getRacingEventService().getRegattaByName(regattaName);
                        if (regatta == null || !leaderboard.isPartOfEvent((EventBase)event)) continue;
                        for (TrackedRace tr : leaderboard.getTrackedRaces()) {
                            if (!Util.contains((Iterable)tr.getRace().getCompetitors(), (Object)competitor)) continue;
                            this.extractValue(competitor, aggregator, end, leaderboard, tr, leaderboardGroup, event);
                        }
                    }
                }
            }
            result.put(new SimpleCompetitorWithIdDTO(competitor), aggregator.getResult());
        }
        List competitorNames = StreamSupport.stream(pref.getCompetitors().spliterator(), false).map(Named::getName).collect(Collectors.toList());
        String serializedQuery = DataMiningQueryCreatorForSailorProfiles.getSerializedDataMiningQuery((SailorProfileNumericStatisticType)this.type, competitorNames);
        this.keepOnlyBestIfNecessary(result, this.type.getAggregationType());
        return new SailorProfileStatisticDTO(result, serializedQuery);
    }

    /*
     * Exception decompiling
     */
    @GwtIncompatible
    private void extractValue(Competitor competitor, Aggregator aggregator, TimePoint end, Leaderboard leaderboard, TrackedRace tr, LeaderboardGroup leaderboardGroup, Event event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @GwtIncompatible
    private void keepOnlyBestIfNecessary(Map<SimpleCompetitorWithIdDTO, ArrayList<SailorProfileStatisticDTO.SingleEntry>> results, SailorProfileNumericStatisticType.StatisticType type) {
        HashSet<SimpleCompetitorWithIdDTO> competitorsToRemove = new HashSet<SimpleCompetitorWithIdDTO>();
        if (type == SailorProfileNumericStatisticType.StatisticType.HIGHEST_IS_BEST || type == SailorProfileNumericStatisticType.StatisticType.LOWEST_IS_BEST) {
            double best = type == SailorProfileNumericStatisticType.StatisticType.HIGHEST_IS_BEST ? Double.MIN_VALUE : Double.MAX_VALUE;
            SimpleCompetitorWithIdDTO bestCompetitor = null;
            for (Map.Entry<SimpleCompetitorWithIdDTO, ArrayList<SailorProfileStatisticDTO.SingleEntry>> mapEntry : results.entrySet()) {
                for (SailorProfileStatisticDTO.SingleEntry statisticEntry : mapEntry.getValue()) {
                    if (type == SailorProfileNumericStatisticType.StatisticType.LOWEST_IS_BEST && best > statisticEntry.getValue() || type == SailorProfileNumericStatisticType.StatisticType.HIGHEST_IS_BEST && best < statisticEntry.getValue()) {
                        best = statisticEntry.getValue();
                        competitorsToRemove.add(bestCompetitor);
                        bestCompetitor = mapEntry.getKey();
                        continue;
                    }
                    competitorsToRemove.add(mapEntry.getKey());
                }
            }
        }
        competitorsToRemove.forEach(competitor -> {
            Object v = results.remove(competitor);
        });
    }

    /*
     * Exception decompiling
     */
    @GwtIncompatible
    private Aggregator determineAggregator() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @GwtIncompatible
    private SailorProfileStatisticDTO.SingleEntry getMaxSpeedInRaces(Leaderboard leaderboard, Competitor competitor, Aggregator aggregator, TrackedRace tr, TimePoint endOfEvent, String bestLeaderboardGroupName, UUID bestLeaderboardGroupId, UUID eventId) {
        NavigableSet markPassings;
        Util.Pair bestFix = leaderboard.getMaximumSpeedOverGround(competitor, endOfEvent);
        SailorProfileStatisticDTO.SingleEntry newBetterResult = null;
        if (bestFix != null && !(markPassings = tr.getMarkPassings(competitor)).isEmpty()) {
            TimePoint from = ((MarkPassing)markPassings.first()).getTimePoint();
            TimePoint to = ((MarkPassing)markPassings.last()).getTimePoint();
            Util.Pair maxSpeed = tr.getTrack(competitor).getMaximumSpeedOverGround(from, to);
            if (maxSpeed != null && maxSpeed.getA() != null && maxSpeed.getB() != null) {
                aggregator.add((Speed)maxSpeed.getB(), ((GPSFixMoving)bestFix.getA()).getTimePoint(), tr.getStartOfRace(), tr.getRaceIdentifier(), leaderboard.getName(), bestLeaderboardGroupName, bestLeaderboardGroupId, eventId, tr.getRace().getName());
            }
        }
        return newBetterResult;
    }

    @GwtIncompatible
    private SailorProfilePreference findSailorProfile(CompetitorAndBoatStore store, SailorProfilePreferences prefs) {
        if (prefs == null) {
            throw new NullPointerException("no sailor profile present");
        }
        for (SailorProfilePreference p : prefs.getSailorProfiles()) {
            if (!p.getUuid().equals(this.uuid)) continue;
            return p;
        }
        return null;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sap$sailing$gwt$home$communication$user$profile$domain$SailorProfileNumericStatisticType() {
        if ($SWITCH_TABLE$com$sap$sailing$gwt$home$communication$user$profile$domain$SailorProfileNumericStatisticType != null) {
            return $SWITCH_TABLE$com$sap$sailing$gwt$home$communication$user$profile$domain$SailorProfileNumericStatisticType;
        }
        int[] nArray = new int[SailorProfileNumericStatisticType.values().length];
        try {
            nArray[SailorProfileNumericStatisticType.AVERAGE_STARTLINE_DISTANCE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SailorProfileNumericStatisticType.BEST_DISTANCE_TO_START.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SailorProfileNumericStatisticType.BEST_STARTLINE_SPEED.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SailorProfileNumericStatisticType.MAX_SPEED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sap$sailing$gwt$home$communication$user$profile$domain$SailorProfileNumericStatisticType = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sap$sailing$gwt$home$communication$user$profile$domain$SailorProfileNumericStatisticType$StatisticType() {
        if ($SWITCH_TABLE$com$sap$sailing$gwt$home$communication$user$profile$domain$SailorProfileNumericStatisticType$StatisticType != null) {
            return $SWITCH_TABLE$com$sap$sailing$gwt$home$communication$user$profile$domain$SailorProfileNumericStatisticType$StatisticType;
        }
        int[] nArray = new int[SailorProfileNumericStatisticType.StatisticType.values().length];
        try {
            nArray[SailorProfileNumericStatisticType.StatisticType.AVERAGE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SailorProfileNumericStatisticType.StatisticType.HIGHEST_IS_BEST.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SailorProfileNumericStatisticType.StatisticType.LOWEST_IS_BEST.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sap$sailing$gwt$home$communication$user$profile$domain$SailorProfileNumericStatisticType$StatisticType = nArray;
        return nArray;
    }
}

