/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.places.screens.idleloop.leaderboardsixty;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.place.shared.Place;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.gwt.autoplay.client.app.AutoPlayClientFactory;
import com.sap.sailing.gwt.autoplay.client.app.AutoPlayPresenterConfigured;
import com.sap.sailing.gwt.autoplay.client.places.screens.idleloop.leaderboardsixty.IdleSixtyInchLeaderboardPlace;
import com.sap.sailing.gwt.autoplay.client.places.screens.idleloop.leaderboardsixty.IdleSixtyInchLeaderboardView;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionChangeListener;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionProvider;
import com.sap.sailing.gwt.ui.leaderboard.MultiRaceLeaderboardPanel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IdleSixtyInchLeaderboardPresenterImpl
extends AutoPlayPresenterConfigured<IdleSixtyInchLeaderboardPlace>
implements IdleSixtyInchLeaderboardView.Slide7Presenter {
    private static final int SWITCH_COMPETITOR_DELAY = 2000;
    private static final int WAIT_FOR_POPULATION_DELAY = 10000;
    private static final Logger LOGGER = Logger.getLogger(IdleSixtyInchLeaderboardPresenterImpl.class.getName());
    private IdleSixtyInchLeaderboardView view;
    private int selected = -1;
    ArrayList<CompetitorDTO> compList = new ArrayList();
    private MultiRaceLeaderboardPanel leaderboardPanel;
    private Timer selectionTimer;
    private int emptyTries;

    public IdleSixtyInchLeaderboardPresenterImpl(IdleSixtyInchLeaderboardPlace place, AutoPlayClientFactory clientFactory, IdleSixtyInchLeaderboardView lifeRaceWithRacemapViewImpl) {
        super((Place)place, clientFactory);
        this.view = lifeRaceWithRacemapViewImpl;
        this.selectionTimer = new /* Unavailable Anonymous Inner Class!! */;
    }

    public void startConfigured(AcceptsOneWidget panel) {
        this.emptyTries = 0;
        try {
            this.leaderboardPanel = ((IdleSixtyInchLeaderboardPlace)this.getPlace()).getLeaderboardPanel();
            this.view.startingWith((IdleSixtyInchLeaderboardView.Slide7Presenter)this, panel, ((IdleSixtyInchLeaderboardPlace)this.getPlace()).getLeaderboardPanel());
            this.selectionTimer.schedule(6000);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "error strting idle leaderboard", e.getCause());
        }
    }

    public void onStop() {
        this.view.onStop();
        this.selectionTimer.cancel();
    }

    protected void selectNext() {
        try {
            CompetitorSelectionProvider competitorSelectionProvider = ((IdleSixtyInchLeaderboardPlace)this.getPlace()).getCompetitorSelectionProvider();
            this.compList.clear();
            for (LeaderboardRowDTO item : this.leaderboardPanel.getLeaderboardTable().getVisibleItems()) {
                this.compList.add(item.competitor);
            }
            if (this.compList.isEmpty()) {
                if (this.emptyTries * 2000 > 10000) {
                    ((IdleSixtyInchLeaderboardPlace)this.getPlace()).getDurationConsumer().accept(0);
                    return;
                }
                ++this.emptyTries;
                this.selectionTimer.schedule(2000);
                return;
            }
            this.emptyTries = 0;
            ++this.selected;
            if (this.selected >= this.compList.size()) {
                ((IdleSixtyInchLeaderboardPlace)this.getPlace()).getDurationConsumer().accept(2);
            } else {
                for (CompetitorDTO competitor : this.compList) {
                    competitorSelectionProvider.setSelected(competitor, false, new CompetitorSelectionChangeListener[0]);
                }
                CompetitorDTO marked = (CompetitorDTO)this.compList.get(this.selected);
                competitorSelectionProvider.setSelected(marked, true, new CompetitorSelectionChangeListener[0]);
                Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
                this.selectionTimer.schedule(2000);
            }
        }
        catch (Exception e) {
            this.selected = 0;
            this.selectionTimer.schedule(2000);
        }
    }

    static /* synthetic */ int access$0(IdleSixtyInchLeaderboardPresenterImpl idleSixtyInchLeaderboardPresenterImpl) {
        return idleSixtyInchLeaderboardPresenterImpl.selected;
    }

    static /* synthetic */ IdleSixtyInchLeaderboardView access$1(IdleSixtyInchLeaderboardPresenterImpl idleSixtyInchLeaderboardPresenterImpl) {
        return idleSixtyInchLeaderboardPresenterImpl.view;
    }
}

