/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisRetryException;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.config.Protocol;

public abstract class BaseConnectionHandler<C extends RedisConnection>
extends ChannelInboundHandlerAdapter {
    final RedisClient redisClient;
    final CompletableFuture<C> connectionPromise = new CompletableFuture();
    C connection;

    public BaseConnectionHandler(RedisClient redisClient) {
        this.redisClient = redisClient;
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (this.connection == null) {
            this.connection = this.createConnection(ctx);
        }
        super.channelRegistered(ctx);
    }

    abstract C createConnection(ChannelHandlerContext var1);

    public void channelActive(ChannelHandlerContext ctx) {
        Future<Object> future;
        ArrayList futures = new ArrayList(5);
        InetSocketAddress addr = this.redisClient.resolveAddr().getNow(null);
        RedisClientConfig config = this.redisClient.getConfig();
        CompletionStage f = config.getCredentialsResolver().resolve(addr).thenCompose(credentials -> {
            String password = Objects.toString(config.getAddress().getPassword(), Objects.toString(credentials.getPassword(), config.getPassword()));
            if (password != null) {
                String username = Objects.toString(config.getAddress().getUsername(), Objects.toString(credentials.getUsername(), config.getUsername()));
                RFuture future = username != null ? ((RedisConnection)this.connection).async(RedisCommands.AUTH, username, password) : ((RedisConnection)this.connection).async(RedisCommands.AUTH, password);
                return future;
            }
            return CompletableFuture.completedFuture(null);
        });
        futures.add(f.toCompletableFuture());
        if (this.redisClient.getConfig().getProtocol() == Protocol.RESP3) {
            RFuture f1 = ((RedisConnection)this.connection).async(RedisCommands.HELLO, "3");
            futures.add(f1.toCompletableFuture());
        }
        if (config.getDatabase() != 0) {
            future = ((RedisConnection)this.connection).async(RedisCommands.SELECT, config.getDatabase());
            futures.add(future.toCompletableFuture());
        }
        if (config.getClientName() != null) {
            future = ((RedisConnection)this.connection).async(RedisCommands.CLIENT_SETNAME, config.getClientName());
            futures.add(future.toCompletableFuture());
        }
        if (config.isReadOnly()) {
            future = ((RedisConnection)this.connection).async(RedisCommands.READONLY, new Object[0]);
            futures.add(future.toCompletableFuture());
        }
        if (config.getPingConnectionInterval() > 0) {
            future = ((RedisConnection)this.connection).async(RedisCommands.PING, new Object[0]);
            futures.add(future.toCompletableFuture());
        }
        future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        ((CompletableFuture)future).whenComplete((res, e) -> {
            if (e != null) {
                if (e instanceof RedisRetryException) {
                    ctx.executor().schedule(() -> this.channelActive(ctx), 1L, TimeUnit.SECONDS);
                    return;
                }
                ((RedisConnection)this.connection).closeAsync();
                this.connectionPromise.completeExceptionally((Throwable)e);
                return;
            }
            ctx.fireChannelActive();
            this.connectionPromise.complete(this.connection);
        });
    }
}

