/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication.interfaces.impl;

import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.replication.ReplicaDescriptor;
import java.net.InetAddress;
import java.util.UUID;

public class ReplicaDescriptorImpl
implements ReplicaDescriptor {
    private static final long serialVersionUID = -5451556877949921454L;
    private final UUID uuid;
    private final InetAddress ipAddress;
    private final Integer port;
    private final TimePoint registrationTime;
    private final String additionalInformation;
    private final String[] replicableIdsAsStrings;

    public ReplicaDescriptorImpl(InetAddress ipAddress, Integer port, UUID id, String additionalInformation, String[] replicableIdsAsStrings) {
        this(ipAddress, port, id, MillisecondsTimePoint.now(), additionalInformation, replicableIdsAsStrings);
    }

    public ReplicaDescriptorImpl(InetAddress ipAddress, Integer port, UUID id, TimePoint registrationTime, String additionalInformation, String[] replicableIdsAsStrings) {
        assert (replicableIdsAsStrings != null && replicableIdsAsStrings.length > 0);
        this.uuid = id;
        this.registrationTime = registrationTime;
        this.ipAddress = ipAddress;
        this.port = port;
        this.additionalInformation = additionalInformation;
        this.replicableIdsAsStrings = replicableIdsAsStrings;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public TimePoint getRegistrationTime() {
        return this.registrationTime;
    }

    @Override
    public String getAdditionalInformation() {
        return this.additionalInformation;
    }

    @Override
    public String[] getReplicableIdsAsStrings() {
        return this.replicableIdsAsStrings;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplicaDescriptorImpl other = (ReplicaDescriptorImpl)obj;
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public String toString() {
        return this.uuid + ": " + this.ipAddress + " (" + this.additionalInformation + ") for replicables " + String.join((CharSequence)", ", this.getReplicableIdsAsStrings());
    }
}

