/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.notification.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.impl.RacingEventServiceImpl;
import com.sap.sailing.server.impl.preferences.BoatClassResultsNotificationSet;
import com.sap.sailing.server.impl.preferences.BoatClassUpcomingRaceNotificationSet;
import com.sap.sailing.server.impl.preferences.CompetitorResultsNotificationSet;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.notification.SailingNotificationService;
import com.sap.sailing.server.notification.impl.NotificationMailTemplate;
import com.sap.sailing.server.notification.impl.NotificationSetNotification;
import com.sap.sailing.server.util.RaceBoardLinkFactory;
import com.sap.sse.common.Stoppable;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.i18n.impl.ResourceBundleStringMessagesImpl;
import com.sap.sse.mail.queue.MailNotification;
import com.sap.sse.mail.queue.MailQueue;
import com.sap.sse.security.PreferenceObjectBasedNotificationSet;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class SailingNotificationServiceImpl
implements SailingNotificationService {
    public static final String STRING_MESSAGES_BASE_NAME = "stringmessages/StringMessages";
    private static final Logger logger = Logger.getLogger(SailingNotificationServiceImpl.class.getName());
    private final Set<Stoppable> toStop = new HashSet<Stoppable>();
    private final MailQueue mailQueue;
    private RacingEventService racingEventService;
    private final ResourceBundleStringMessagesImpl messages;
    private final BoatClassResultsNotificationSet boatClassResults;
    private final BoatClassUpcomingRaceNotificationSet boatClassUpcomingRace;
    private final CompetitorResultsNotificationSet competitorResults;

    public SailingNotificationServiceImpl(BundleContext bundleContext, MailQueue mailQueue) throws MalformedURLException {
        this(mailQueue, new BoatClassResultsNotificationSet(bundleContext), new BoatClassUpcomingRaceNotificationSet(bundleContext), new CompetitorResultsNotificationSet(bundleContext));
    }

    public SailingNotificationServiceImpl(MailQueue mailQueue, BoatClassResultsNotificationSet boatClassResults, BoatClassUpcomingRaceNotificationSet boatClassUpcomingRace, CompetitorResultsNotificationSet competitorResults) throws MalformedURLException {
        this.mailQueue = mailQueue;
        this.messages = new ResourceBundleStringMessagesImpl(STRING_MESSAGES_BASE_NAME, this.getClass().getClassLoader(), StandardCharsets.UTF_8.name());
        this.boatClassResults = boatClassResults;
        this.toStop.add((Stoppable)this.boatClassResults);
        this.boatClassUpcomingRace = boatClassUpcomingRace;
        this.toStop.add((Stoppable)this.boatClassUpcomingRace);
        this.competitorResults = competitorResults;
        this.toStop.add((Stoppable)this.competitorResults);
    }

    public void stop() {
        this.toStop.forEach(Stoppable::stop);
    }

    public void setRacingEventService(RacingEventServiceImpl racingEventService) {
        this.racingEventService = racingEventService;
    }

    private Util.Pair<Event, LeaderboardGroup> calculateAssociatedEventForLeaderboard(Leaderboard leaderboard) {
        Iterator iterator;
        LinkedHashSet foundEvents = new LinkedHashSet();
        LinkedHashSet foundLeaderboardGroups = new LinkedHashSet();
        this.racingEventService.getAllEvents().forEach(event -> event.getLeaderboardGroups().forEach(leaderboardGroup -> {
            if (Util.contains((Iterable)leaderboardGroup.getLeaderboards(), (Object)leaderboard)) {
                foundEvents.add(event);
                foundLeaderboardGroups.add(leaderboardGroup);
            }
        }));
        int foundEventsCount = foundEvents.size();
        if (foundEventsCount == 1) {
            return new Util.Pair((Object)((Event)Util.get(foundEvents, (int)0)), (Object)((LeaderboardGroup)Util.get(foundLeaderboardGroups, (int)0)));
        }
        if (foundEventsCount > 1 && (iterator = foundLeaderboardGroups.iterator()).hasNext()) {
            LeaderboardGroup leaderboardGroup = (LeaderboardGroup)iterator.next();
            if (leaderboardGroup.hasOverallLeaderboard()) {
                for (Event event2 : foundEvents) {
                    if (!Util.containsAny((Iterable)event2.getVenue().getCourseAreas(), (Iterable)leaderboard.getCourseAreas())) continue;
                    return new Util.Pair((Object)event2, (Object)leaderboardGroup);
                }
            }
            return new Util.Pair((Object)((Event)Util.get(foundEvents, (int)0)), (Object)((LeaderboardGroup)Util.get(foundLeaderboardGroups, (int)0)));
        }
        return null;
    }

    private void doWithEvent(Leaderboard leaderboard, BiConsumer<Event, LeaderboardGroup> consumer) {
        if (this.racingEventService == null) {
            logger.severe("Can't send notifications if " + this.getClass().getSimpleName() + ".racingEventService isn't set");
            return;
        }
        Util.Pair<Event, LeaderboardGroup> eventAndLeaderboardGroup = this.calculateAssociatedEventForLeaderboard(leaderboard);
        if (eventAndLeaderboardGroup != null) {
            consumer.accept((Event)eventAndLeaderboardGroup.getA(), (LeaderboardGroup)eventAndLeaderboardGroup.getB());
        }
    }

    private String calculateRaceDescription(Locale locale, Event event, Leaderboard leaderboard, RaceColumn raceColumn, Fleet fleet) {
        String leaderboardDisplayName;
        String raceName = raceColumn.getName();
        String eventName = event.getName();
        String string = leaderboardDisplayName = leaderboard.getDisplayName() != null ? leaderboard.getDisplayName() : leaderboard.getName();
        if (Util.size((Iterable)raceColumn.getFleets()) > 1) {
            return this.messages.get(locale, "raceInFleetInRegattaOfEvent", new String[]{raceName, leaderboardDisplayName, eventName, fleet.getName()});
        }
        return this.messages.get(locale, "raceInRegattaOfEvent", new String[]{raceName, leaderboardDisplayName, eventName});
    }

    private String calculateLeaderboardDescription(Locale locale, Event event, Leaderboard leaderboard) {
        String eventName = event.getName();
        String leaderboardDisplayName = leaderboard.getDisplayName() != null ? leaderboard.getDisplayName() : leaderboard.getName();
        return this.messages.get(locale, "leaderboardOfEvent", new String[]{leaderboardDisplayName, eventName});
    }

    private Util.Pair<String, String> createRaceBoardShowRaceLink(TrackedRace trackedRace, Leaderboard leaderboard, Event event, LeaderboardGroup leaderboardGroup, Locale locale) {
        return this.createRaceBoardLinkWithMessage(trackedRace, leaderboard, event, leaderboardGroup, "PLAYER", "raceboardShowRaceLinkTitle", locale);
    }

    private Util.Pair<String, String> createRaceBoardRaceAnalysisLink(TrackedRace trackedRace, Leaderboard leaderboard, Event event, LeaderboardGroup leaderboardGroup, Locale locale) {
        return this.createRaceBoardLinkWithMessage(trackedRace, leaderboard, event, leaderboardGroup, "FULL_ANALYSIS", "raceboardRaceAnalysisLinkTitle", locale);
    }

    private Util.Pair<String, String> createRaceBoardLinkWithMessage(TrackedRace trackedRace, Leaderboard leaderboard, Event event, LeaderboardGroup leaderboardGroup, String raceboardMode, String labelMessageKey, Locale locale) {
        String link = RaceBoardLinkFactory.createRaceBoardLink(trackedRace, leaderboard, event, leaderboardGroup, raceboardMode, locale);
        return new Util.Pair((Object)this.messages.get(locale, labelMessageKey), (Object)link);
    }

    private Util.Pair<String, String> createHomeRacesListLink(Leaderboard leaderboard, Event event, Locale locale) {
        return this.createHomeRegattaLink("races", "racesOverviewLinkTitle", leaderboard, event, locale);
    }

    private Util.Pair<String, String> createHomeLeaderboardLink(Leaderboard leaderboard, Event event, Locale locale) {
        return this.createHomeRegattaLink("leaderboard", "leaderboardShowResultsLinkTitle", leaderboard, event, locale);
    }

    private Util.Pair<String, String> createHomeRegattaLink(String tab, String labelMessageKey, Leaderboard leaderboard, Event event, Locale locale) {
        String link = String.valueOf(RaceBoardLinkFactory.getBaseURL(event).toString()) + "/gwt/Home.html?locale=" + locale.toLanguageTag() + "#/regatta/" + tab + "/:eventId=" + event.getId() + "&regattaId=" + leaderboard.getName();
        return new Util.Pair((Object)this.messages.get(locale, labelMessageKey), (Object)link);
    }

    @Override
    public void notifyUserOnBoatClassRaceChangesStateToFinished(final BoatClass boatClass, final TrackedRace trackedRace, final Leaderboard leaderboard, final RaceColumn raceColumn, final Fleet fleet) {
        this.doWithEvent(leaderboard, (event, leaderboardGroup) -> this.mailQueue.addNotification((MailNotification)new NotificationSetNotification<BoatClass>(boatClass, (PreferenceObjectBasedNotificationSet)this.boatClassResults){

            @Override
            protected NotificationMailTemplate getMailTemplate(BoatClass objectToNotifyAbout, Locale locale) {
                String raceDescription = SailingNotificationServiceImpl.this.calculateRaceDescription(locale, event, leaderboard, raceColumn, fleet);
                return new NotificationMailTemplate(SailingNotificationServiceImpl.this.messages.get(locale, "boatClassRaceFinishedSubject", new String[]{boatClass.getName()}), SailingNotificationServiceImpl.this.messages.get(locale, "boatClassRaceFinishedBody", new String[]{boatClass.getName(), raceDescription}), RaceBoardLinkFactory.getBaseURL(event), SailingNotificationServiceImpl.this.createRaceBoardShowRaceLink(trackedRace, leaderboard, event, leaderboardGroup, locale), SailingNotificationServiceImpl.this.createRaceBoardRaceAnalysisLink(trackedRace, leaderboard, event, leaderboardGroup, locale));
            }
        }));
    }

    @Override
    public void notifyUserOnBoatClassWhenScoreCorrectionsAreAvailable(final BoatClass boatClass, final Leaderboard leaderboard) {
        this.doWithEvent(leaderboard, (event, leaderboardGroup) -> this.mailQueue.addNotification((MailNotification)new NotificationSetNotification<BoatClass>(boatClass, (PreferenceObjectBasedNotificationSet)this.boatClassResults){

            @Override
            protected NotificationMailTemplate getMailTemplate(BoatClass objectToNotifyAbout, Locale locale) {
                String leaderboardDescription = SailingNotificationServiceImpl.this.calculateLeaderboardDescription(locale, event, leaderboard);
                return new NotificationMailTemplate(SailingNotificationServiceImpl.this.messages.get(locale, "boatClassScoreCorrectionSubject", new String[]{boatClass.getName()}), SailingNotificationServiceImpl.this.messages.get(locale, "boatClassScoreCorrectionBody", new String[]{boatClass.getName(), leaderboardDescription}), RaceBoardLinkFactory.getBaseURL(event), SailingNotificationServiceImpl.this.createHomeLeaderboardLink(leaderboard, event, locale));
            }
        }));
    }

    @Override
    public void notifyUserOnBoatClassUpcomingRace(final BoatClass boatClass, final Leaderboard leaderboard, final RaceColumn raceColumn, final Fleet fleet, final TimePoint when) {
        this.doWithEvent(leaderboard, (event, leaderboardGroup) -> this.mailQueue.addNotification((MailNotification)new NotificationSetNotification<BoatClass>(boatClass, (PreferenceObjectBasedNotificationSet)this.boatClassUpcomingRace){

            @Override
            protected NotificationMailTemplate getMailTemplate(BoatClass objectToNotifyAbout, Locale locale) {
                String raceDescription = SailingNotificationServiceImpl.this.calculateRaceDescription(locale, event, leaderboard, raceColumn, fleet);
                String time = DateFormat.getDateTimeInstance(2, 1, locale).format(when.asDate());
                return new NotificationMailTemplate(SailingNotificationServiceImpl.this.messages.get(locale, "boatClassUpcomingRaceSubject", new String[]{boatClass.getName()}), SailingNotificationServiceImpl.this.messages.get(locale, "boatClassUpcomingRaceBody", new String[]{boatClass.getName(), raceDescription, time}), RaceBoardLinkFactory.getBaseURL(event), SailingNotificationServiceImpl.this.createHomeRacesListLink(leaderboard, event, locale));
            }
        }));
    }

    @Override
    public void notifyUserOnCompetitorPassesFinish(final Competitor competitor, final TrackedRace trackedRace, final Leaderboard leaderboard, final RaceColumn raceColumn, final Fleet fleet) {
        this.doWithEvent(leaderboard, (event, leaderboardGroup) -> this.mailQueue.addNotification((MailNotification)new NotificationSetNotification<String>(competitor.getId().toString(), (PreferenceObjectBasedNotificationSet)this.competitorResults){

            @Override
            protected NotificationMailTemplate getMailTemplate(String objectToNotifyAbout, Locale locale) {
                String raceDescription = SailingNotificationServiceImpl.this.calculateRaceDescription(locale, event, leaderboard, raceColumn, fleet);
                return new NotificationMailTemplate(SailingNotificationServiceImpl.this.messages.get(locale, "competitorPassesFinishSubject", new String[]{competitor.getName()}), SailingNotificationServiceImpl.this.messages.get(locale, "competitorPassesFinishBody", new String[]{competitor.getName(), raceDescription}), RaceBoardLinkFactory.getBaseURL(event), SailingNotificationServiceImpl.this.createRaceBoardShowRaceLink(trackedRace, leaderboard, event, leaderboardGroup, locale), SailingNotificationServiceImpl.this.createRaceBoardRaceAnalysisLink(trackedRace, leaderboard, event, leaderboardGroup, locale));
            }
        }));
    }

    @Override
    public void notifyUserOnCompetitorScoreCorrections(final Competitor competitor, final Leaderboard leaderboard) {
        this.doWithEvent(leaderboard, (event, leaderboardGroup) -> this.mailQueue.addNotification((MailNotification)new NotificationSetNotification<String>(competitor.getId().toString(), (PreferenceObjectBasedNotificationSet)this.competitorResults){

            @Override
            protected NotificationMailTemplate getMailTemplate(String objectToNotifyAbout, Locale locale) {
                String leaderboardDescription = SailingNotificationServiceImpl.this.calculateLeaderboardDescription(locale, event, leaderboard);
                return new NotificationMailTemplate(SailingNotificationServiceImpl.this.messages.get(locale, "competitorScoreCorrectionSubject", new String[]{competitor.getName()}), SailingNotificationServiceImpl.this.messages.get(locale, "competitorScoreCorrectionBody", new String[]{competitor.getName(), leaderboardDescription}), RaceBoardLinkFactory.getBaseURL(event), SailingNotificationServiceImpl.this.createHomeLeaderboardLink(leaderboard, event, locale));
            }
        }));
    }
}

